/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.grpc;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.protobuf.GeneratedMessageV3;
import com.navercorp.pinpoint.grpc.client.ChannelFactory;
import com.navercorp.pinpoint.grpc.client.ChannelFactoryBuilder;
import com.navercorp.pinpoint.grpc.client.DefaultChannelFactoryBuilder;
import com.navercorp.pinpoint.grpc.client.HeaderFactory;
import com.navercorp.pinpoint.grpc.client.UnaryCallDeadlineInterceptor;
import com.navercorp.pinpoint.grpc.client.config.ClientOption;
import com.navercorp.pinpoint.grpc.client.config.SslOption;
import com.navercorp.pinpoint.grpc.client.interceptor.DiscardClientInterceptor;
import com.navercorp.pinpoint.grpc.client.interceptor.DiscardEventListener;
import com.navercorp.pinpoint.grpc.client.interceptor.LoggingDiscardEventListener;
import com.navercorp.pinpoint.profiler.context.SpanType;
import com.navercorp.pinpoint.profiler.context.grpc.config.GrpcTransportConfig;
import com.navercorp.pinpoint.profiler.context.module.SpanDataSender;
import com.navercorp.pinpoint.profiler.context.thrift.MessageConverter;
import com.navercorp.pinpoint.profiler.sender.DataSender;
import com.navercorp.pinpoint.profiler.sender.grpc.ReconnectExecutor;
import com.navercorp.pinpoint.profiler.sender.grpc.SimpleStreamState;
import com.navercorp.pinpoint.profiler.sender.grpc.SpanGrpcDataSender;
import com.navercorp.pinpoint.profiler.sender.grpc.metric.ChannelzScheduledReporter;
import com.navercorp.pinpoint.profiler.sender.grpc.metric.DefaultChannelzReporter;
import io.grpc.ClientInterceptor;
import io.grpc.NameResolverProvider;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpanGrpcDataSenderProvider
implements Provider<DataSender<SpanType>> {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final GrpcTransportConfig grpcTransportConfig;
    private final MessageConverter<SpanType, GeneratedMessageV3> messageConverter;
    private final HeaderFactory headerFactory;
    private final Provider<ReconnectExecutor> reconnectExecutor;
    private final NameResolverProvider nameResolverProvider;
    private final ChannelzScheduledReporter reporter;
    private List<ClientInterceptor> clientInterceptorList;
    public static final String SPAN_CHANNELZ = "com.navercorp.pinpoint.metric.SpanChannel";

    @Inject
    public SpanGrpcDataSenderProvider(GrpcTransportConfig grpcTransportConfig, @SpanDataSender MessageConverter<SpanType, GeneratedMessageV3> messageConverter, HeaderFactory headerFactory, Provider<ReconnectExecutor> reconnectExecutor, NameResolverProvider nameResolverProvider, ChannelzScheduledReporter reporter) {
        this.grpcTransportConfig = Objects.requireNonNull(grpcTransportConfig, "grpcTransportConfig");
        this.messageConverter = Objects.requireNonNull(messageConverter, "messageConverter");
        this.headerFactory = Objects.requireNonNull(headerFactory, "headerFactory");
        this.reconnectExecutor = Objects.requireNonNull(reconnectExecutor, "reconnectExecutor");
        this.nameResolverProvider = Objects.requireNonNull(nameResolverProvider, "nameResolverProvider");
        this.reporter = Objects.requireNonNull(reporter, "reporter");
    }

    @Inject(optional=true)
    public void setClientInterceptor(@SpanDataSender List<ClientInterceptor> clientInterceptorList) {
        this.clientInterceptorList = Objects.requireNonNull(clientInterceptorList, "clientInterceptorList");
    }

    public DataSender<SpanType> get() {
        String collectorIp = this.grpcTransportConfig.getSpanCollectorIp();
        int collectorPort = this.grpcTransportConfig.getSpanCollectorPort();
        boolean sslEnable = this.grpcTransportConfig.isSpanSslEnable();
        int senderExecutorQueueSize = this.grpcTransportConfig.getSpanSenderExecutorQueueSize();
        ChannelFactoryBuilder channelFactoryBuilder = this.newChannelFactoryBuilder(sslEnable);
        ChannelFactory channelFactory = channelFactoryBuilder.build();
        ReconnectExecutor reconnectExecutor = (ReconnectExecutor)this.reconnectExecutor.get();
        ClientOption spanClientOption = this.grpcTransportConfig.getSpanClientOption();
        SimpleStreamState failState = new SimpleStreamState(spanClientOption.getLimitCount(), spanClientOption.getLimitTime());
        this.logger.info("failState:{}", (Object)failState);
        SpanGrpcDataSender spanGrpcDataSender = new SpanGrpcDataSender(collectorIp, collectorPort, senderExecutorQueueSize, this.messageConverter, reconnectExecutor, channelFactory, failState);
        this.registerChannelzReporter(spanGrpcDataSender);
        return spanGrpcDataSender;
    }

    private void registerChannelzReporter(SpanGrpcDataSender spanGrpcDataSender) {
        Logger statChannelLogger = LogManager.getLogger((String)SPAN_CHANNELZ);
        DefaultChannelzReporter statReporter = new DefaultChannelzReporter(statChannelLogger);
        this.reporter.registerRootChannel(spanGrpcDataSender.getLogId(), statReporter);
    }

    private ChannelFactoryBuilder newChannelFactoryBuilder(boolean sslEnable) {
        int channelExecutorQueueSize = this.grpcTransportConfig.getSpanChannelExecutorQueueSize();
        ClientOption clientOption = this.grpcTransportConfig.getSpanClientOption();
        DefaultChannelFactoryBuilder channelFactoryBuilder = new DefaultChannelFactoryBuilder("SpanGrpcDataSender");
        channelFactoryBuilder.setHeaderFactory(this.headerFactory);
        channelFactoryBuilder.setNameResolverProvider(this.nameResolverProvider);
        UnaryCallDeadlineInterceptor unaryCallDeadlineInterceptor = new UnaryCallDeadlineInterceptor(this.grpcTransportConfig.getSpanRequestTimeout());
        channelFactoryBuilder.addClientInterceptor((ClientInterceptor)unaryCallDeadlineInterceptor);
        if (this.clientInterceptorList != null) {
            for (ClientInterceptor clientInterceptor : this.clientInterceptorList) {
                this.logger.info("addClientInterceptor:{}", (Object)clientInterceptor);
                channelFactoryBuilder.addClientInterceptor(clientInterceptor);
            }
        }
        channelFactoryBuilder.setExecutorQueueSize(channelExecutorQueueSize);
        channelFactoryBuilder.setClientOption(clientOption);
        if (sslEnable) {
            SslOption sslOption = this.grpcTransportConfig.getSslOption();
            channelFactoryBuilder.setSslOption(sslOption);
        }
        return channelFactoryBuilder;
    }

    private ClientInterceptor newDiscardClientInterceptor() {
        int spanDiscardLogRateLimit = this.grpcTransportConfig.getSpanDiscardLogRateLimit();
        long spanDiscardMaxPendingThreshold = this.grpcTransportConfig.getSpanDiscardMaxPendingThreshold();
        long spanDiscardCountForReconnect = this.grpcTransportConfig.getSpanDiscardCountForReconnect();
        long spanNotReadyTimeoutMillis = this.grpcTransportConfig.getSpanNotReadyTimeoutMillis();
        LoggingDiscardEventListener discardEventListener = new LoggingDiscardEventListener(SpanGrpcDataSender.class.getName(), (long)spanDiscardLogRateLimit);
        return new DiscardClientInterceptor((DiscardEventListener)discardEventListener, spanDiscardMaxPendingThreshold, spanDiscardCountForReconnect, spanNotReadyTimeoutMillis);
    }
}

