/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.grpc;

import com.google.protobuf.GeneratedMessageV3;
import com.navercorp.pinpoint.grpc.trace.PCmdActiveThreadCount;
import com.navercorp.pinpoint.grpc.trace.PCmdActiveThreadDump;
import com.navercorp.pinpoint.grpc.trace.PCmdActiveThreadLightDump;
import com.navercorp.pinpoint.grpc.trace.PCmdEcho;
import com.navercorp.pinpoint.profiler.context.thrift.MessageConverter;
import com.navercorp.pinpoint.thrift.dto.command.TCmdActiveThreadCount;
import com.navercorp.pinpoint.thrift.dto.command.TCmdActiveThreadDump;
import com.navercorp.pinpoint.thrift.dto.command.TCmdActiveThreadLightDump;
import com.navercorp.pinpoint.thrift.dto.command.TCommandEcho;

public class CommandThriftToGrpcMessageConverter
implements MessageConverter<Object, GeneratedMessageV3> {
    @Override
    public GeneratedMessageV3 toMessage(Object message) {
        if (message instanceof TCommandEcho) {
            return this.buildPCommandEcho((TCommandEcho)message);
        }
        if (message instanceof TCmdActiveThreadCount) {
            return this.buildPCmdActiveThreadCount((TCmdActiveThreadCount)message);
        }
        if (message instanceof TCmdActiveThreadDump) {
            return this.buildPCmdActiveThreadDump((TCmdActiveThreadDump)message);
        }
        if (message instanceof TCmdActiveThreadLightDump) {
            return this.buildPCmdActiveThreadLightDump((TCmdActiveThreadLightDump)message);
        }
        return null;
    }

    private PCmdEcho buildPCommandEcho(TCommandEcho tCommandEcho) {
        PCmdEcho.Builder builder = PCmdEcho.newBuilder();
        builder.setMessage(tCommandEcho.getMessage());
        return builder.build();
    }

    private PCmdActiveThreadCount buildPCmdActiveThreadCount(TCmdActiveThreadCount tCmdActiveThreadCount) {
        PCmdActiveThreadCount.Builder builder = PCmdActiveThreadCount.newBuilder();
        return builder.build();
    }

    private PCmdActiveThreadDump buildPCmdActiveThreadDump(TCmdActiveThreadDump tCmdActiveThreadDump) {
        PCmdActiveThreadDump.Builder builder = PCmdActiveThreadDump.newBuilder();
        builder.setLimit(tCmdActiveThreadDump.getLimit());
        if (tCmdActiveThreadDump.isSetLocalTraceIdList()) {
            builder.addAllLocalTraceId((Iterable)tCmdActiveThreadDump.getLocalTraceIdList());
        }
        if (tCmdActiveThreadDump.isSetThreadNameList()) {
            builder.addAllThreadName((Iterable)tCmdActiveThreadDump.getThreadNameList());
        }
        return builder.build();
    }

    private PCmdActiveThreadLightDump buildPCmdActiveThreadLightDump(TCmdActiveThreadLightDump tCmdActiveThreadLightDump) {
        PCmdActiveThreadLightDump.Builder builder = PCmdActiveThreadLightDump.newBuilder();
        builder.setLimit(tCmdActiveThreadLightDump.getLimit());
        if (tCmdActiveThreadLightDump.isSetLocalTraceIdList()) {
            builder.addAllLocalTraceId((Iterable)tCmdActiveThreadLightDump.getLocalTraceIdList());
        }
        if (tCmdActiveThreadLightDump.isSetThreadNameList()) {
            builder.addAllThreadName((Iterable)tCmdActiveThreadLightDump.getThreadNameList());
        }
        return builder.build();
    }
}

