/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.errorhandler;

import com.navercorp.pinpoint.profiler.context.errorhandler.IgnoreErrorHandler;
import com.navercorp.pinpoint.profiler.context.errorhandler.MessageMatcher;
import com.navercorp.pinpoint.profiler.context.errorhandler.ThrowableMatcher;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultIgnoreErrorHandler
implements IgnoreErrorHandler {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final String errorHandlerName;
    private final ThrowableMatcher throwableMatcher;
    private final MessageMatcher messageMatcher;

    public DefaultIgnoreErrorHandler(String errorHandlerName, ThrowableMatcher throwableMatcher, MessageMatcher messageMatcher) {
        this.errorHandlerName = Objects.requireNonNull(errorHandlerName, "errorHandlerName");
        this.throwableMatcher = Objects.requireNonNull(throwableMatcher, "throwableMatcher");
        this.messageMatcher = Objects.requireNonNull(messageMatcher, "messageMatcher");
    }

    @Override
    public boolean handleError(Throwable th) {
        if (th == null) {
            return false;
        }
        Class<?> thClass = th.getClass();
        if (this.throwableMatcher.match(thClass) && this.messageMatcher.match(th.getMessage())) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Ignore Exception th:{} handler:{},", (Object)th, (Object)this);
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return "DefaultIgnoreErrorHandler{errorHandlerName='" + this.errorHandlerName + '\'' + ", throwableMatcher=" + this.throwableMatcher + ", messageMatcher=" + this.messageMatcher + '}';
    }
}

