/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.registry.nacos.service;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.client.naming.NacosNamingService;
import com.alibaba.nacos.common.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.exception.RegistryException;
import org.apache.eventmesh.api.registry.RegistryService;
import org.apache.eventmesh.api.registry.dto.EventMeshDataInfo;
import org.apache.eventmesh.api.registry.dto.EventMeshRegisterInfo;
import org.apache.eventmesh.api.registry.dto.EventMeshUnRegisterInfo;
import org.apache.eventmesh.common.config.CommonConfiguration;
import org.apache.eventmesh.common.utils.ConfigurationContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosRegistryService
implements RegistryService {
    private static final Logger log = LoggerFactory.getLogger(NacosRegistryService.class);
    private final AtomicBoolean initStatus = new AtomicBoolean(false);
    private final AtomicBoolean startStatus = new AtomicBoolean(false);
    private String serverAddr;
    private String username;
    private String password;
    private NamingService namingService;
    private ConcurrentMap<String, EventMeshRegisterInfo> eventMeshRegisterInfoMap;

    public void init() throws RegistryException {
        if (!this.initStatus.compareAndSet(false, true)) {
            return;
        }
        this.eventMeshRegisterInfoMap = new ConcurrentHashMap<String, EventMeshRegisterInfo>(ConfigurationContextUtil.KEYS.size());
        for (String key : ConfigurationContextUtil.KEYS) {
            CommonConfiguration commonConfiguration = ConfigurationContextUtil.get((String)key);
            if (null == commonConfiguration) continue;
            if (StringUtils.isBlank((CharSequence)commonConfiguration.getNamesrvAddr())) {
                throw new RegistryException("namesrvAddr cannot be null");
            }
            this.serverAddr = commonConfiguration.getNamesrvAddr();
            this.username = commonConfiguration.getEventMeshRegistryPluginUsername();
            this.password = commonConfiguration.getEventMeshRegistryPluginPassword();
            break;
        }
    }

    public void start() throws RegistryException {
        if (!this.startStatus.compareAndSet(false, true)) {
            return;
        }
        try {
            Properties properties = new Properties();
            properties.setProperty("serverAddr", this.serverAddr);
            properties.setProperty("username", this.username);
            properties.setProperty("password", this.password);
            this.namingService = new NacosNamingService(properties);
        }
        catch (NacosException e) {
            log.error("[NacosRegistryService][start] error", (Throwable)e);
            throw new RegistryException(e.getMessage());
        }
    }

    public void shutdown() throws RegistryException {
        if (!this.initStatus.compareAndSet(true, false)) {
            return;
        }
        if (!this.startStatus.compareAndSet(true, false)) {
            return;
        }
        try {
            this.namingService.shutDown();
        }
        catch (NacosException e) {
            log.error("[NacosRegistryService][shutdown] error", (Throwable)e);
            throw new RegistryException(e.getMessage());
        }
        log.info("NacosRegistryService close");
    }

    public List<EventMeshDataInfo> findEventMeshInfoByCluster(String clusterName) throws RegistryException {
        return this.findEventMeshInfos(true, Collections.singletonList(clusterName));
    }

    public List<EventMeshDataInfo> findAllEventMeshInfo() throws RegistryException {
        return this.findEventMeshInfos(false, null);
    }

    private List<EventMeshDataInfo> findEventMeshInfos(boolean inCluster, List<String> clusters) {
        ArrayList<EventMeshDataInfo> eventMeshDataInfoList = new ArrayList<EventMeshDataInfo>();
        for (String key : ConfigurationContextUtil.KEYS) {
            CommonConfiguration configuration = ConfigurationContextUtil.get((String)key);
            if (Objects.isNull(configuration)) continue;
            String eventMeshName = configuration.getEventMeshName();
            try {
                List instances = this.namingService.selectInstances(eventMeshName + "-" + key, key + "-" + (inCluster ? configuration.getEventMeshCluster() : "GROUP"), clusters, true);
                if (CollectionUtils.isEmpty((Collection)instances)) continue;
                for (Instance instance : instances) {
                    EventMeshDataInfo eventMeshDataInfo = new EventMeshDataInfo(instance.getClusterName(), instance.getServiceName(), instance.getIp() + ":" + instance.getPort(), 0L, instance.getMetadata());
                    eventMeshDataInfoList.add(eventMeshDataInfo);
                }
            }
            catch (NacosException e) {
                log.error("[NacosRegistryService][findEventMeshInfoByCluster] error", (Throwable)e);
                throw new RegistryException(e.getMessage());
            }
        }
        return eventMeshDataInfoList;
    }

    public void registerMetadata(Map<String, String> metadataMap) {
        for (Map.Entry eventMeshRegisterInfo : this.eventMeshRegisterInfoMap.entrySet()) {
            EventMeshRegisterInfo registerInfo = (EventMeshRegisterInfo)eventMeshRegisterInfo.getValue();
            registerInfo.setMetadata(metadataMap);
            this.register(registerInfo);
        }
    }

    public boolean register(EventMeshRegisterInfo eventMeshRegisterInfo) throws RegistryException {
        try {
            String[] ipPort = eventMeshRegisterInfo.getEndPoint().split(":");
            if (ipPort == null || ipPort.length < 2) {
                return false;
            }
            String eventMeshClusterName = eventMeshRegisterInfo.getEventMeshClusterName();
            Map metadata = eventMeshRegisterInfo.getMetadata();
            Instance instance = new Instance();
            instance.setIp(ipPort[0]);
            instance.setPort(Integer.parseInt(ipPort[1]));
            instance.setWeight(1.0);
            instance.setClusterName(eventMeshClusterName);
            instance.setMetadata(metadata);
            String eventMeshName = eventMeshRegisterInfo.getEventMeshName();
            this.namingService.registerInstance(eventMeshName, eventMeshRegisterInfo.getProtocolType() + "-" + "GROUP", instance);
            this.eventMeshRegisterInfoMap.put(eventMeshName, eventMeshRegisterInfo);
        }
        catch (NacosException e) {
            log.error("[NacosRegistryService][register] error", (Throwable)e);
            throw new RegistryException(e.getMessage());
        }
        log.info("EventMesh successfully registered to nacos");
        return true;
    }

    public boolean unRegister(EventMeshUnRegisterInfo eventMeshUnRegisterInfo) throws RegistryException {
        String[] ipPort = eventMeshUnRegisterInfo.getEndPoint().split(":");
        try {
            Instance instance = new Instance();
            instance.setIp(ipPort[0]);
            instance.setPort(Integer.parseInt(ipPort[1]));
            String eventMeshName = eventMeshUnRegisterInfo.getEventMeshName();
            String eventMeshClusterName = eventMeshUnRegisterInfo.getEventMeshClusterName();
            instance.setClusterName(eventMeshClusterName);
            this.namingService.deregisterInstance(eventMeshName, eventMeshUnRegisterInfo.getProtocolType() + "-" + "GROUP", instance);
            this.eventMeshRegisterInfoMap.remove(eventMeshName);
        }
        catch (NacosException e) {
            log.error("[NacosRegistryService][unRegister] error", (Throwable)e);
            throw new RegistryException(e.getMessage());
        }
        log.info("EventMesh successfully logout to nacos");
        return true;
    }

    public String getServerAddr() {
        return this.serverAddr;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public NamingService getNamingService() {
        return this.namingService;
    }
}

