/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.ldif;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.directory.api.asn1.util.Oid;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.ldif.ChangeType;
import org.apache.directory.api.ldap.model.ldif.LdapLdifException;
import org.apache.directory.api.ldap.model.ldif.LdifControl;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.name.Ava;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.util.Base64;
import org.apache.directory.api.util.Chars;
import org.apache.directory.api.util.Strings;
import org.apache.directory.api.util.exception.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdifReader
implements Iterable<LdifEntry>,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(LdifReader.class);
    protected List<String> lines;
    protected int position;
    protected static final int DEFAULT_VERSION = 1;
    protected int version;
    protected static final int LDIF_ENTRY = 0;
    protected static final int CHANGE = 1;
    protected static final int UNKNOWN = 2;
    protected long sizeLimit = 1024000L;
    protected static final long SIZE_LIMIT_DEFAULT = 1024000L;
    protected static final int MOD_SPEC = 0;
    protected static final int ATTRVAL_SPEC = 1;
    protected static final int ATTRVAL_SPEC_OR_SEP = 2;
    protected LdifEntry prefetched;
    protected Reader reader;
    private InputStream is;
    protected boolean containsEntries;
    protected boolean containsChanges;
    protected SchemaManager schemaManager;
    protected Exception error;
    protected int entryLen = 0;
    protected long entryOffset = 0L;
    protected long offset = 0L;
    protected int lineNumber;
    protected boolean validateDn = true;
    private int oidCounter = 0;

    public LdifReader() {
        this.lines = new ArrayList<String>();
        this.position = 0;
        this.version = 1;
    }

    public LdifReader(SchemaManager schemaManager) {
        this.lines = new ArrayList<String>();
        this.position = 0;
        this.version = 1;
        this.schemaManager = schemaManager;
    }

    public LdifReader(String ldifFileName) throws LdapLdifException {
        this(new File(ldifFileName));
    }

    public LdifReader(Reader in) throws LdapException {
        this.initReader(new BufferedReader(in));
    }

    public LdifReader(InputStream in) throws LdapException {
        this.initReader(new BufferedReader(new InputStreamReader(in, Charset.defaultCharset())));
    }

    public LdifReader(File file) throws LdapLdifException {
        this(file, null);
    }

    public LdifReader(File file, SchemaManager schemaManager) throws LdapLdifException {
        if (!file.exists()) {
            String msg = I18n.err((I18n)I18n.ERR_13443_CANNOT_FIND_FILE, (Object[])new Object[]{file.getAbsoluteFile()});
            LOG.error(msg);
            throw new LdapLdifException(msg);
        }
        if (!file.canRead()) {
            String msg = I18n.err((I18n)I18n.ERR_13444_CANNOT_READ_FILE, (Object[])new Object[]{file.getName()});
            LOG.error(msg);
            throw new LdapLdifException(msg);
        }
        this.schemaManager = schemaManager;
        try {
            this.is = Files.newInputStream(Paths.get(file.getPath(), new String[0]), new OpenOption[0]);
            this.initReader(new BufferedReader(new InputStreamReader(this.is, Charset.defaultCharset())));
        }
        catch (FileNotFoundException fnfe) {
            String msg = I18n.err((I18n)I18n.ERR_13443_CANNOT_FIND_FILE, (Object[])new Object[]{file.getAbsoluteFile()});
            LOG.error(msg);
            throw new LdapLdifException(msg, fnfe);
        }
        catch (LdapInvalidDnException lide) {
            throw new LdapLdifException(lide.getMessage(), lide);
        }
        catch (IOException ioe) {
            throw new LdapLdifException(ioe.getMessage(), ioe);
        }
        catch (LdapException le) {
            throw new LdapLdifException(le.getMessage(), le);
        }
    }

    private void initReader(BufferedReader reader) throws LdapException {
        this.reader = reader;
        this.init();
    }

    public void init() throws LdapException {
        this.lines = new ArrayList<String>();
        this.position = 0;
        this.version = 1;
        this.containsChanges = false;
        this.containsEntries = false;
        this.version = this.parseVersion();
        this.prefetched = this.parseEntry();
    }

    public int getVersion() {
        return this.version;
    }

    public long getSizeLimit() {
        return this.sizeLimit;
    }

    public void setSizeLimit(long sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    private void parseFill(char[] document) {
        while (Chars.isCharASCII((char[])document, (int)this.position, (char)' ')) {
            ++this.position;
        }
    }

    private String parseNumber(char[] document) {
        int initPos = this.position;
        while (Chars.isDigit((char[])document, (int)this.position)) {
            ++this.position;
        }
        if (this.position == initPos) {
            return null;
        }
        return new String(document, initPos, this.position - initPos);
    }

    protected ChangeType parseChangeType(String line) {
        ChangeType operation = ChangeType.Add;
        String modOp = Strings.trim((String)line.substring("changetype:".length()));
        if ("add".equalsIgnoreCase(modOp)) {
            operation = ChangeType.Add;
        } else if ("delete".equalsIgnoreCase(modOp)) {
            operation = ChangeType.Delete;
        } else if ("modify".equalsIgnoreCase(modOp)) {
            operation = ChangeType.Modify;
        } else if ("moddn".equalsIgnoreCase(modOp)) {
            operation = ChangeType.ModDn;
        } else if ("modrdn".equalsIgnoreCase(modOp)) {
            operation = ChangeType.ModRdn;
        }
        return operation;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String parseDn(String line) throws LdapLdifException {
        String dn;
        String lowerLine = Strings.toLowerCaseAscii((String)line);
        if (!lowerLine.startsWith("dn:") && !lowerLine.startsWith("Dn:")) {
            LOG.error(I18n.err((I18n)I18n.ERR_13405_DN_EXPECTED, (Object[])new Object[]{this.lineNumber}));
            throw new LdapLdifException(I18n.err((I18n)I18n.ERR_13445_NO_DN, (Object[])new Object[0]));
        }
        int length = line.length();
        if (length == 3) {
            dn = "";
        } else if (line.charAt(3) == ':') {
            if (length <= 4) {
                LOG.error(I18n.err((I18n)I18n.ERR_13404_EMPTY_DN_NOT_ALLOWED, (Object[])new Object[]{this.lineNumber}));
                throw new LdapLdifException(I18n.err((I18n)I18n.ERR_13445_NO_DN, (Object[])new Object[0]));
            }
            String trimmedLine = line.substring(4).trim();
            dn = Strings.utf8ToString((byte[])Base64.decode((char[])trimmedLine.toCharArray()));
        } else {
            dn = line.substring(3).trim();
        }
        if (this.validateDn && !Dn.isValid(dn)) {
            String message = I18n.err((I18n)I18n.ERR_13446_INVALID_DN, (Object[])new Object[]{dn, this.lineNumber});
            LOG.error(message);
            throw new LdapLdifException(message);
        }
        return dn;
    }

    protected static Object parseSimpleValue(String line, int pos) {
        if (line.length() > pos + 1) {
            char c = line.charAt(pos + 1);
            if (c == ':') {
                String value = Strings.trim((String)line.substring(pos + 2));
                return Base64.decode((char[])value.toCharArray());
            }
            return Strings.trim((String)line.substring(pos + 1));
        }
        return null;
    }

    private Object getValue(String attributeName, byte[] value) {
        if (this.schemaManager != null) {
            AttributeType attributeType = this.schemaManager.getAttributeType(attributeName);
            if (attributeType != null) {
                if (attributeType.getSyntax().isHumanReadable()) {
                    return Strings.utf8ToString((byte[])value);
                }
                return value;
            }
            return value;
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object parseValue(String attributeName, String line, int pos) throws LdapLdifException {
        char cc;
        if (line.length() <= pos + 1) return null;
        char c = line.charAt(pos + 1);
        if (c == ':') {
            String value = Strings.trim((String)line.substring(pos + 2));
            byte[] decoded = Base64.decode((char[])value.toCharArray());
            return this.getValue(attributeName, decoded);
        }
        if (c == '<') {
            String urlName = Strings.trim((String)line.substring(pos + 2));
            try {
                URL url = new URL(urlName);
                if (!"file".equals(url.getProtocol())) {
                    LOG.error(I18n.err((I18n)I18n.ERR_13408_BAD_PROTOCOL, (Object[])new Object[0]));
                    throw new LdapLdifException(I18n.err((I18n)I18n.ERR_13451_UNSUPPORTED_PROTOCOL, (Object[])new Object[]{this.lineNumber}));
                }
                String fileName = url.getFile();
                File file = new File(fileName);
                if (!file.exists()) {
                    LOG.error(I18n.err((I18n)I18n.ERR_13406_FILE_NOT_FOUND, (Object[])new Object[]{fileName, this.lineNumber}));
                    throw new LdapLdifException(I18n.err((I18n)I18n.ERR_13447_BAD_URL_FILE_NOT_FOUND, (Object[])new Object[0]));
                }
                long length = file.length();
                if (length > this.sizeLimit) {
                    String message = I18n.err((I18n)I18n.ERR_13448_FILE_TOO_BIG, (Object[])new Object[]{fileName, this.lineNumber});
                    LOG.error(message);
                    throw new LdapLdifException(message);
                }
                byte[] data = new byte[(int)length];
                try (DataInputStream inf = new DataInputStream(Files.newInputStream(Paths.get(fileName, new String[0]), new OpenOption[0]));){
                    inf.readFully(data);
                    Object object = this.getValue(attributeName, data);
                    return object;
                }
                catch (FileNotFoundException fnfe) {
                    LOG.error(I18n.err((I18n)I18n.ERR_13406_FILE_NOT_FOUND, (Object[])new Object[]{fileName, this.lineNumber}));
                    throw new LdapLdifException(I18n.err((I18n)I18n.ERR_13447_BAD_URL_FILE_NOT_FOUND, (Object[])new Object[0]), fnfe);
                }
                catch (IOException ioe) {
                    LOG.error(I18n.err((I18n)I18n.ERR_13407_ERROR_READING_FILE, (Object[])new Object[]{fileName, this.lineNumber}));
                    throw new LdapLdifException(I18n.err((I18n)I18n.ERR_13449_ERROR_READING_BAD_URL, (Object[])new Object[0]), ioe);
                }
            }
            catch (MalformedURLException mue) {
                String message = I18n.err((I18n)I18n.ERR_13452_BAD_URL, (Object[])new Object[]{urlName, this.lineNumber});
                LOG.error(message);
                throw new LdapLdifException(message, mue);
            }
        }
        String value = Strings.trimLeft((String)line.substring(pos + 1));
        int end = value.length();
        int i = value.length() - 1;
        while (i > 0 && (cc = value.charAt(i)) == ' ' && value.charAt(i - 1) != '\\') {
            end = i--;
        }
        String result = null;
        if (end <= 0) return result;
        return value.substring(0, end);
    }

    private Control parseControl(String line) throws LdapLdifException {
        String lowerLine = Strings.toLowerCaseAscii((String)line).trim();
        int pos = 0;
        char[] controlValue = line.trim().toCharArray();
        int length = controlValue.length;
        if (pos > length) {
            String msg = I18n.err((I18n)I18n.ERR_13409_CONTROL_WITHOUT_OID, (Object[])new Object[]{this.lineNumber});
            LOG.error(msg);
            throw new LdapLdifException(msg);
        }
        int initPos = pos;
        while (Chars.isCharASCII((char[])controlValue, (int)pos, (char)'.') || Chars.isDigit((char[])controlValue, (int)pos)) {
            ++pos;
        }
        if (pos == initPos) {
            String msg = I18n.err((I18n)I18n.ERR_13409_CONTROL_WITHOUT_OID, (Object[])new Object[]{this.lineNumber});
            LOG.error(msg);
            throw new LdapLdifException(msg);
        }
        String oidString = lowerLine.substring(0, pos);
        if (!Oid.isOid((String)oidString)) {
            String message = I18n.err((I18n)I18n.ERR_13453_INVALID_OID, (Object[])new Object[]{oidString, this.lineNumber});
            LOG.error(message);
            throw new LdapLdifException(message);
        }
        LdifControl control = new LdifControl(oidString);
        while (Chars.isCharASCII((char[])controlValue, (int)pos, (char)' ')) {
            ++pos;
        }
        int criticalPos = lowerLine.indexOf(58);
        int criticalLength = criticalPos == -1 ? length - pos : criticalPos - pos;
        if (criticalLength == 4 && "true".equalsIgnoreCase(lowerLine.substring(pos, pos + 4))) {
            control.setCritical(true);
        } else if (criticalLength == 5 && "false".equalsIgnoreCase(lowerLine.substring(pos, pos + 5))) {
            control.setCritical(false);
        } else if (criticalLength != 0) {
            String msg = I18n.err((I18n)I18n.ERR_13410_INVALID_CRITICALITY, (Object[])new Object[]{this.lineNumber});
            LOG.error(msg);
            throw new LdapLdifException(msg);
        }
        if (criticalPos > 0) {
            if (Chars.isCharASCII((char[])controlValue, (int)(criticalPos + 1), (char)':')) {
                pos = criticalPos + 2;
                while (Chars.isCharASCII((char[])controlValue, (int)pos, (char)' ')) {
                    ++pos;
                }
                byte[] value = Base64.decode((char[])line.substring(pos).toCharArray());
                control.setValue(value);
            } else {
                if (Chars.isCharASCII((char[])controlValue, (int)(criticalPos + 1), (char)'<')) {
                    throw new NotImplementedException(I18n.err((I18n)I18n.ERR_13433_SEE_DIRSERVER_1547, (Object[])new Object[0]));
                }
                pos = criticalPos + 1;
                while (Chars.isCharASCII((char[])controlValue, (int)pos, (char)' ')) {
                    ++pos;
                }
                byte[] value = new byte[length - pos];
                for (int i = 0; i < length - pos; ++i) {
                    value[i] = (byte)controlValue[i + pos];
                }
                control.setValue(value);
            }
        }
        return control;
    }

    public static Attribute parseAttributeValue(String line) {
        int colonIndex = line.indexOf(58);
        if (colonIndex != -1) {
            String attributeType = line.substring(0, colonIndex);
            Object attributeValue = LdifReader.parseSimpleValue(line, colonIndex);
            if (attributeValue instanceof String) {
                return new DefaultAttribute(attributeType, (String)attributeValue);
            }
            return new DefaultAttribute(attributeType, (byte[][])new byte[][]{(byte[])attributeValue});
        }
        return null;
    }

    public void parseAttributeValue(LdifEntry entry, String line, String lowerLine) throws LdapException {
        block10: {
            AttributeType at;
            int colonIndex = line.indexOf(58);
            String attributeType = line.substring(0, colonIndex);
            String attributeTypeLower = lowerLine.substring(0, colonIndex);
            if ("dn".equals(attributeTypeLower)) {
                LOG.error(I18n.err((I18n)I18n.ERR_13400_ENTRY_WITH_TWO_DNS, (Object[])new Object[]{this.lineNumber}));
                throw new LdapLdifException(I18n.err((I18n)I18n.ERR_13439_LDIF_ENTRY_WITH_TWO_DNS, (Object[])new Object[0]));
            }
            Object attributeValue = this.parseValue(attributeType, line, colonIndex);
            if (this.schemaManager != null && (at = this.schemaManager.getAttributeType(attributeType)) != null) {
                if (at.getSyntax().isHumanReadable()) {
                    if (attributeValue == null) {
                        attributeValue = "";
                    } else if (attributeValue instanceof byte[]) {
                        attributeValue = Strings.utf8ToString((byte[])((byte[])attributeValue));
                    }
                } else if (attributeValue instanceof String) {
                    attributeValue = Strings.getBytesUtf8((String)((String)attributeValue));
                }
            }
            try {
                entry.addAttribute(attributeType, attributeValue);
            }
            catch (Exception e) {
                if (this.schemaManager == null || !this.schemaManager.isRelaxed()) break block10;
                AttributeType newAttributeType = new AttributeType("1.3.6.1.4.1.18060.0.9999." + this.oidCounter++);
                newAttributeType.setNames(attributeType);
                newAttributeType.setSyntax((LdapSyntax)this.schemaManager.getLdapSyntaxRegistry().get("1.3.6.1.4.1.1466.115.121.1.15"));
                this.schemaManager.add(newAttributeType);
                entry.addAttribute(attributeType, attributeValue);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseModRdn(LdifEntry entry, Iterator<String> iter) throws LdapLdifException {
        if (!iter.hasNext()) {
            String msg = I18n.err((I18n)I18n.ERR_13411_BAD_MODRDN_OPERATION, (Object[])new Object[]{this.lineNumber});
            LOG.error(msg);
            throw new LdapLdifException(msg);
        }
        String line = iter.next();
        String lowerLine = Strings.toLowerCaseAscii((String)line);
        if (!lowerLine.startsWith("newrdn::") && !lowerLine.startsWith("newrdn:")) {
            String msg = I18n.err((I18n)I18n.ERR_13411_BAD_MODRDN_OPERATION, (Object[])new Object[]{this.lineNumber});
            LOG.error(msg);
            throw new LdapLdifException(msg);
        }
        int colonIndex = line.indexOf(58);
        Object attributeValue = this.parseValue(null, line, colonIndex);
        if (attributeValue instanceof String) {
            entry.setNewRdn((String)attributeValue);
        } else {
            entry.setNewRdn(Strings.utf8ToString((byte[])((byte[])attributeValue)));
        }
        if (!iter.hasNext()) {
            String msg = I18n.err((I18n)I18n.ERR_13412_NO_DELETEOLDRDN, (Object[])new Object[]{this.lineNumber});
            LOG.error(msg);
            throw new LdapLdifException(msg);
        }
        line = iter.next();
        lowerLine = Strings.toLowerCaseAscii((String)line);
        if (lowerLine.startsWith("deleteoldrdn:")) {
            colonIndex = line.indexOf(58);
            attributeValue = this.parseValue(null, line, colonIndex);
            entry.setDeleteOldRdn("1".equals(attributeValue));
            return;
        }
        String msg = I18n.err((I18n)I18n.ERR_13412_NO_DELETEOLDRDN, (Object[])new Object[]{this.lineNumber});
        LOG.error(msg);
        throw new LdapLdifException(msg);
    }

    private void parseModify(LdifEntry entry, Iterator<String> iter) throws LdapLdifException {
        int state = 0;
        String modified = null;
        ModificationOperation modificationType = ModificationOperation.ADD_ATTRIBUTE;
        DefaultAttribute attribute = null;
        boolean isEmptyValue = true;
        while (iter.hasNext()) {
            AttributeType attributeType;
            String line = iter.next();
            String lowerLine = Strings.toLowerCaseAscii((String)line);
            if (lowerLine.startsWith("-")) {
                if (state != 2 && state != 1) {
                    String msg = I18n.err((I18n)I18n.ERR_13413_BAD_MODIFY_SEPARATOR, (Object[])new Object[]{this.lineNumber});
                    LOG.error(msg);
                    throw new LdapLdifException(msg);
                }
                if (isEmptyValue) {
                    if (state == 2) {
                        entry.addModification(modificationType, modified);
                    } else {
                        entry.addModification(modificationType, modified, null);
                    }
                } else {
                    entry.addModification(modificationType, attribute);
                }
                state = 0;
                isEmptyValue = true;
                continue;
            }
            if (lowerLine.startsWith("add:")) {
                if (state != 0 && state != 1) {
                    String msg = I18n.err((I18n)I18n.ERR_13414_BAD_MODIFY_SEPARATOR_2, (Object[])new Object[]{this.lineNumber});
                    LOG.error(msg);
                    throw new LdapLdifException(msg);
                }
                modified = Strings.trim((String)line.substring("add:".length()));
                modificationType = ModificationOperation.ADD_ATTRIBUTE;
                attribute = new DefaultAttribute(modified);
                state = 1;
                continue;
            }
            if (lowerLine.startsWith("delete:")) {
                if (state != 0 && state != 1) {
                    String msg = I18n.err((I18n)I18n.ERR_13414_BAD_MODIFY_SEPARATOR_2, (Object[])new Object[]{this.lineNumber});
                    LOG.error(msg);
                    throw new LdapLdifException(msg);
                }
                modified = Strings.trim((String)line.substring("delete:".length()));
                modificationType = ModificationOperation.REMOVE_ATTRIBUTE;
                attribute = new DefaultAttribute(modified);
                isEmptyValue = false;
                state = 2;
                continue;
            }
            if (lowerLine.startsWith("replace:")) {
                if (state != 0 && state != 1) {
                    String msg = I18n.err((I18n)I18n.ERR_13414_BAD_MODIFY_SEPARATOR_2, (Object[])new Object[]{this.lineNumber});
                    LOG.error(msg);
                    throw new LdapLdifException(msg);
                }
                modified = Strings.trim((String)line.substring("replace:".length()));
                modificationType = ModificationOperation.REPLACE_ATTRIBUTE;
                if (this.schemaManager != null) {
                    attributeType = this.schemaManager.getAttributeType(modified);
                    attribute = new DefaultAttribute(modified, attributeType);
                } else {
                    attribute = new DefaultAttribute(modified);
                }
                state = 2;
                continue;
            }
            if (lowerLine.startsWith("increment:")) {
                if (state != 0 && state != 1) {
                    String msg = I18n.err((I18n)I18n.ERR_13414_BAD_MODIFY_SEPARATOR_2, (Object[])new Object[]{this.lineNumber});
                    LOG.error(msg);
                    throw new LdapLdifException(msg);
                }
                modified = Strings.trim((String)line.substring("increment:".length()));
                modificationType = ModificationOperation.INCREMENT_ATTRIBUTE;
                if (this.schemaManager != null) {
                    attributeType = this.schemaManager.getAttributeType(modified);
                    attribute = new DefaultAttribute(modified, attributeType);
                } else {
                    attribute = new DefaultAttribute(modified);
                }
                state = 2;
                continue;
            }
            if (state != 1 && state != 2) {
                String msg = I18n.err((I18n)I18n.ERR_13413_BAD_MODIFY_SEPARATOR, (Object[])new Object[]{this.lineNumber});
                LOG.error(msg);
                throw new LdapLdifException(msg);
            }
            int colonIndex = line.indexOf(58);
            String attributeType2 = line.substring(0, colonIndex);
            if (!attributeType2.equalsIgnoreCase(modified)) {
                LOG.error(I18n.err((I18n)I18n.ERR_13415_MOD_ATTR_AND_VALUE_SPEC_NOT_EQUAL, (Object[])new Object[]{this.lineNumber}));
                throw new LdapLdifException(I18n.err((I18n)I18n.ERR_13454_BAD_MODIFY_ATTRIBUTE, (Object[])new Object[0]));
            }
            if ("dn".equalsIgnoreCase(attributeType2)) {
                LOG.error(I18n.err((I18n)I18n.ERR_13400_ENTRY_WITH_TWO_DNS, (Object[])new Object[]{this.lineNumber}));
                throw new LdapLdifException(I18n.err((I18n)I18n.ERR_13439_LDIF_ENTRY_WITH_TWO_DNS, (Object[])new Object[0]));
            }
            Object attributeValue = this.parseValue(attributeType2, line, colonIndex);
            try {
                if (attributeValue instanceof String) {
                    attribute.add((String)attributeValue);
                } else {
                    attribute.add(new byte[][]{(byte[])attributeValue});
                }
            }
            catch (LdapInvalidAttributeValueException liave) {
                throw new LdapLdifException(liave.getMessage(), liave);
            }
            isEmptyValue = false;
            state = 2;
        }
        if (state != 0) {
            String msg = I18n.err((I18n)I18n.ERR_13414_BAD_MODIFY_SEPARATOR_2, (Object[])new Object[]{this.lineNumber});
            LOG.error(msg);
            throw new LdapLdifException(msg);
        }
    }

    private void parseChange(LdifEntry entry, Iterator<String> iter, ChangeType operation) throws LdapException {
        entry.setChangeType(operation);
        switch (operation) {
            case Delete: {
                return;
            }
            case Add: {
                while (iter.hasNext()) {
                    String line = iter.next();
                    String lowerLine = Strings.toLowerCaseAscii((String)line);
                    this.parseAttributeValue(entry, line, lowerLine);
                }
                return;
            }
            case Modify: {
                this.parseModify(entry, iter);
                return;
            }
            case ModDn: 
            case ModRdn: {
                this.parseModRdn(entry, iter);
                if (iter.hasNext()) {
                    String line = iter.next();
                    String lowerLine = Strings.toLowerCaseAscii((String)line);
                    if (lowerLine.startsWith("newsuperior:")) {
                        int colonIndex = line.indexOf(58);
                        Object attributeValue = this.parseValue(null, line, colonIndex);
                        if (attributeValue instanceof String) {
                            entry.setNewSuperior((String)attributeValue);
                        } else {
                            entry.setNewSuperior(Strings.utf8ToString((byte[])((byte[])attributeValue)));
                        }
                    } else if (operation == ChangeType.ModDn) {
                        LOG.error(I18n.err((I18n)I18n.ERR_13416_NEW_SUPERIOR_NEEDED, (Object[])new Object[]{this.lineNumber}));
                        throw new LdapLdifException(I18n.err((I18n)I18n.ERR_13455_BAD_MODDN_NO_SUPERIOR, (Object[])new Object[0]));
                    }
                }
                return;
            }
        }
        LOG.error(I18n.err((I18n)I18n.ERR_13417_UNKNOWN_OPERATION, (Object[])new Object[]{this.lineNumber}));
        throw new LdapLdifException(I18n.err((I18n)I18n.ERR_13456_BAD_OPERATION, (Object[])new Object[0]));
    }

    protected LdifEntry parseEntry() throws LdapException {
        if (this.lines == null || this.lines.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg((I18n)I18n.MSG_13408_END_OF_LDIF, (Object[])new Object[0]));
            }
            return null;
        }
        String line = this.lines.get(0);
        this.lineNumber -= this.lines.size() - 1;
        String name = this.parseDn(line);
        Dn dn = null;
        try {
            dn = new Dn(this.schemaManager, name);
        }
        catch (LdapInvalidDnException lide) {
            dn = new Dn(name);
            Rdn rdn = dn.getRdn();
            for (Ava ava : rdn) {
                if (this.schemaManager == null || this.schemaManager.getAttributeType(ava.getType()) != null || !this.schemaManager.isRelaxed()) continue;
                AttributeType newAttributeType = new AttributeType("1.3.6.1.4.1.18060.0.9999." + this.oidCounter++);
                newAttributeType.setNames(ava.getType());
                newAttributeType.setSyntax((LdapSyntax)this.schemaManager.getLdapSyntaxRegistry().get("1.3.6.1.4.1.1466.115.121.1.15"));
                this.schemaManager.add(newAttributeType);
            }
            dn = new Dn(this.schemaManager, name);
        }
        LdifEntry entry = this.createLdifEntry(this.schemaManager);
        entry.setLengthBeforeParsing(this.entryLen);
        entry.setOffset(this.entryOffset);
        entry.setDn(dn);
        this.lines.remove(0);
        Iterator<String> iter = this.lines.iterator();
        boolean type = false;
        boolean controlSeen = false;
        boolean changeTypeSeen = false;
        ChangeType operation = ChangeType.Add;
        while (iter.hasNext()) {
            ++this.lineNumber;
            line = iter.next();
            String lowerLine = Strings.toLowerCaseAscii((String)line);
            if (lowerLine.startsWith("control:")) {
                if (this.containsEntries) {
                    LOG.error(I18n.err((I18n)I18n.ERR_13401_CHANGE_NOT_ALLOWED, (Object[])new Object[]{this.lineNumber}));
                    throw new LdapLdifException(I18n.err((I18n)I18n.ERR_13440_NO_CHANGE, (Object[])new Object[0]));
                }
                this.containsChanges = true;
                if (controlSeen) {
                    LOG.error(I18n.err((I18n)I18n.ERR_13418_CONTROL_ALREADY_FOUND, (Object[])new Object[]{this.lineNumber}));
                    throw new LdapLdifException(I18n.err((I18n)I18n.ERR_13457_MISPLACED_CONTROL, (Object[])new Object[0]));
                }
                Control control = this.parseControl(line.substring("control:".length()));
                entry.addControl(control);
                continue;
            }
            if (lowerLine.startsWith("changetype:")) {
                if (this.containsEntries) {
                    LOG.error(I18n.err((I18n)I18n.ERR_13401_CHANGE_NOT_ALLOWED, (Object[])new Object[]{this.lineNumber}));
                    throw new LdapLdifException(I18n.err((I18n)I18n.ERR_13440_NO_CHANGE, (Object[])new Object[0]));
                }
                this.containsChanges = true;
                if (changeTypeSeen) {
                    LOG.error(I18n.err((I18n)I18n.ERR_13419_CHANGETYPE_ALREADY_FOUND, (Object[])new Object[]{this.lineNumber}));
                    throw new LdapLdifException(I18n.err((I18n)I18n.ERR_13458_MISPLACED_CHANGETYPE, (Object[])new Object[0]));
                }
                type = true;
                controlSeen = true;
                operation = this.parseChangeType(line);
                this.parseChange(entry, iter, operation);
                changeTypeSeen = true;
                continue;
            }
            if (line.indexOf(58) > 0) {
                if (this.containsChanges) {
                    LOG.error(I18n.err((I18n)I18n.ERR_13401_CHANGE_NOT_ALLOWED, (Object[])new Object[]{this.lineNumber}));
                    throw new LdapLdifException(I18n.err((I18n)I18n.ERR_13440_NO_CHANGE, (Object[])new Object[0]));
                }
                this.containsEntries = true;
                if (controlSeen || changeTypeSeen) {
                    LOG.error(I18n.err((I18n)I18n.ERR_13420_AT_VALUE_NOT_ALLOWED_AFTER_CONTROL, (Object[])new Object[]{this.lineNumber}));
                    throw new LdapLdifException(I18n.err((I18n)I18n.ERR_13459_MISPLACED_ATTRIBUTETYPE, (Object[])new Object[0]));
                }
                this.parseAttributeValue(entry, line, lowerLine);
                type = false;
                continue;
            }
            LOG.error(I18n.err((I18n)I18n.ERR_13421_ATTRIBUTE_TYPE_EXPECTED, (Object[])new Object[]{this.lineNumber}));
            throw new LdapLdifException(I18n.err((I18n)I18n.ERR_13460_BAD_ATTRIBUTE, (Object[])new Object[0]));
        }
        if (!type) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg((I18n)I18n.MSG_13406_READ_ENTRY, (Object[])new Object[]{entry}));
            }
        } else if (type) {
            entry.setChangeType(operation);
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg((I18n)I18n.MSG_13404_READ_MODIF, (Object[])new Object[]{entry}));
            }
        } else {
            LOG.error(I18n.err((I18n)I18n.ERR_13422_UNKNOWN_ENTRY_TYPE, (Object[])new Object[]{this.lineNumber}));
            throw new LdapLdifException(I18n.err((I18n)I18n.ERR_13461_UNKNOWN_ENTRY, (Object[])new Object[0]));
        }
        return entry;
    }

    protected int parseVersion() throws LdapLdifException {
        int ver = 1;
        this.readLines();
        if (this.lines.isEmpty()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn(I18n.msg((I18n)I18n.MSG_13414_LDIF_FILE_EMPTY, (Object[])new Object[0]));
            }
            return ver;
        }
        String line = this.lines.get(0);
        char[] document = line.toCharArray();
        if (line.startsWith("version:")) {
            this.position += "version:".length();
            this.parseFill(document);
            String versionNumber = this.parseNumber(document);
            if (this.position != document.length) {
                LOG.error(I18n.err((I18n)I18n.ERR_13423_VERSION_NOT_A_NUMBER, (Object[])new Object[]{this.lineNumber}));
                throw new LdapLdifException(I18n.err((I18n)I18n.ERR_13462_LDIF_PARSING_ERROR, (Object[])new Object[0]));
            }
            try {
                ver = Integer.parseInt(versionNumber);
            }
            catch (NumberFormatException nfe) {
                LOG.error(I18n.err((I18n)I18n.ERR_13423_VERSION_NOT_A_NUMBER, (Object[])new Object[]{this.lineNumber}));
                throw new LdapLdifException(I18n.err((I18n)I18n.ERR_13462_LDIF_PARSING_ERROR, (Object[])new Object[0]), nfe);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg((I18n)I18n.MSG_13400_LDIF_VERSION, (Object[])new Object[]{versionNumber}));
            }
            this.lines.remove(0);
            if (this.lines.isEmpty()) {
                int tmpEntryLen = this.entryLen;
                this.readLines();
                this.entryLen += tmpEntryLen;
            }
        } else if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg((I18n)I18n.MSG_13413_NO_VERSION_ASSUMING_1, (Object[])new Object[0]));
        }
        return ver;
    }

    protected String getLine() throws IOException {
        return ((BufferedReader)this.reader).readLine();
    }

    protected void readLines() throws LdapLdifException {
        boolean insideComment = true;
        boolean isFirstLine = true;
        this.lines.clear();
        this.entryLen = 0;
        this.entryOffset = this.offset;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            block6: while ((line = this.getLine()) != null) {
                ++this.lineNumber;
                if (line.length() == 0) {
                    if (isFirstLine) continue;
                    insideComment = false;
                    ++this.offset;
                    break;
                }
                switch (line.charAt(0)) {
                    case '#': {
                        insideComment = true;
                        break;
                    }
                    case ' ': {
                        isFirstLine = false;
                        if (insideComment) continue block6;
                        if (sb.length() == 0) {
                            LOG.error(I18n.err((I18n)I18n.ERR_13424_EMPTY_CONTINUATION_LINE, (Object[])new Object[]{this.lineNumber}));
                            throw new LdapLdifException(I18n.err((I18n)I18n.ERR_13462_LDIF_PARSING_ERROR, (Object[])new Object[0]));
                        }
                        sb.append(line.substring(1));
                        insideComment = false;
                        break;
                    }
                    default: {
                        isFirstLine = false;
                        if (sb.length() != 0) {
                            this.lines.add(sb.toString());
                        }
                        sb = new StringBuilder(line);
                        insideComment = false;
                    }
                }
                byte[] data = Strings.getBytesUtf8((String)line);
                this.offset += (long)(data.length + 1);
                this.entryLen += data.length + 1;
            }
        }
        catch (IOException ioe) {
            throw new LdapLdifException(I18n.err((I18n)I18n.ERR_13463_ERROR_WHILE_READING_LDIF_LINE, (Object[])new Object[0]), ioe);
        }
        if (sb.length() != 0) {
            this.lines.add(sb.toString());
        }
    }

    public List<LdifEntry> parseLdifFile(String fileName) throws LdapLdifException {
        return this.parseLdifFile(fileName, Strings.getDefaultCharsetName());
    }

    /*
     * Exception decompiling
     */
    public List<LdifEntry> parseLdifFile(String fileName, String encoding) throws LdapLdifException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<LdifEntry> parseLdif(String ldif) throws LdapLdifException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_13407_STARTS_PARSING_LDIF, (Object[])new Object[0]));
        }
        if (Strings.isEmpty((String)ldif)) {
            return new ArrayList<LdifEntry>();
        }
        try (BufferedReader bufferReader = new BufferedReader(new StringReader(ldif));){
            List<LdifEntry> entries = this.parseLdif(bufferReader);
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg((I18n)I18n.MSG_13403_PARSED_N_ENTRIES, (Object[])new Object[]{entries.size()}));
            }
            List<LdifEntry> list = entries;
            return list;
        }
        catch (LdapLdifException ne) {
            LOG.error(I18n.err((I18n)I18n.ERR_13428_CANNOT_PARSE_LDIF, (Object[])new Object[]{ne.getLocalizedMessage()}));
            throw new LdapLdifException(I18n.err((I18n)I18n.ERR_13442_ERROR_PARSING_LDIF_BUFFER, (Object[])new Object[0]), ne);
        }
        catch (LdapException le) {
            throw new LdapLdifException(le.getMessage(), le);
        }
        catch (IOException ioe) {
            throw new LdapLdifException(I18n.err((I18n)I18n.ERR_13450_CANNOT_CLOSE_FILE, (Object[])new Object[0]), ioe);
        }
    }

    private LdifEntry nextInternal() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg((I18n)I18n.MSG_13411_NEXT_CALLED, (Object[])new Object[0]));
            }
            LdifEntry entry = this.prefetched;
            this.readLines();
            try {
                this.prefetched = this.parseEntry();
            }
            catch (LdapLdifException ne) {
                this.error = ne;
                throw new NoSuchElementException(ne.getMessage());
            }
            catch (LdapException le) {
                throw new NoSuchElementException(le.getMessage());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg((I18n)I18n.MSG_13412_NEXT_RETURNING_LDIF, (Object[])new Object[]{entry}));
            }
            return entry;
        }
        catch (LdapLdifException ne) {
            LOG.error(I18n.err((I18n)I18n.ERR_13430_PREMATURE_LDIF_ITERATOR_TERMINATION, (Object[])new Object[0]));
            this.error = ne;
            return null;
        }
    }

    public LdifEntry next() {
        return this.nextInternal();
    }

    public LdifEntry fetch() {
        return this.prefetched;
    }

    private boolean hasNextInternal() {
        return null != this.prefetched;
    }

    public boolean hasNext() {
        if (LOG.isDebugEnabled()) {
            if (this.prefetched != null) {
                LOG.debug(I18n.msg((I18n)I18n.MSG_13410_HAS_NEXT_TRUE, (Object[])new Object[0]));
            } else {
                LOG.debug(I18n.msg((I18n)I18n.MSG_13409_HAS_NEXT_FALSE, (Object[])new Object[0]));
            }
        }
        return this.hasNextInternal();
    }

    private void removeInternal() {
        throw new UnsupportedOperationException();
    }

    public void remove() {
        this.removeInternal();
    }

    @Override
    public Iterator<LdifEntry> iterator() {
        return new Iterator<LdifEntry>(){

            @Override
            public boolean hasNext() {
                return LdifReader.this.hasNextInternal();
            }

            @Override
            public LdifEntry next() {
                try {
                    return LdifReader.this.nextInternal();
                }
                catch (NoSuchElementException nse) {
                    LOG.error(nse.getMessage());
                    return null;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean hasError() {
        return this.error != null;
    }

    public Exception getError() {
        return this.error;
    }

    public List<LdifEntry> parseLdif(BufferedReader reader) throws LdapException {
        ArrayList<LdifEntry> entries = new ArrayList<LdifEntry>();
        this.reader = reader;
        this.version = this.parseVersion();
        this.prefetched = this.parseEntry();
        for (LdifEntry entry : this) {
            if (entry != null) {
                entries.add(entry);
                continue;
            }
            throw new LdapLdifException(I18n.err((I18n)I18n.ERR_13429_ERROR_PARSING_LDIF, (Object[])new Object[]{this.error.getLocalizedMessage()}));
        }
        return entries;
    }

    public boolean containsEntries() {
        return this.containsEntries;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    protected LdifEntry createLdifEntry(SchemaManager schemaManager) {
        if (schemaManager != null) {
            return new LdifEntry(schemaManager);
        }
        return new LdifEntry();
    }

    public boolean isValidateDn() {
        return this.validateDn;
    }

    public void setValidateDn(boolean validateDn) {
        this.validateDn = validateDn;
    }

    public void setSchemaManager(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.position = 0;
            this.reader.close();
            this.containsEntries = false;
            this.containsChanges = false;
            this.offset = 0L;
            this.entryOffset = 0L;
            this.lineNumber = 0;
            if (this.is != null) {
                this.is.close();
            }
        }
    }
}

