/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.dialogs.preferences;

import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.common.dialogs.preferences.Messages;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SyntaxValueEditorRelation;
import org.apache.directory.studio.valueeditors.ValueEditorManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class SyntaxValueEditorDialog
extends Dialog {
    private SyntaxValueEditorRelation relation;
    private SortedMap<String, ValueEditorManager.ValueEditorExtension> class2ValueEditorExtensionMap;
    private String[] syntaxOids;
    private SortedMap<String, String> veName2classMap;
    private SyntaxValueEditorRelation returnRelation;
    private Combo oidCombo;
    private Combo valueEditorCombo;
    private Button okButton;

    public SyntaxValueEditorDialog(Shell parentShell, SyntaxValueEditorRelation relation, SortedMap<String, ValueEditorManager.ValueEditorExtension> class2ValueEditorExtensionMap, String[] syntaxOids) {
        super(parentShell);
        this.relation = relation;
        this.class2ValueEditorExtensionMap = class2ValueEditorExtensionMap;
        this.syntaxOids = syntaxOids;
        this.returnRelation = null;
        this.veName2classMap = new TreeMap<String, String>();
        for (ValueEditorManager.ValueEditorExtension vee : class2ValueEditorExtensionMap.values()) {
            this.veName2classMap.put(vee.name, vee.className);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("SyntaxValueEditorDialog.AttributeValueEditor"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.validate();
    }

    protected void okPressed() {
        this.returnRelation = new SyntaxValueEditorRelation(this.oidCombo.getText(), (String)this.veName2classMap.get(this.valueEditorCombo.getText()));
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite c = BaseWidgetUtils.createColumnContainer((Composite)composite, (int)2, (int)1);
        BaseWidgetUtils.createLabel((Composite)c, (String)Messages.getString("SyntaxValueEditorDialog.SyntaxOID"), (int)1);
        this.oidCombo = BaseWidgetUtils.createCombo((Composite)c, (String[])this.syntaxOids, (int)-1, (int)1);
        if (this.relation != null && this.relation.getSyntaxOID() != null) {
            this.oidCombo.setText(this.relation.getSyntaxOID());
        }
        this.oidCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SyntaxValueEditorDialog.this.validate();
            }
        });
        BaseWidgetUtils.createLabel((Composite)c, (String)Messages.getString("SyntaxValueEditorDialog.ValueEditor"), (int)1);
        this.valueEditorCombo = BaseWidgetUtils.createReadonlyCombo((Composite)c, (String[])this.veName2classMap.keySet().toArray(new String[0]), (int)-1, (int)1);
        if (this.relation != null && this.relation.getValueEditorClassName() != null && this.class2ValueEditorExtensionMap.containsKey(this.relation.getValueEditorClassName())) {
            this.valueEditorCombo.setText(((ValueEditorManager.ValueEditorExtension)this.class2ValueEditorExtensionMap.get((Object)this.relation.getValueEditorClassName())).name);
        }
        this.valueEditorCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SyntaxValueEditorDialog.this.validate();
            }
        });
        return composite;
    }

    private void validate() {
        this.okButton.setEnabled(!"".equals(this.valueEditorCombo.getText()) && !"".equals(this.oidCombo.getText()));
    }

    public SyntaxValueEditorRelation getRelation() {
        return this.returnRelation;
    }
}

