/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.jobs;

import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.directory.api.ldap.model.message.ExtendedResponse;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.Utils;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreMessages;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;

public class ExtendedOperationRunnable
implements StudioConnectionRunnableWithProgress {
    private IBrowserConnection connection;
    private ExtendedRequest request;
    private ExtendedResponse response;

    public ExtendedOperationRunnable(IBrowserConnection connection, ExtendedRequest request) {
        this.connection = connection;
        this.request = request;
    }

    public Connection[] getConnections() {
        return new Connection[]{this.connection.getConnection()};
    }

    public String getName() {
        return BrowserCoreMessages.jobs__extended_operation_name;
    }

    public Object[] getLockedObjects() {
        return new Object[]{this.connection};
    }

    public String getErrorMessage() {
        return BrowserCoreMessages.jobs__extended_operation_error;
    }

    public void run(StudioProgressMonitor monitor) {
        monitor.beginTask(BrowserCoreMessages.bind((String)BrowserCoreMessages.jobs__extended_operation_task, (Object[])new String[]{Utils.getOidDescription((String)this.request.getRequestName())}), 2);
        monitor.reportProgress(" ");
        monitor.worked(1);
        try {
            this.response = this.connection.getConnection().getConnectionWrapper().extended(this.request, monitor);
        }
        catch (Exception e) {
            monitor.reportError(e);
        }
    }

    public ExtendedResponse getResponse() {
        return this.response;
    }
}

