/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.jobs;

import java.util.ArrayList;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.Controls;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionBulkRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreMessages;
import org.apache.directory.studio.ldapbrowser.core.events.EntryAddedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.jobs.ReadEntryRunnable;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.utils.ModelConverter;
import org.eclipse.core.runtime.IProgressMonitor;

public class CreateEntryRunnable
implements StudioConnectionBulkRunnableWithProgress {
    private IEntry entryToCreate;
    private IBrowserConnection browserConnection;
    private IEntry createdEntry;

    public CreateEntryRunnable(IEntry entryToCreate, IBrowserConnection browserConnection) {
        this.entryToCreate = entryToCreate;
        this.browserConnection = browserConnection;
        this.createdEntry = null;
    }

    public Connection[] getConnections() {
        return new Connection[]{this.browserConnection.getConnection()};
    }

    public String getName() {
        return BrowserCoreMessages.jobs__create_entry_name_1;
    }

    public Object[] getLockedObjects() {
        return new Object[]{this.browserConnection};
    }

    public String getErrorMessage() {
        return BrowserCoreMessages.jobs__create_entry_error_1;
    }

    public void run(StudioProgressMonitor monitor) {
        monitor.beginTask(BrowserCoreMessages.bind((String)BrowserCoreMessages.jobs__create_entry_task_1, (Object[])new String[]{this.entryToCreate.getDn().getName()}), 3);
        monitor.reportProgress(" ");
        monitor.worked(1);
        try {
            CreateEntryRunnable.createEntry(this.browserConnection, this.entryToCreate, monitor);
        }
        catch (LdapException e) {
            monitor.reportError((Exception)((Object)e));
        }
        if (!monitor.errorsReported() && !monitor.isCanceled()) {
            ArrayList<Control> controls = new ArrayList<Control>();
            if (this.entryToCreate.isReferral()) {
                controls.add((Control)Controls.MANAGEDSAIT_CONTROL);
            }
            StudioProgressMonitor dummyMonitor = new StudioProgressMonitor((IProgressMonitor)monitor);
            this.createdEntry = ReadEntryRunnable.getEntry(this.browserConnection, this.entryToCreate.getDn(), controls, dummyMonitor);
            dummyMonitor.done();
            if (this.createdEntry != null) {
                this.createdEntry.setHasChildrenHint(false);
                if (this.createdEntry.hasParententry()) {
                    if (this.createdEntry.isAlias()) {
                        this.createdEntry.getParententry().setFetchAliases(true);
                    }
                    if (this.createdEntry.isReferral()) {
                        this.createdEntry.getParententry().setFetchReferrals(true);
                    }
                    if (this.createdEntry.isSubentry()) {
                        this.createdEntry.getParententry().setFetchSubentries(true);
                    }
                }
            }
        }
        monitor.reportProgress(" ");
        monitor.worked(1);
    }

    public void runNotification(StudioProgressMonitor monitor) {
        if (this.createdEntry != null) {
            EventRegistry.fireEntryUpdated(new EntryAddedEvent(this.browserConnection, this.createdEntry), this);
        }
    }

    static void createEntry(IBrowserConnection browserConnection, IEntry entryToCreate, StudioProgressMonitor monitor) throws LdapException {
        Entry entry = ModelConverter.toLdapApiEntry(entryToCreate);
        Control[] controls = null;
        if (entryToCreate.isReferral()) {
            controls = new Control[]{Controls.MANAGEDSAIT_CONTROL};
        }
        browserConnection.getConnection().getConnectionWrapper().createEntry(entry, controls, monitor, null);
    }
}

