/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifeditor.dialogs.preferences;

import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreConstants;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldifeditor.LdifEditorActivator;
import org.apache.directory.studio.ldifeditor.dialogs.preferences.Messages;
import org.apache.directory.studio.ldifeditor.editor.ILdifEditor;
import org.apache.directory.studio.ldifeditor.widgets.LdifEditorWidget;
import org.apache.directory.studio.ldifparser.model.LdifFile;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class LdifEditorSyntaxColoringPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
ILdifEditor {
    private static final String LDIF_INITIAL = "# Content record" + BrowserCoreConstants.LINE_SEPARATOR + "dn: cn=content record" + BrowserCoreConstants.LINE_SEPARATOR + "objectClass: person" + BrowserCoreConstants.LINE_SEPARATOR + "cn: content record" + BrowserCoreConstants.LINE_SEPARATOR + "cn;lang-ja:: 5Za25qWt6YOo" + BrowserCoreConstants.LINE_SEPARATOR + BrowserCoreConstants.LINE_SEPARATOR + "# Add record with control" + BrowserCoreConstants.LINE_SEPARATOR + "dn: cn=add record" + BrowserCoreConstants.LINE_SEPARATOR + "control: 1.2.3.4 true: controlValue" + BrowserCoreConstants.LINE_SEPARATOR + "changetype: add" + BrowserCoreConstants.LINE_SEPARATOR + "objectClass: person" + BrowserCoreConstants.LINE_SEPARATOR + "cn: add record" + BrowserCoreConstants.LINE_SEPARATOR + BrowserCoreConstants.LINE_SEPARATOR + "# Modify record" + BrowserCoreConstants.LINE_SEPARATOR + "dn: cn=modify record" + BrowserCoreConstants.LINE_SEPARATOR + "changetype: modify" + BrowserCoreConstants.LINE_SEPARATOR + "add: cn" + BrowserCoreConstants.LINE_SEPARATOR + "cn: modify record" + BrowserCoreConstants.LINE_SEPARATOR + "-" + BrowserCoreConstants.LINE_SEPARATOR + "delete: cn" + BrowserCoreConstants.LINE_SEPARATOR + "-" + BrowserCoreConstants.LINE_SEPARATOR + "replace: cn" + BrowserCoreConstants.LINE_SEPARATOR + "cn: modify record" + BrowserCoreConstants.LINE_SEPARATOR + "-" + BrowserCoreConstants.LINE_SEPARATOR + BrowserCoreConstants.LINE_SEPARATOR + "# Delete record" + BrowserCoreConstants.LINE_SEPARATOR + "dn: cn=delete record" + BrowserCoreConstants.LINE_SEPARATOR + "changetype: delete" + BrowserCoreConstants.LINE_SEPARATOR + BrowserCoreConstants.LINE_SEPARATOR + "# Modify Dn record" + BrowserCoreConstants.LINE_SEPARATOR + "dn: cn=moddn record" + BrowserCoreConstants.LINE_SEPARATOR + "changetype: moddn" + BrowserCoreConstants.LINE_SEPARATOR + "newrdn: cn=new rdn" + BrowserCoreConstants.LINE_SEPARATOR + "deleteoldrdn: 1" + BrowserCoreConstants.LINE_SEPARATOR + "newsuperior: cn=new superior" + BrowserCoreConstants.LINE_SEPARATOR + BrowserCoreConstants.LINE_SEPARATOR;
    private LdifEditorWidget ldifEditorWidget;
    private SyntaxItem[] syntaxItems;
    private ColorSelector colorSelector;
    private Button boldCheckBox;
    private Button italicCheckBox;
    private Button underlineCheckBox;
    private Button strikethroughCheckBox;
    private TableViewer syntaxItemViewer;

    public LdifEditorSyntaxColoringPreferencePage() {
        super(Messages.getString("LdifEditorSyntaxColoringPreferencePage.SyntaxColoring"));
        super.setPreferenceStore(LdifEditorActivator.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    public void dispose() {
        this.ldifEditorWidget.dispose();
        super.dispose();
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        composite.setLayoutData((Object)gd);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        this.createSyntaxPage(composite);
        this.createPreviewer(composite);
        this.syntaxItems = new SyntaxItem[10];
        this.syntaxItems[0] = new SyntaxItem(Messages.getString("LdifEditorSyntaxColoringPreferencePage.Comments"), "ldifEditorSyntaxComment");
        this.syntaxItems[1] = new SyntaxItem(Messages.getString("LdifEditorSyntaxColoringPreferencePage.DN"), "ldifEditorSyntaxDn");
        this.syntaxItems[2] = new SyntaxItem(Messages.getString("LdifEditorSyntaxColoringPreferencePage.AttributeDescriptions"), "ldifEditorSyntaxAttribute");
        this.syntaxItems[3] = new SyntaxItem(Messages.getString("LdifEditorSyntaxColoringPreferencePage.ValueTypes"), "ldifEditorSyntaxValueType");
        this.syntaxItems[4] = new SyntaxItem(Messages.getString("LdifEditorSyntaxColoringPreferencePage.Values"), "ldifEditorSyntaxValue");
        this.syntaxItems[5] = new SyntaxItem(Messages.getString("LdifEditorSyntaxColoringPreferencePage.Keywords"), "ldifEditorSyntaxKeyword");
        this.syntaxItems[6] = new SyntaxItem(Messages.getString("LdifEditorSyntaxColoringPreferencePage.ChangetypeAdd"), "ldifEditorSyntaxChangetypeAdd");
        this.syntaxItems[7] = new SyntaxItem(Messages.getString("LdifEditorSyntaxColoringPreferencePage.ChangetypeModify"), "ldifEditorSyntaxChangetypeModify");
        this.syntaxItems[8] = new SyntaxItem(Messages.getString("LdifEditorSyntaxColoringPreferencePage.ChangetypeDelete"), "ldifEditorSyntaxChangetypeDelete");
        this.syntaxItems[9] = new SyntaxItem(Messages.getString("LdifEditorSyntaxColoringPreferencePage.ChangetypeModdn"), "ldifEditorSyntaxChangetypeModdn");
        this.syntaxItemViewer.setInput((Object)this.syntaxItems);
        this.syntaxItemViewer.setSelection((ISelection)new StructuredSelection((Object)this.syntaxItems[0]));
        return composite;
    }

    private void createSyntaxPage(Composite parent) {
        BaseWidgetUtils.createLabel((Composite)parent, (String)Messages.getString("LdifEditorSyntaxColoringPreferencePage.Element"), (int)1);
        Composite editorComposite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)2, (int)1);
        this.syntaxItemViewer = new TableViewer(editorComposite, 68100);
        this.syntaxItemViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.syntaxItemViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        GridData gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        this.syntaxItemViewer.getControl().setLayoutData((Object)gd);
        Composite stylesComposite = BaseWidgetUtils.createColumnContainer((Composite)editorComposite, (int)1, (int)1);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        Composite colorComposite = BaseWidgetUtils.createColumnContainer((Composite)stylesComposite, (int)2, (int)1);
        BaseWidgetUtils.createLabel((Composite)colorComposite, (String)Messages.getString("LdifEditorSyntaxColoringPreferencePage.Color"), (int)1);
        this.colorSelector = new ColorSelector(colorComposite);
        this.boldCheckBox = BaseWidgetUtils.createCheckbox((Composite)stylesComposite, (String)Messages.getString("LdifEditorSyntaxColoringPreferencePage.Bold"), (int)1);
        this.italicCheckBox = BaseWidgetUtils.createCheckbox((Composite)stylesComposite, (String)Messages.getString("LdifEditorSyntaxColoringPreferencePage.Italic"), (int)1);
        this.strikethroughCheckBox = BaseWidgetUtils.createCheckbox((Composite)stylesComposite, (String)Messages.getString("LdifEditorSyntaxColoringPreferencePage.Strikethrough"), (int)1);
        this.underlineCheckBox = BaseWidgetUtils.createCheckbox((Composite)stylesComposite, (String)Messages.getString("LdifEditorSyntaxColoringPreferencePage.Underline"), (int)1);
        this.syntaxItemViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LdifEditorSyntaxColoringPreferencePage.this.handleSyntaxItemViewerSelectionEvent();
            }
        });
        this.colorSelector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LdifEditorSyntaxColoringPreferencePage.this.handleColorSelectorEvent();
            }
        });
        this.boldCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LdifEditorSyntaxColoringPreferencePage.this.handleBoldSelectionEvent();
            }
        });
        this.italicCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LdifEditorSyntaxColoringPreferencePage.this.handleItalicSelectionEvent();
            }
        });
        this.strikethroughCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LdifEditorSyntaxColoringPreferencePage.this.handleStrikethroughSelectionEvent();
            }
        });
        this.underlineCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LdifEditorSyntaxColoringPreferencePage.this.handleUnderlineSelectionEvent();
            }
        });
    }

    private void handleUnderlineSelectionEvent() {
        SyntaxItem item = this.getSyntaxItem();
        if (item != null) {
            item.underline = this.underlineCheckBox.getSelection();
            this.setTextAttribute(item);
        }
    }

    private void handleStrikethroughSelectionEvent() {
        SyntaxItem item = this.getSyntaxItem();
        if (item != null) {
            item.strikethrough = this.strikethroughCheckBox.getSelection();
            this.setTextAttribute(item);
        }
    }

    private void handleItalicSelectionEvent() {
        SyntaxItem item = this.getSyntaxItem();
        if (item != null) {
            item.italic = this.italicCheckBox.getSelection();
            this.setTextAttribute(item);
        }
    }

    private void handleBoldSelectionEvent() {
        SyntaxItem item = this.getSyntaxItem();
        if (item != null) {
            item.bold = this.boldCheckBox.getSelection();
            this.setTextAttribute(item);
        }
    }

    private void handleColorSelectorEvent() {
        SyntaxItem item = this.getSyntaxItem();
        if (item != null) {
            item.rgb = this.colorSelector.getColorValue();
            this.setTextAttribute(item);
        }
    }

    private void handleSyntaxItemViewerSelectionEvent() {
        SyntaxItem item = this.getSyntaxItem();
        if (item != null) {
            this.colorSelector.setColorValue(item.rgb);
            this.boldCheckBox.setSelection(item.bold);
            this.italicCheckBox.setSelection(item.italic);
            this.strikethroughCheckBox.setSelection(item.strikethrough);
            this.underlineCheckBox.setSelection(item.underline);
        }
    }

    private SyntaxItem getSyntaxItem() {
        SyntaxItem item = (SyntaxItem)((IStructuredSelection)this.syntaxItemViewer.getSelection()).getFirstElement();
        return item;
    }

    private void setTextAttribute(SyntaxItem item) {
        this.ldifEditorWidget.getSourceViewerConfiguration().setTextAttribute(item.key, item.rgb, item.getStyle());
        int topIndex = this.ldifEditorWidget.getSourceViewer().getTopIndex();
        this.ldifEditorWidget.getSourceViewer().getDocument().set(LDIF_INITIAL);
        this.ldifEditorWidget.getSourceViewer().setTopIndex(topIndex);
    }

    private void createPreviewer(Composite parent) {
        BaseWidgetUtils.createLabel((Composite)parent, (String)Messages.getString("LdifEditorSyntaxColoringPreferencePage.Preview"), (int)1);
        this.ldifEditorWidget = new LdifEditorWidget(null, LDIF_INITIAL, false);
        this.ldifEditorWidget.createWidget(parent);
        this.ldifEditorWidget.getSourceViewer().setEditable(false);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(20);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        this.ldifEditorWidget.getSourceViewer().getControl().setLayoutData((Object)gd);
    }

    @Override
    public IBrowserConnection getConnection() {
        return this.ldifEditorWidget.getConnection();
    }

    @Override
    public LdifFile getLdifModel() {
        return this.ldifEditorWidget.getLdifModel();
    }

    public boolean performOk() {
        int i = 0;
        while (i < this.syntaxItems.length) {
            this.syntaxItems[i].savePreferences();
            ++i;
        }
        return true;
    }

    protected void performDefaults() {
        int i = 0;
        while (i < this.syntaxItems.length) {
            this.syntaxItems[i].loadDefaultPreferences();
            this.setTextAttribute(this.syntaxItems[i]);
            ++i;
        }
        this.handleSyntaxItemViewerSelectionEvent();
        super.performDefaults();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    private class SyntaxItem {
        String displayName;
        String key;
        RGB rgb;
        boolean bold;
        boolean italic;
        boolean strikethrough;
        boolean underline;

        SyntaxItem(String displayName, String key) {
            this.displayName = displayName;
            this.key = key;
            this.loadPreferences();
        }

        int getStyle() {
            int style = 0;
            if (this.bold) {
                style |= 1;
            }
            if (this.italic) {
                style |= 2;
            }
            if (this.strikethrough) {
                style |= 0x20000000;
            }
            if (this.underline) {
                style |= 0x40000000;
            }
            return style;
        }

        void setStyle(int style) {
            this.bold = (style & 1) != 0;
            this.italic = (style & 2) != 0;
            this.strikethrough = (style & 0x20000000) != 0;
            this.underline = (style & 0x40000000) != 0;
        }

        void loadPreferences() {
            IPreferenceStore store = LdifEditorSyntaxColoringPreferencePage.this.getPreferenceStore();
            this.rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)(String.valueOf(this.key) + "_RGB"));
            int style = store.getInt(String.valueOf(this.key) + "_STYLE");
            this.setStyle(style);
        }

        void savePreferences() {
            IPreferenceStore store = LdifEditorSyntaxColoringPreferencePage.this.getPreferenceStore();
            PreferenceConverter.setValue((IPreferenceStore)store, (String)(String.valueOf(this.key) + "_RGB"), (RGB)this.rgb);
            store.setValue(String.valueOf(this.key) + "_STYLE", this.getStyle());
        }

        void loadDefaultPreferences() {
            IPreferenceStore store = LdifEditorSyntaxColoringPreferencePage.this.getPreferenceStore();
            String colorKey = String.valueOf(this.key) + "_RGB";
            store.setToDefault(colorKey);
            String styleKey = String.valueOf(this.key) + "_STYLE";
            store.setToDefault(styleKey);
            this.rgb = PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)colorKey);
            int style = store.getDefaultInt(styleKey);
            this.setStyle(style);
        }

        public String toString() {
            return this.displayName;
        }
    }
}

