/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.model.io;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.naming.directory.SearchControls;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.ObjectClassTypeEnum;
import org.apache.directory.api.ldap.model.schema.UsageEnum;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.io.ConnectionWrapper;
import org.apache.directory.studio.connection.core.io.api.StudioSearchResult;
import org.apache.directory.studio.connection.core.io.api.StudioSearchResultEnumeration;
import org.apache.directory.studio.schemaeditor.model.Project;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.model.io.AbstractSchemaConnector;
import org.apache.directory.studio.schemaeditor.model.io.Messages;
import org.apache.directory.studio.schemaeditor.model.io.SchemaConnector;
import org.apache.directory.studio.schemaeditor.model.io.SchemaConnectorException;

public class ApacheDsSchemaConnector
extends AbstractSchemaConnector
implements SchemaConnector {
    @Override
    public void importSchema(Project project, StudioProgressMonitor monitor) throws SchemaConnectorException {
        monitor.beginTask(Messages.getString("ApacheDsSchemaConnector.FetchingSchema"), 1);
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        project.setInitialSchema(schemas);
        ConnectionWrapper wrapper = project.getConnection().getConnectionWrapper();
        SearchControls constraintSearch = new SearchControls();
        constraintSearch.setSearchScope(1);
        StudioSearchResultEnumeration answer = wrapper.search("ou=schema", "(objectclass=metaSchema)", constraintSearch, DEREF_ALIAS_METHOD, HANDLE_REFERALS_METHOD, null, monitor, null);
        if (answer != null) {
            try {
                while (answer.hasMore()) {
                    StudioSearchResult searchResult = answer.next();
                    Attribute cnAttribute = searchResult.getEntry().get("cn");
                    if (cnAttribute == null) continue;
                    for (Value cnValue : cnAttribute) {
                        Schema schema = ApacheDsSchemaConnector.getSchema(wrapper, cnValue.getString(), monitor);
                        schema.setProject(project);
                        schemas.add(schema);
                    }
                }
            }
            catch (Exception e) {
                throw new SchemaConnectorException(e);
            }
        }
        monitor.worked(1);
    }

    @Override
    public boolean isSuitableConnector(Connection connection, StudioProgressMonitor monitor) {
        block8: {
            ConnectionWrapper wrapper = connection.getConnectionWrapper();
            SearchControls constraintSearch = new SearchControls();
            constraintSearch.setSearchScope(0);
            constraintSearch.setReturningAttributes(new String[]{"+"});
            StudioSearchResultEnumeration answer = wrapper.search("", "(objectClass=*)", constraintSearch, DEREF_ALIAS_METHOD, HANDLE_REFERALS_METHOD, null, monitor, null);
            if (answer != null) {
                Attribute vendorNameAttribute;
                block10: {
                    block9: {
                        if (!answer.hasMore()) break block8;
                        Entry entry = answer.next().getEntry();
                        vendorNameAttribute = entry.get("vendorName");
                        if (vendorNameAttribute != null) break block9;
                        return false;
                    }
                    if (vendorNameAttribute.size() == 1) break block10;
                    return false;
                }
                String vendorName = null;
                try {
                    vendorName = vendorNameAttribute.getString();
                }
                catch (LdapInvalidAttributeValueException ldapInvalidAttributeValueException) {
                    return false;
                }
                try {
                    return vendorName != null && vendorName.equalsIgnoreCase("Apache Software Foundation");
                }
                catch (LdapException e) {
                    monitor.reportError((Exception)((Object)e));
                }
            }
        }
        return false;
    }

    private static Schema getSchema(ConnectionWrapper wrapper, String name, StudioProgressMonitor monitor) throws LdapException {
        monitor.subTask(name);
        Schema schema = new Schema(name);
        SearchControls constraintSearch = new SearchControls();
        constraintSearch.setSearchScope(2);
        StudioSearchResultEnumeration answer = wrapper.search("cn=" + name + ", ou=schema", "(objectClass=*)", constraintSearch, DEREF_ALIAS_METHOD, HANDLE_REFERALS_METHOD, null, monitor, null);
        if (answer != null) {
            try {
                while (answer.hasMore()) {
                    Entry entry = answer.next().getEntry();
                    switch (ApacheDsSchemaConnector.getNodeType(entry)) {
                        case ATTRIBUTE_TYPE: {
                            AttributeType at = ApacheDsSchemaConnector.createAttributeType(entry);
                            at.setSchemaName(name);
                            schema.addAttributeType(at);
                            break;
                        }
                        case OBJECT_CLASS: {
                            ObjectClass oc = ApacheDsSchemaConnector.createObjectClass(entry);
                            oc.setSchemaName(name);
                            schema.addObjectClass(oc);
                            break;
                        }
                        case MATCHING_RULE: {
                            MatchingRule mr = ApacheDsSchemaConnector.createMatchingRule(entry);
                            mr.setSchemaName(name);
                            schema.addMatchingRule(mr);
                            break;
                        }
                        case SYNTAX: {
                            LdapSyntax syntax = ApacheDsSchemaConnector.createSyntax(entry);
                            syntax.setSchemaName(name);
                            schema.addSyntax(syntax);
                            break;
                        }
                    }
                }
            }
            catch (LdapInvalidAttributeValueException e) {
                monitor.reportError((Exception)((Object)e));
            }
        }
        return schema;
    }

    private static SchemaNodeTypes getNodeType(Entry entry) {
        if (entry.hasObjectClass(new String[]{"metaAttributeType"})) {
            return SchemaNodeTypes.ATTRIBUTE_TYPE;
        }
        if (entry.hasObjectClass(new String[]{"metaObjectClass"})) {
            return SchemaNodeTypes.OBJECT_CLASS;
        }
        if (entry.hasObjectClass(new String[]{"metaMatchingRule"})) {
            return SchemaNodeTypes.MATCHING_RULE;
        }
        if (entry.hasObjectClass(new String[]{"metaSyntax"})) {
            return SchemaNodeTypes.SYNTAX;
        }
        return SchemaNodeTypes.UNKNOWN;
    }

    private static AttributeType createAttributeType(Entry entry) throws LdapInvalidAttributeValueException {
        AttributeType at = new AttributeType(ApacheDsSchemaConnector.getStringValue(entry, "m-oid"));
        at.setNames(ApacheDsSchemaConnector.getStringValues(entry, "m-name"));
        at.setDescription(ApacheDsSchemaConnector.getStringValue(entry, "m-description"));
        at.setObsolete(ApacheDsSchemaConnector.getBooleanValue(entry, "m-obsolete"));
        at.setSuperiorOid(ApacheDsSchemaConnector.getStringValue(entry, "m-supAttributeType"));
        at.setUsage(ApacheDsSchemaConnector.getUsage(entry));
        at.setSyntaxOid(ApacheDsSchemaConnector.getStringValue(entry, "m-syntax"));
        at.setSyntaxLength((long)ApacheDsSchemaConnector.getSyntaxLength(entry));
        at.setCollective(ApacheDsSchemaConnector.getBooleanValue(entry, "m-collective"));
        at.setSingleValued(ApacheDsSchemaConnector.getBooleanValue(entry, "m-singleValue"));
        at.setUserModifiable(ApacheDsSchemaConnector.getBooleanValue(entry, "m-noUserModification"));
        at.setEqualityOid(ApacheDsSchemaConnector.getStringValue(entry, "m-equality"));
        at.setOrderingOid(ApacheDsSchemaConnector.getStringValue(entry, "m-ordering"));
        at.setSubstringOid(ApacheDsSchemaConnector.getStringValue(entry, "m-substr"));
        return at;
    }

    private static ObjectClass createObjectClass(Entry sr) throws LdapInvalidAttributeValueException {
        ObjectClass oc = new ObjectClass(ApacheDsSchemaConnector.getStringValue(sr, "m-oid"));
        oc.setNames(ApacheDsSchemaConnector.getStringValues(sr, "m-name"));
        oc.setDescription(ApacheDsSchemaConnector.getStringValue(sr, "m-description"));
        oc.setObsolete(ApacheDsSchemaConnector.getBooleanValue(sr, "m-obsolete"));
        oc.setSuperiorOids(ApacheDsSchemaConnector.getStringValues(sr, "m-supObjectClass"));
        oc.setType(ApacheDsSchemaConnector.getType(sr));
        oc.setMayAttributeTypeOids(ApacheDsSchemaConnector.getStringValues(sr, "m-may"));
        oc.setMustAttributeTypeOids(ApacheDsSchemaConnector.getStringValues(sr, "m-must"));
        return oc;
    }

    private static MatchingRule createMatchingRule(Entry entry) throws LdapInvalidAttributeValueException {
        MatchingRule mr = new MatchingRule(ApacheDsSchemaConnector.getStringValue(entry, "m-oid"));
        mr.setNames(ApacheDsSchemaConnector.getStringValues(entry, "m-name"));
        mr.setDescription(ApacheDsSchemaConnector.getStringValue(entry, "m-description"));
        mr.setObsolete(ApacheDsSchemaConnector.getBooleanValue(entry, "m-obsolete"));
        mr.setSyntaxOid(ApacheDsSchemaConnector.getStringValue(entry, "m-syntax"));
        return mr;
    }

    private static LdapSyntax createSyntax(Entry entry) throws LdapInvalidAttributeValueException {
        LdapSyntax syntax = new LdapSyntax(ApacheDsSchemaConnector.getStringValue(entry, "m-oid"));
        syntax.setNames(ApacheDsSchemaConnector.getStringValues(entry, "m-name"));
        syntax.setDescription(ApacheDsSchemaConnector.getStringValue(entry, "m-description"));
        syntax.setObsolete(ApacheDsSchemaConnector.getBooleanValue(entry, "m-obsolete"));
        syntax.setHumanReadable(ApacheDsSchemaConnector.isHumanReadable(entry));
        return syntax;
    }

    private static UsageEnum getUsage(Entry entry) throws LdapInvalidAttributeValueException {
        Attribute at = entry.get("m-usage");
        if (at == null) {
            return UsageEnum.USER_APPLICATIONS;
        }
        try {
            return UsageEnum.getUsage((String)at.getString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return UsageEnum.USER_APPLICATIONS;
        }
        catch (NullPointerException nullPointerException) {
            return UsageEnum.USER_APPLICATIONS;
        }
    }

    private static int getSyntaxLength(Entry entry) throws LdapInvalidAttributeValueException {
        Attribute at = entry.get("m-length");
        if (at == null) {
            return -1;
        }
        try {
            return Integer.parseInt(at.getString());
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private static String getStringValue(Entry entry, String schemaElement) throws LdapInvalidAttributeValueException {
        Attribute at = entry.get(schemaElement);
        if (at == null) {
            return null;
        }
        return at.getString();
    }

    private static boolean getBooleanValue(Entry entry, String schemaElement) throws LdapInvalidAttributeValueException {
        Attribute at = entry.get(schemaElement);
        if (at == null) {
            return false;
        }
        return Boolean.parseBoolean(at.getString());
    }

    private static List<String> getStringValues(Entry entry, String schemaElement) {
        Attribute at = entry.get(schemaElement);
        Spliterator spliterator = Optional.ofNullable(at).map(Iterable::spliterator).orElseGet(Spliterators::emptySpliterator);
        return StreamSupport.stream(spliterator, false).map(Value::getString).collect(Collectors.toList());
    }

    private static ObjectClassTypeEnum getType(Entry entry) throws LdapInvalidAttributeValueException {
        Attribute at = entry.get("m-typeObjectClass");
        if (at == null) {
            return ObjectClassTypeEnum.STRUCTURAL;
        }
        try {
            return ObjectClassTypeEnum.getClassType((String)at.getString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return ObjectClassTypeEnum.STRUCTURAL;
        }
        catch (NullPointerException nullPointerException) {
            return ObjectClassTypeEnum.STRUCTURAL;
        }
    }

    private static boolean isHumanReadable(Entry entry) throws LdapInvalidAttributeValueException {
        Attribute at = entry.get("X-NOT-HUMAN-READABLE");
        if (at == null) {
            return false;
        }
        return !Boolean.parseBoolean(at.getString());
    }

    @Override
    public void exportSchema(Project project, StudioProgressMonitor monitor) throws SchemaConnectorException {
    }

    private static enum SchemaNodeTypes {
        ATTRIBUTE_TYPE,
        OBJECT_CLASS,
        MATCHING_RULE,
        SYNTAX,
        UNKNOWN;

    }
}

