/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.actions;

import java.util.Iterator;
import java.util.LinkedHashSet;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserAction;
import org.apache.directory.studio.ldapbrowser.common.actions.CopyAction;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.utils.LdapFilterUtils;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldapbrowser.ui.actions.Messages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

public class CopySearchFilterAction
extends BrowserAction {
    public static final int MODE_EQUALS = 0;
    public static final int MODE_NOT = 1;
    public static final int MODE_AND = 2;
    public static final int MODE_OR = 3;
    private int mode;

    public CopySearchFilterAction(int mode) {
        this.mode = mode;
    }

    public String getText() {
        if (this.mode == 0) {
            return Messages.getString("CopySearchFilterAction.CopySearchFilter");
        }
        if (this.mode == 1) {
            return Messages.getString("CopySearchFilterAction.CopyNotSearchFilter");
        }
        if (this.mode == 2) {
            return Messages.getString("CopySearchFilterAction.CopyAndSearchFilter");
        }
        if (this.mode == 3) {
            return Messages.getString("CopySearchFilterAction.CopyOrSearchFilter");
        }
        return Messages.getString("CopySearchFilterAction.CopySearchFilter");
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.mode == 0) {
            return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/filter_equals.gif");
        }
        if (this.mode == 1) {
            return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/filter_not.gif");
        }
        if (this.mode == 2) {
            return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/filter_and.gif");
        }
        if (this.mode == 3) {
            return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/filter_or.gif");
        }
        return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/filter_equals.gif");
    }

    public String getCommandId() {
        return null;
    }

    public boolean isEnabled() {
        if (this.mode == 0 || this.mode == 1) {
            return this.getSelectedAttributeHierarchies().length + this.getSelectedAttributes().length + this.getSelectedValues().length == 1 && (this.getSelectedValues().length == 1 || this.getSelectedAttributes().length == 1 && this.getSelectedAttributes()[0].getValueSize() == 1 || this.getSelectedAttributeHierarchies().length == 1 && this.getSelectedAttributeHierarchies()[0].size() == 1 && this.getSelectedAttributeHierarchies()[0].getAttribute().getValueSize() == 1);
        }
        if (this.mode == 2 || this.mode == 3) {
            return this.getSelectedAttributeHierarchies().length + this.getSelectedAttributes().length + this.getSelectedValues().length > 0;
        }
        return false;
    }

    public void run() {
        String filter = null;
        if (this.mode == 0) {
            filter = this.getFilter(null);
        } else if (this.mode == 1) {
            filter = this.getFilter("!");
        } else if (this.mode == 2) {
            filter = this.getFilter("&");
        } else if (this.mode == 3) {
            filter = this.getFilter("|");
        }
        if (filter != null && filter.length() > 0) {
            CopyAction.copyToClipboard((Object[])new Object[]{filter}, (Transfer[])new Transfer[]{TextTransfer.getInstance()});
        }
    }

    private String getFilter(String filterType) {
        LinkedHashSet<String> filterSet = new LinkedHashSet<String>();
        int i = 0;
        while (i < this.getSelectedAttributeHierarchies().length) {
            for (IAttribute att : this.getSelectedAttributeHierarchies()[i]) {
                IValue[] values = att.getValues();
                int v = 0;
                while (v < values.length) {
                    filterSet.add(LdapFilterUtils.getFilter((IValue)values[v]));
                    ++v;
                }
            }
            ++i;
        }
        int a = 0;
        while (a < this.getSelectedAttributes().length) {
            IValue[] values = this.getSelectedAttributes()[a].getValues();
            int v = 0;
            while (v < values.length) {
                filterSet.add(LdapFilterUtils.getFilter((IValue)values[v]));
                ++v;
            }
            ++a;
        }
        int v = 0;
        while (v < this.getSelectedValues().length) {
            filterSet.add(LdapFilterUtils.getFilter((IValue)this.getSelectedValues()[v]));
            ++v;
        }
        StringBuffer filter = new StringBuffer();
        if (filterType != null) {
            filter.append("(");
            filter.append(filterType);
            Iterator filterIterator = filterSet.iterator();
            while (filterIterator.hasNext()) {
                filter.append(filterIterator.next());
            }
            filter.append(")");
        } else if (filterSet.size() == 1) {
            filter.append(filterSet.toArray()[0]);
        }
        return filter.toString();
    }
}

