/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core.io;

import java.security.KeyStore;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.directory.api.ldap.model.exception.LdapTlsHandshakeExceptionClassifier;
import org.apache.directory.api.ldap.model.exception.LdapTlsHandshakeFailCause;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.ICertificateHandler;
import org.apache.directory.studio.connection.core.Messages;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;

public class StudioTrustManager
implements X509TrustManager {
    private X509TrustManager jvmTrustManager;
    private String host;

    public StudioTrustManager(X509TrustManager jvmTrustManager) throws Exception {
        this.jvmTrustManager = jvmTrustManager;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.jvmTrustManager.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        LdapTlsHandshakeFailCause failCause;
        try {
            X509TrustManager permanentTrustManager = this.getPermanentTrustManager();
            if (permanentTrustManager != null) {
                permanentTrustManager.checkServerTrusted(chain, authType);
                return;
            }
        }
        catch (CertificateException certificateException) {}
        try {
            X509TrustManager sessionTrustManager = this.getSessionTrustManager();
            if (sessionTrustManager != null) {
                sessionTrustManager.checkServerTrusted(chain, authType);
                return;
            }
        }
        catch (CertificateException certificateException) {}
        LinkedHashMap<CertPathValidatorException.Reason, LdapTlsHandshakeFailCause> failCauses = new LinkedHashMap<CertPathValidatorException.Reason, LdapTlsHandshakeFailCause>();
        CertificateException certificateException = null;
        try {
            this.jvmTrustManager.checkServerTrusted(chain, authType);
        }
        catch (CertificateException ce) {
            certificateException = ce;
            failCause = LdapTlsHandshakeExceptionClassifier.classify((Throwable)ce, (X509Certificate)chain[0]);
            failCauses.put(failCause.getReason(), failCause);
        }
        try {
            chain[0].checkValidity();
        }
        catch (CertificateException ce) {
            certificateException = ce;
            failCause = LdapTlsHandshakeExceptionClassifier.classify((Throwable)ce, (X509Certificate)chain[0]);
            failCauses.put(failCause.getReason(), failCause);
        }
        try {
            DefaultHostnameVerifier hostnameVerifier = new DefaultHostnameVerifier();
            hostnameVerifier.verify(this.host, chain[0]);
        }
        catch (SSLException ssle) {
            certificateException = new CertificateException(ssle);
            failCause = new LdapTlsHandshakeFailCause((Throwable)ssle, (Throwable)ssle, (CertPathValidatorException.Reason)LdapTlsHandshakeFailCause.LdapApiReason.HOST_NAME_VERIFICATION_FAILED, "Hostname verification failed");
            failCauses.put(failCause.getReason(), failCause);
        }
        if (!failCauses.isEmpty()) {
            ICertificateHandler ch = ConnectionCorePlugin.getDefault().getCertificateHandler();
            ICertificateHandler.TrustLevel trustLevel = ch.verifyTrustLevel(this.host, chain, failCauses.values());
            switch (trustLevel) {
                case Permanent: {
                    ConnectionCorePlugin.getDefault().getPermanentTrustStoreManager().addCertificate(chain[0]);
                    break;
                }
                case Session: {
                    ConnectionCorePlugin.getDefault().getSessionTrustStoreManager().addCertificate(chain[0]);
                    break;
                }
                case Not: {
                    throw certificateException;
                }
            }
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.jvmTrustManager.getAcceptedIssuers();
    }

    private X509TrustManager getPermanentTrustManager() throws CertificateException {
        KeyStore permanentTrustStore = ConnectionCorePlugin.getDefault().getPermanentTrustStoreManager().getKeyStore();
        X509TrustManager permanentTrustManager = this.getTrustManager(permanentTrustStore);
        return permanentTrustManager;
    }

    private X509TrustManager getSessionTrustManager() throws CertificateException {
        KeyStore sessionTrustStore = ConnectionCorePlugin.getDefault().getSessionTrustStoreManager().getKeyStore();
        X509TrustManager sessionTrustManager = this.getTrustManager(sessionTrustStore);
        return sessionTrustManager;
    }

    private X509TrustManager getTrustManager(KeyStore trustStore) throws CertificateException {
        try {
            Enumeration<String> aliases = trustStore.aliases();
            if (aliases.hasMoreElements()) {
                TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                factory.init(trustStore);
                TrustManager[] permanentTrustManagers = factory.getTrustManagers();
                TrustManager permanentTrustManager = permanentTrustManagers[0];
                return (X509TrustManager)permanentTrustManager;
            }
        }
        catch (Exception e) {
            throw new CertificateException(Messages.StudioTrustManager_CantCreateTrustManager, e);
        }
        return null;
    }
}

