/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapservers.jobs;

import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.common.core.jobs.StudioRunnableWithProgress;
import org.apache.directory.studio.ldapservers.jobs.Messages;
import org.apache.directory.studio.ldapservers.jobs.StopLdapServerWatchDogThread;
import org.apache.directory.studio.ldapservers.model.LdapServer;
import org.apache.directory.studio.ldapservers.model.LdapServerAdapter;
import org.apache.directory.studio.ldapservers.model.LdapServerAdapterExtension;
import org.apache.directory.studio.ldapservers.model.LdapServerStatus;
import org.eclipse.osgi.util.NLS;

public class StopLdapServerRunnable
implements StudioRunnableWithProgress {
    private LdapServer server;

    public StopLdapServerRunnable(LdapServer server) {
        this.server = server;
    }

    public String getErrorMessage() {
        return NLS.bind((String)Messages.getString("StopLdapServerRunnable.UnableToStopServer"), (Object[])new String[]{this.server.getName()});
    }

    public Object[] getLockedObjects() {
        return new Object[]{this.server};
    }

    public String getName() {
        return NLS.bind((String)Messages.getString("StopLdapServerRunnable.StopServer"), (Object[])new String[]{this.server.getName()});
    }

    public void run(StudioProgressMonitor monitor) {
        LdapServerAdapter ldapServerAdapter;
        this.server.setStatus(LdapServerStatus.STOPPING);
        StopLdapServerWatchDogThread.runNewWatchDogThread(this.server);
        LdapServerAdapterExtension ldapServerAdapterExtension = this.server.getLdapServerAdapterExtension();
        if (ldapServerAdapterExtension != null && (ldapServerAdapter = ldapServerAdapterExtension.getInstance()) != null) {
            try {
                ldapServerAdapter.stop(this.server, monitor);
            }
            catch (Exception e) {
                this.server.setStatus(LdapServerStatus.STARTED);
                monitor.reportError(e);
            }
        }
    }
}

