/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.dsmlv2;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.directory.api.dsmlv2.DsmlDecorator;
import org.apache.directory.api.dsmlv2.Dsmlv2Container;
import org.apache.directory.api.dsmlv2.Dsmlv2StatesEnum;
import org.apache.directory.api.dsmlv2.GrammarTransition;
import org.apache.directory.api.dsmlv2.Tag;
import org.apache.directory.api.dsmlv2.request.BatchRequestDsml;
import org.apache.directory.api.dsmlv2.request.Dsmlv2Grammar;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.message.Request;
import org.apache.directory.api.util.Strings;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class Dsmlv2Parser {
    private Dsmlv2Container container;
    private boolean storeMsgInBatchReq = true;
    private Dsmlv2Grammar grammar;

    public Dsmlv2Parser() throws XmlPullParserException {
        this(true);
    }

    public Dsmlv2Parser(boolean storeMsgInBatchReq) throws XmlPullParserException {
        this.storeMsgInBatchReq = storeMsgInBatchReq;
        this.grammar = new Dsmlv2Grammar();
        this.container = new Dsmlv2Container(this.grammar.getLdapCodecService());
        this.container.setGrammar(this.grammar);
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
        factory.setNamespaceAware(true);
        XmlPullParser xpp = factory.newPullParser();
        this.container.setParser(xpp);
    }

    public Dsmlv2Parser(Dsmlv2Grammar grammar) throws XmlPullParserException {
        this.container = new Dsmlv2Container(grammar.getLdapCodecService());
        this.container.setGrammar(grammar);
        this.grammar = grammar;
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
        factory.setNamespaceAware(true);
        XmlPullParser xpp = factory.newPullParser();
        this.container.setParser(xpp);
    }

    public void setInputFile(String fileName) throws IOException, XmlPullParserException {
        try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(Paths.get(fileName, new String[0]), new OpenOption[0]), Charset.defaultCharset());){
            this.container.getParser().setInput((Reader)reader);
        }
    }

    public void setInput(InputStream inputStream, String inputEncoding) throws XmlPullParserException {
        this.container.getParser().setInput(inputStream, inputEncoding);
    }

    public void setInput(String str) throws XmlPullParserException {
        this.container.getParser().setInput((Reader)new StringReader(str));
    }

    public void parse() throws XmlPullParserException, IOException {
        this.grammar.executeAction(this.container);
    }

    public void parseBatchRequest() throws XmlPullParserException {
        XmlPullParser xpp = this.container.getParser();
        int eventType = xpp.getEventType();
        do {
            switch (eventType) {
                case 0: {
                    this.container.setState(Dsmlv2StatesEnum.INIT_GRAMMAR_STATE);
                    break;
                }
                case 1: {
                    this.container.setState(Dsmlv2StatesEnum.GRAMMAR_END);
                    break;
                }
                case 2: {
                    Dsmlv2Parser.processTag(this.container, 0);
                    break;
                }
                case 3: {
                    Dsmlv2Parser.processTag(this.container, 1);
                    break;
                }
            }
            try {
                eventType = xpp.next();
            }
            catch (IOException ioe) {
                throw new XmlPullParserException(I18n.err(I18n.ERR_03019_IO_EXCEPTION_OCCURED, ioe.getLocalizedMessage()), xpp, (Throwable)ioe);
            }
        } while (this.container.getState() != Dsmlv2StatesEnum.BATCHREQUEST_START_TAG);
        BatchRequestDsml br = this.container.getBatchRequest();
        if (br != null) {
            br.setStoreReq(this.storeMsgInBatchReq);
        }
    }

    private static void processTag(Dsmlv2Container container, int tagType) throws XmlPullParserException {
        XmlPullParser xpp = container.getParser();
        String tagName = Strings.lowerCase(xpp.getName());
        GrammarTransition transition = container.getTransition(container.getState(), new Tag(tagName, tagType));
        if (transition != null) {
            container.setState(transition.getNextState());
            if (transition.hasAction()) {
                transition.getAction().action(container);
            }
        } else {
            throw new XmlPullParserException(I18n.err(I18n.ERR_03036_MISSING_TAG, new Tag(tagName, tagType)), xpp, null);
        }
    }

    public BatchRequestDsml getBatchRequest() {
        return this.container.getBatchRequest();
    }

    public DsmlDecorator<? extends Request> getNextRequest() throws XmlPullParserException {
        if (this.container.getBatchRequest() == null) {
            this.parseBatchRequest();
        }
        XmlPullParser xpp = this.container.getParser();
        int eventType = xpp.getEventType();
        while (true) {
            if (eventType == 4) {
                try {
                    xpp.next();
                }
                catch (IOException ioe) {
                    throw new XmlPullParserException(I18n.err(I18n.ERR_03019_IO_EXCEPTION_OCCURED, ioe.getLocalizedMessage()), xpp, (Throwable)ioe);
                }
                eventType = xpp.getEventType();
                continue;
            }
            switch (eventType) {
                case 0: {
                    this.container.setState(Dsmlv2StatesEnum.INIT_GRAMMAR_STATE);
                    break;
                }
                case 1: {
                    this.container.setState(Dsmlv2StatesEnum.GRAMMAR_END);
                    return null;
                }
                case 2: {
                    Dsmlv2Parser.processTag(this.container, 0);
                    break;
                }
                case 3: {
                    Dsmlv2Parser.processTag(this.container, 1);
                    break;
                }
            }
            try {
                eventType = xpp.next();
            }
            catch (IOException ioe) {
                throw new XmlPullParserException(I18n.err(I18n.ERR_03019_IO_EXCEPTION_OCCURED, ioe.getLocalizedMessage()), xpp, (Throwable)ioe);
            }
            if (this.container.getState() == Dsmlv2StatesEnum.BATCHREQUEST_LOOP) break;
        }
        return this.container.getBatchRequest().getCurrentRequest();
    }

    public void parseAllRequests() throws XmlPullParserException {
        while (this.getNextRequest() != null) {
        }
    }
}

