/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.directory.api.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OsgiUtils {
    private static final Logger LOG = LoggerFactory.getLogger(OsgiUtils.class);

    private OsgiUtils() {
    }

    public static Set<String> getAllBundleExports(FileFilter filter, Set<String> pkgs) {
        if (pkgs == null) {
            pkgs = new HashSet<String>();
        }
        Set<File> candidates = OsgiUtils.getClasspathCandidates(filter);
        for (File candidate : candidates) {
            String exports = OsgiUtils.getBundleExports(candidate);
            if (exports == null) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug(I18n.msg(I18n.MSG_17000_NO_EXPORT_FOUND, candidate));
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_17001_PROCESSING_EXPORTS, candidate, exports));
            }
            OsgiUtils.splitIntoPackages(exports, pkgs);
        }
        return pkgs;
    }

    public static Set<String> splitIntoPackages(String exports, Set<String> pkgs) {
        if (pkgs == null) {
            pkgs = new HashSet<String>();
        }
        int index = 0;
        boolean inPkg = true;
        boolean inProps = false;
        StringBuilder pkg = new StringBuilder();
        while (index < exports.length()) {
            if (inPkg && exports.charAt(index) != ';') {
                pkg.append(exports.charAt(index));
                ++index;
                continue;
            }
            if (inPkg && exports.charAt(index) == ';') {
                inPkg = false;
                inProps = true;
                pkgs.add(pkg.toString());
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_17002_ADDED_PACKAGE, pkg.toString()));
                }
                pkg.setLength(0);
                index += 8;
                continue;
            }
            if (inProps && exports.charAt(index) == '\"' && index + 1 < exports.length() && exports.charAt(index + 1) == ',') {
                inPkg = true;
                inProps = false;
                index += 2;
                continue;
            }
            if (inProps) {
                ++index;
                continue;
            }
            LOG.error(I18n.err(I18n.ERR_17000_UNEXPECTED_PARSER_CONDITION, new Object[0]));
            throw new IllegalStateException(I18n.err(I18n.ERR_17068_SHOULD_NOT_GET_HERE, new Object[0]));
        }
        return pkgs;
    }

    public static Set<File> getClasspathCandidates(FileFilter filter) {
        String[] cpElements;
        HashSet<File> candidates = new HashSet<File>();
        String separator = System.getProperty("path.separator");
        for (String element : cpElements = System.getProperty("java.class.path").split(separator)) {
            File candidate = new File(element);
            if (!candidate.isFile()) continue;
            if (filter != null && filter.accept(candidate)) {
                candidates.add(candidate);
                if (!LOG.isInfoEnabled()) continue;
                LOG.info(I18n.msg(I18n.MSG_17003_ACCEPTED_CANDIDATE_WITH_FILTER, candidate.toString()));
                continue;
            }
            if (filter == null && candidate.getName().endsWith(".jar")) {
                candidates.add(candidate);
                if (!LOG.isInfoEnabled()) continue;
                LOG.info(I18n.msg(I18n.MSG_17004_ACCEPTED_CANDIDATE_NO_FILTER, candidate.toString()));
                continue;
            }
            if (!LOG.isInfoEnabled()) continue;
            LOG.info(I18n.msg(I18n.MSG_17005_REJECTING_CANDIDATE, candidate.toString()));
        }
        return candidates;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getBundleExports(File bundle) {
        try (JarFile jar = new JarFile(bundle);){
            Manifest manifest = jar.getManifest();
            if (manifest == null) {
                String string = null;
                return string;
            }
            for (Map.Entry<Object, Object> attr : manifest.getMainAttributes().entrySet()) {
                if (!"Export-Package".equals(attr.getKey().toString())) continue;
                String string = attr.getValue().toString();
                return string;
            }
            Iterator<Map.Entry<Object, Object>> iterator = null;
            return iterator;
        }
        catch (IOException e) {
            String msg = I18n.err(I18n.ERR_17001_FAILED_OPEN_JAR_MANIFEST, new Object[0]);
            LOG.error(msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
    }
}

