/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.oid;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.configuration2.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.apache.torque.Database;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.oid.IdGenerator;
import org.apache.torque.util.TorqueConnection;
import org.apache.torque.util.Transaction;

public class IDBroker
implements Runnable,
IdGenerator {
    public static final String ID_TABLE = "ID_TABLE";
    public static final String COL_TABLE_NAME = "TABLE_NAME";
    public static final String TABLE_NAME = "ID_TABLE.TABLE_NAME";
    public static final String COL_TABLE_ID = "ID_TABLE_ID";
    public static final String TABLE_ID = "ID_TABLE.ID_TABLE_ID";
    public static final String COL_NEXT_ID = "NEXT_ID";
    public static final String NEXT_ID = "ID_TABLE.NEXT_ID";
    public static final String COL_QUANTITY = "QUANTITY";
    public static final String QUANTITY = "ID_TABLE.QUANTITY";
    private static final BigDecimal PREFETCH_BACKUP_QUANTITY = BigDecimal.TEN;
    private static final BigDecimal CLEVERQUANTITY_MAX_DEFAULT = BigDecimal.valueOf(10000L);
    private final String databaseName;
    private static final int DEFAULT_SIZE = 40;
    private final ConcurrentMap<String, List<BigDecimal>> ids = new ConcurrentHashMap<String, List<BigDecimal>>(40);
    private final ConcurrentMap<String, BigDecimal> quantityStore = new ConcurrentHashMap<String, BigDecimal>(40);
    private final ConcurrentMap<String, Date> lastQueryTime = new ConcurrentHashMap<String, Date>(40);
    private static final long SLEEP_PERIOD = 60000L;
    private static final float SAFETY_MARGIN = 1.2f;
    private Thread houseKeeperThread = null;
    private boolean transactionsSupported = false;
    private boolean threadRunning = false;
    private Configuration configuration;
    private static final String DB_IDBROKER_CLEVERQUANTITY = "idbroker.clever.quantity";
    private static final String DB_IDBROKER_CLEVERQUANTITY_MAX = "idbroker.clever.quantity.max";
    private static final String DB_IDBROKER_PREFETCH = "idbroker.prefetch";
    private static final String DB_IDBROKER_USENEWCONNECTION = "idbroker.usenewconnection";
    private static final Logger log = LogManager.getLogger(IDBroker.class);

    public IDBroker(Database database) {
        this.databaseName = database.getName();
        Torque.registerIDBroker(this);
    }

    public void start() {
        this.configuration = Torque.getConfiguration();
        if (this.configuration.getBoolean(DB_IDBROKER_PREFETCH, true)) {
            this.houseKeeperThread = new Thread(this);
            this.houseKeeperThread.setDaemon(true);
            this.houseKeeperThread.setName("Torque - ID Broker thread");
            this.houseKeeperThread.start();
        }
        try (TorqueConnection dbCon = Transaction.begin(this.databaseName);){
            this.transactionsSupported = dbCon.getMetaData().supportsTransactions();
            Transaction.commit(dbCon);
        }
        catch (Exception e) {
            log.warn("Could not read from connection Metadata whether transactions are supported for the database {}", (Object)this.databaseName, (Object)e);
            this.transactionsSupported = false;
        }
        if (!this.transactionsSupported) {
            log.warn("IDBroker is being used with db '{}', which does not support transactions. IDBroker attempts to use transactions to limit the possibility of duplicate key generation.  Without transactions, duplicate key generation is possible if multiple JVMs are used or other means are used to write to the database.", (Object)this.databaseName);
        }
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public int getIdAsInt(Connection connection, Object tableName) throws TorqueException {
        return this.getIdAsBigDecimal(connection, tableName).intValue();
    }

    @Override
    public long getIdAsLong(Connection connection, Object tableName) throws TorqueException {
        return this.getIdAsBigDecimal(connection, tableName).longValue();
    }

    @Override
    public BigDecimal getIdAsBigDecimal(Connection connection, Object tableName) throws TorqueException {
        BigDecimal[] id = this.getNextIds((String)tableName, 1, connection);
        return id[0];
    }

    @Override
    public String getIdAsString(Connection connection, Object tableName) throws TorqueException {
        return this.getIdAsBigDecimal(connection, tableName).toString();
    }

    @Override
    public boolean isPriorToInsert() {
        return true;
    }

    @Override
    public boolean isPostInsert() {
        return false;
    }

    @Override
    public boolean isConnectionRequired() {
        return false;
    }

    @Override
    public boolean isGetGeneratedKeysSupported() {
        return false;
    }

    public boolean isThreadRunning() {
        return this.threadRunning;
    }

    public BigDecimal[] getNextIds(String tableName, int numOfIdsToReturn) throws Exception {
        return this.getNextIds(tableName, numOfIdsToReturn, null);
    }

    public synchronized BigDecimal[] getNextIds(String tableName, int numOfIdsToReturn, Connection connection) throws TorqueException {
        if (tableName == null) {
            throw new TorqueException("getNextIds(): tableName == null");
        }
        List availableIds = (List)this.ids.get(tableName);
        if (availableIds == null || availableIds.size() < numOfIdsToReturn) {
            if (availableIds == null) {
                log.debug("Forced id retrieval - no available list for table {}", (Object)tableName);
            } else {
                log.debug("Forced id retrieval - {} ids still available for table {}", (Object)availableIds.size(), (Object)tableName);
            }
            this.storeIDs(tableName, true, connection);
            availableIds = (List)this.ids.get(tableName);
        }
        int size = Math.min(availableIds.size(), numOfIdsToReturn);
        BigDecimal[] results = new BigDecimal[size];
        ListIterator it = availableIds.listIterator(size);
        for (int i = size - 1; i >= 0; --i) {
            results[i] = (BigDecimal)it.previous();
            it.remove();
        }
        return results;
    }

    public boolean exists(String tableName) throws Exception {
        String query = "select " + TABLE_NAME + " where " + TABLE_NAME + "='" + tableName + '\'';
        boolean exists = false;
        try (TorqueConnection dbCon = Transaction.begin(this.databaseName);){
            Statement statement = dbCon.createStatement();
            ResultSet rs = statement.executeQuery(query);
            exists = rs.next();
            statement.close();
            Transaction.commit(dbCon);
        }
        return exists;
    }

    @Override
    public void run() {
        log.debug("IDBroker thread was started.");
        this.threadRunning = true;
        Thread thisThread = Thread.currentThread();
        while (this.houseKeeperThread == thisThread) {
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException exc) {
                log.trace("InterruptedException caught and ignored during IdBroker sleep");
            }
            this.ids.forEach((tableName, availableIds) -> {
                log.debug("IDBroker thread checking for more keys on table: {}", tableName);
                int quantity = this.getQuantity((String)tableName, null).intValue();
                if (quantity > availableIds.size()) {
                    try {
                        this.storeIDs((String)tableName, false, null);
                        log.debug("Retrieved more ids for table: {}", tableName);
                    }
                    catch (Exception exc) {
                        log.error("There was a problem getting new IDs for table: {}", tableName, (Object)exc);
                    }
                }
            });
        }
        log.debug("IDBroker thread finished.");
        this.threadRunning = false;
    }

    public void stop() {
        if (this.houseKeeperThread != null) {
            Thread localHouseKeeperThread = this.houseKeeperThread;
            this.houseKeeperThread = null;
            localHouseKeeperThread.interrupt();
        }
        this.ids.clear();
        this.lastQueryTime.clear();
        this.quantityStore.clear();
        this.transactionsSupported = false;
    }

    private void checkTiming(String tableName) {
        if (!this.configuration.getBoolean(DB_IDBROKER_CLEVERQUANTITY, true) || !this.configuration.getBoolean(DB_IDBROKER_PREFETCH, true)) {
            return;
        }
        Date now = new Date();
        Date lastTime = this.lastQueryTime.putIfAbsent(tableName, now);
        if (lastTime != null) {
            long thenLong = lastTime.getTime();
            long nowLong = now.getTime();
            long timeLapse = nowLong - thenLong;
            log.debug("checkTiming(): sleep time was {} milliseconds for table {}", (Object)timeLapse, (Object)tableName);
            if (timeLapse < 60000L) {
                double newQuantity;
                log.debug("checkTiming(): Unscheduled retrieval of ids for table {}", (Object)tableName);
                BigDecimal quantity = this.getQuantity(tableName, null);
                if (timeLapse > 0L) {
                    float rate = quantity.floatValue() / (float)timeLapse;
                    newQuantity = Math.ceil(60000.0f * rate * 1.2f);
                    log.debug("checkTiming(): calculated new quantity {} from rate {}", (Object)newQuantity, (Object)Float.valueOf(rate));
                } else {
                    newQuantity = quantity.floatValue() * 2.0f;
                    log.debug("checkTiming(): calculated new quantity {} from double the old quantity (time lapse 0)", (Object)newQuantity);
                }
                BigDecimal bdNewQuantity = BigDecimal.valueOf(newQuantity);
                BigDecimal maxQuantity = this.configuration.getBigDecimal(DB_IDBROKER_CLEVERQUANTITY_MAX, CLEVERQUANTITY_MAX_DEFAULT);
                if (maxQuantity != null && bdNewQuantity.compareTo(maxQuantity) > 0) {
                    bdNewQuantity = quantity.compareTo(maxQuantity) > 0 ? quantity : maxQuantity;
                }
                this.quantityStore.put(tableName, bdNewQuantity);
                log.debug("checkTiming(): new quantity {} stored in quantity store (not in db)", (Object)bdNewQuantity);
            }
        }
    }

    private synchronized void storeIDs(String tableName, boolean adjustQuantity, Connection connection) throws TorqueException {
        log.debug("storeIDs(): Start retrieving ids from database.");
        BigDecimal nextId = null;
        BigDecimal quantity = null;
        if (adjustQuantity) {
            this.checkTiming(tableName);
        }
        boolean useNewConnection = connection == null || this.configuration.getBoolean(DB_IDBROKER_USENEWCONNECTION, true);
        try {
            if (useNewConnection) {
                connection = Transaction.begin(this.databaseName);
                if (log.isTraceEnabled()) {
                    log.trace("storeIDs(): fetched connection, started transaction.");
                }
            }
            quantity = this.getQuantity(tableName, connection);
            this.updateQuantity(connection, tableName, quantity);
            BigDecimal[] results = this.selectRow(connection, tableName);
            nextId = results[0];
            BigDecimal newNextId = nextId.add(quantity);
            this.updateNextId(connection, tableName, newNextId.toString());
            if (useNewConnection) {
                Transaction.commit(connection);
                if (log.isTraceEnabled()) {
                    log.trace("storeIDs(): Transaction committed, connection returned");
                }
            }
        }
        catch (TorqueException e) {
            if (useNewConnection) {
                Transaction.safeRollback(connection);
            }
            throw e;
        }
        List availableIds = this.ids.computeIfAbsent(tableName, key -> new ArrayList());
        int numId = quantity.intValue();
        for (int i = 0; i < numId; ++i) {
            availableIds.add(nextId);
            nextId = nextId.add(BigDecimal.ONE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal getQuantity(String tableName, Connection connection) {
        BigDecimal quantity = null;
        if (!this.configuration.getBoolean(DB_IDBROKER_PREFETCH, true)) {
            quantity = BigDecimal.ONE;
        } else if (this.quantityStore.containsKey(tableName)) {
            quantity = (BigDecimal)this.quantityStore.get(tableName);
        } else {
            log.debug("getQuantity() : start fetch quantity for table {} from database", (Object)tableName);
            boolean useNewConnection = connection == null || this.configuration.getBoolean(DB_IDBROKER_USENEWCONNECTION, true);
            try {
                if (useNewConnection) {
                    connection = Transaction.begin(this.databaseName);
                    if (log.isTraceEnabled()) {
                        log.trace("getQuantity(): connection fetched, transaction started");
                    }
                }
                BigDecimal[] results = this.selectRow(connection, tableName);
                quantity = results[1];
                this.quantityStore.put(tableName, quantity);
                log.debug("getQuantity() : quantity fetched for table {}, result is {}", (Object)tableName, (Object)quantity);
                if (useNewConnection) {
                    Transaction.commit(connection);
                    connection = null;
                    if (log.isTraceEnabled()) {
                        log.trace("getQuantity(): transaction committed, connection returned");
                    }
                }
            }
            catch (Exception e) {
                quantity = PREFETCH_BACKUP_QUANTITY;
            }
            finally {
                if (useNewConnection && connection != null) {
                    Transaction.safeRollback(connection);
                }
            }
        }
        return quantity;
    }

    private BigDecimal[] selectRow(Connection con, String tableName) throws TorqueException {
        BigDecimal[] results;
        block15: {
            StringBuilder stmt = new StringBuilder();
            stmt.append("SELECT ").append(COL_NEXT_ID).append(", ").append(COL_QUANTITY).append(" FROM ").append(ID_TABLE).append(" WHERE ").append(COL_TABLE_NAME).append(" = ?");
            results = new BigDecimal[2];
            try (PreparedStatement statement = con.prepareStatement(stmt.toString());){
                statement.setString(1, tableName);
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        results[0] = new BigDecimal(rs.getString(1));
                        results[1] = new BigDecimal(rs.getString(2));
                        break block15;
                    }
                    throw new TorqueException("The table " + tableName + " does not have a proper entry in the ID_TABLE");
                }
            }
            catch (SQLException e) {
                throw new TorqueException(e);
            }
        }
        return results;
    }

    private void updateNextId(Connection con, String tableName, String id) throws TorqueException {
        StringBuilder stmt = new StringBuilder();
        stmt.append("UPDATE ID_TABLE").append(" SET ").append(COL_NEXT_ID).append(" = ").append(id).append(" WHERE ").append(COL_TABLE_NAME).append(" = '").append(tableName).append('\'');
        log.debug("updateNextId: {}", new Supplier[]{() -> stmt.toString()});
        try (Statement statement = con.createStatement();){
            statement.executeUpdate(stmt.toString());
        }
        catch (SQLException e) {
            throw new TorqueException(e);
        }
    }

    protected void updateQuantity(Connection con, String tableName, BigDecimal quantity) throws TorqueException {
        log.debug("updateQuantity(): start for table {} and quantity {}", (Object)tableName, (Object)quantity);
        StringBuilder stmt = new StringBuilder();
        stmt.append("UPDATE ").append(ID_TABLE).append(" SET ").append(COL_QUANTITY).append(" = ").append(quantity).append(" WHERE ").append(COL_TABLE_NAME).append(" = '").append(tableName).append('\'');
        log.debug("updateQuantity(): {}", new Supplier[]{() -> stmt.toString()});
        try (Statement statement = con.createStatement();){
            statement.executeUpdate(stmt.toString());
            log.debug("updateQuantity(): quantity written, end");
        }
        catch (SQLException e) {
            throw new TorqueException(e);
        }
    }

    protected BigDecimal getQuantity(String tableName) {
        return (BigDecimal)this.quantityStore.get(tableName);
    }
}

