package org.apache.torque.map;

import org.apache.torque.BaseTestCase;


/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * Test for the class ColumnMap.
 *
 * @version $Id: ColumnMapTest.java 1448414 2013-02-20 21:06:35Z tfischer $
 */
public class ColumnMapTest extends BaseTestCase
{
    public void testGetSqlExpressionNoSchemaDefaultSchemaNull()
    {
        ColumnMap column = new ColumnMap("columnName", tableMap);
        assertEquals("TABLE.columnName", column.getSqlExpression());
    }

    public void testGetFullTableNameWithoutDefaultSchema()
    {
        ColumnMap column = new ColumnMap("columnName", tableMap);
        assertEquals(
                "TABLE",
                column.getFullTableName());
    }

    public void testGetFullTableNameWithDefaultSchema()
    {
        tableMap = databaseMap.addTable("schemaName.TABLE");
        ColumnMap column = new ColumnMap("columnName", tableMap);
        assertEquals(
                "schemaName.TABLE",
                column.getFullTableName());
    }
}
