/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RefDataValue;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class SQLRef
extends DataType
implements RefDataValue {
    protected RowLocation value;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLRef.class);

    @Override
    public int estimateMemoryUsage() {
        int sz = BASE_MEMORY_USAGE;
        if (null != this.value) {
            sz += this.value.estimateMemoryUsage();
        }
        return sz;
    }

    @Override
    public String getString() {
        if (this.value != null) {
            return this.value.toString();
        }
        return null;
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    protected void setFrom(DataValueDescriptor theValue) throws StandardException {
        if (theValue.isNull()) {
            this.setToNull();
        } else {
            this.value = (RowLocation)theValue.getObject();
        }
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public String getTypeName() {
        return "REF";
    }

    @Override
    public int getTypeFormatId() {
        return 82;
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SanityManager.ASSERT(this.value != null, "writeExternal() is not supposed to be called for null values.");
        out.writeObject(this.value);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.value = (RowLocation)in.readObject();
    }

    @Override
    public void restoreToNull() {
        this.value = null;
    }

    @Override
    public boolean compare(int op, DataValueDescriptor other, boolean orderedNulls, boolean unknownRV) throws StandardException {
        return this.value.compare(op, ((SQLRef)other).value, orderedNulls, unknownRV);
    }

    @Override
    public int compare(DataValueDescriptor other) throws StandardException {
        return this.value.compare(((SQLRef)other).value);
    }

    @Override
    public DataValueDescriptor cloneValue(boolean forceMaterialization) {
        if (this.value == null) {
            return new SQLRef();
        }
        return new SQLRef((RowLocation)this.value.cloneValue(false));
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLRef();
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) {
        SanityManager.THROWASSERT("setValueFromResultSet() is not supposed to be called for SQLRef.");
    }

    @Override
    public void setInto(PreparedStatement ps, int position) {
        SanityManager.THROWASSERT("setValueInto(PreparedStatement) is not supposed to be called for SQLRef.");
    }

    public SQLRef() {
    }

    public SQLRef(RowLocation rowLocation) {
        this.value = rowLocation;
    }

    @Override
    public void setValue(RowLocation rowLocation) {
        this.value = rowLocation;
    }

    public String toString() {
        if (this.value == null) {
            return "NULL";
        }
        return this.value.toString();
    }

    public int hashCode() {
        if (this.value == null) {
            return 0;
        }
        return this.value.hashCode();
    }
}

