/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.io.Closeable;
import java.net.URL;
import java.net.URLClassLoader;
import junit.extensions.TestSetup;
import junit.framework.Test;

public class ClasspathSetup
extends TestSetup {
    private URL _resource;
    private ClassLoader _originalClassLoader;
    private URLClassLoader _newClassLoader;

    public ClasspathSetup(Test test, URL resource) {
        super(test);
        this._resource = resource;
    }

    protected void setUp() {
        this._originalClassLoader = Thread.currentThread().getContextClassLoader();
        this._newClassLoader = new URLClassLoader(new URL[]{this._resource}, this._originalClassLoader);
        Thread.currentThread().setContextClassLoader(this._newClassLoader);
    }

    protected void tearDown() throws Exception {
        Thread.currentThread().setContextClassLoader(this._originalClassLoader);
        if (this._newClassLoader instanceof Closeable) {
            this._newClassLoader.close();
        }
        this._originalClassLoader = null;
        this._newClassLoader = null;
        this._resource = null;
    }

    public static boolean supportsClose() {
        return Closeable.class.isAssignableFrom(URLClassLoader.class);
    }
}

