/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;

abstract class CanonTestCase
extends BaseJDBCTestCase {
    static final String DEFAULT_ENCODING = "US-ASCII";
    final String outputEncoding;
    private ByteArrayOutputStream rawBytes;

    CanonTestCase(String name) {
        this(name, null);
    }

    CanonTestCase(String name, String encoding) {
        super(name);
        this.outputEncoding = encoding == null ? DEFAULT_ENCODING : encoding;
    }

    OutputStream getOutputStream() {
        this.rawBytes = new ByteArrayOutputStream(20480);
        return this.rawBytes;
    }

    void compareCanon(String canon) throws Throwable {
        this.rawBytes.flush();
        this.rawBytes.close();
        byte[] testRawBytes = this.rawBytes.toByteArray();
        this.rawBytes = null;
        BufferedReader cannonReader = null;
        BufferedReader testOutput = null;
        try {
            URL canonURL = CanonTestCase.getTestResource(canon);
            CanonTestCase.assertNotNull((String)("No master file " + canon), (Object)canonURL);
            InputStream canonStream = CanonTestCase.openTestResource(canonURL);
            cannonReader = new BufferedReader(new InputStreamReader(canonStream, this.outputEncoding));
            testOutput = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(testRawBytes), this.outputEncoding));
            int lineNumber = 1;
            while (true) {
                String testLine = testOutput.readLine();
                String canonLine = cannonReader.readLine();
                if (canonLine == null && testLine == null) {
                    break;
                }
                if (canonLine == null) {
                    CanonTestCase.fail((String)"More output from test than expected");
                }
                if (testLine == null) {
                    CanonTestCase.fail((String)("Less output from test than expected, stoped at line" + lineNumber));
                }
                CanonTestCase.assertEquals((String)("Output at line " + lineNumber), (String)canonLine, (String)testLine);
                ++lineNumber;
            }
        }
        catch (Throwable t) {
            this.dumpForFail(testRawBytes);
            throw t;
        }
        finally {
            if (cannonReader != null) {
                try {
                    cannonReader.close();
                }
                catch (IOException canonURL) {}
            }
            if (testOutput != null) {
                try {
                    testOutput.close();
                }
                catch (IOException canonURL) {}
            }
        }
    }

    private void dumpForFail(byte[] rawOutput) throws IOException {
        File folder = this.getFailureFolder();
        File outFile = new File(folder, this.getName() + ".out");
        FileOutputStream outStream = new FileOutputStream(outFile);
        ((OutputStream)outStream).write(rawOutput);
        outStream.flush();
        ((OutputStream)outStream).close();
    }
}

