/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.derby.iapi.jdbc.EnginePreparedStatement;
import org.apache.derby.iapi.jdbc.EngineStatement;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.drda.ConsistencyToken;
import org.apache.derby.impl.drda.DRDAResultSet;
import org.apache.derby.impl.drda.Database;
import org.apache.derby.impl.drda.EXTDTAReaderInputStream;
import org.apache.derby.impl.drda.FdocaConstants;
import org.apache.derby.impl.drda.Pkgnamcsn;
import org.apache.derby.impl.jdbc.Util;

class DRDAStatement {
    protected String typDefNam;
    protected int byteOrder;
    protected int ccsidSBC;
    protected int ccsidDBC;
    protected int ccsidMBC;
    protected String ccsidSBCEncoding;
    protected String ccsidDBCEncoding;
    protected String ccsidMBCEncoding;
    protected Database database;
    private Pkgnamcsn pkgnamcsn;
    int withHoldCursor = -1;
    protected int isolationLevel;
    protected String cursorName;
    protected int scrollType = 1003;
    protected int concurType = 1007;
    protected long rowCount;
    protected byte[] rslsetflg;
    protected int maxrslcnt;
    protected EnginePreparedStatement ps;
    protected ParameterMetaData stmtPmeta;
    protected boolean isCall;
    protected String procName;
    private int[] outputTypes;
    private int[] outputPrecision;
    private int[] outputScale;
    protected static int NOT_OUTPUT_PARAM = -100000;
    protected boolean outputExpected;
    private EngineStatement stmt;
    private DRDAResultSet currentDrdaRs;
    private Hashtable<ConsistencyToken, DRDAResultSet> resultSetTable;
    private ArrayList<ConsistencyToken> resultSetKeyList;
    private int numResultSets = 0;
    private DataTruncation truncationWarnings;
    private DrdaParamState drdaParamState_ = new DrdaParamState();
    protected int nbrrow;
    protected int qryrowset;
    protected int blksize;
    protected int maxblkext;
    protected int outovropt;
    protected boolean qryrfrtbl;
    private int qryprctyp = 9239;
    boolean needsToSendParamData = false;
    boolean explicitlyPrepared = false;
    long versionCounter;
    int sqldaType;

    DRDAStatement(Database database) {
        this.database = database;
        this.setTypDefValues();
        this.currentDrdaRs = new DRDAResultSet();
    }

    protected void setTypDefValues() {
        this.typDefNam = this.database.typDefNam;
        this.byteOrder = this.database.byteOrder;
        this.ccsidSBC = this.database.ccsidSBC;
        this.ccsidDBC = this.database.ccsidDBC;
        this.ccsidMBC = this.database.ccsidMBC;
        this.ccsidSBCEncoding = this.database.ccsidSBCEncoding;
        this.ccsidDBCEncoding = this.database.ccsidDBCEncoding;
        this.ccsidMBCEncoding = this.database.ccsidMBCEncoding;
    }

    protected void setDatabase(Database database) {
        this.database = database;
        this.setTypDefValues();
    }

    protected void setStatement(Connection conn) throws SQLException {
        this.stmt = (EngineStatement)conn.createStatement();
        if (this.cursorName != null) {
            this.stmt.setCursorName(this.cursorName);
        }
    }

    protected EngineStatement getStatement() throws SQLException {
        return this.stmt;
    }

    protected void addTruncationWarning(DataTruncation w) {
        if (this.truncationWarnings == null) {
            this.truncationWarnings = w;
        } else {
            this.truncationWarnings.setNextWarning(w);
        }
    }

    protected DataTruncation getTruncationWarnings() {
        return this.truncationWarnings;
    }

    protected void clearTruncationWarnings() {
        this.truncationWarnings = null;
    }

    protected void setRsDefaultOptions(DRDAResultSet drs) {
        drs.nbrrow = this.nbrrow;
        drs.qryrowset = this.qryrowset;
        drs.blksize = this.blksize;
        drs.maxblkext = this.maxblkext;
        drs.outovropt = this.outovropt;
        drs.rslsetflg = this.rslsetflg;
        drs.scrollType = this.scrollType;
        drs.concurType = this.concurType;
        drs.setQryprctyp(this.qryprctyp);
        drs.qryrowset = this.qryrowset;
    }

    protected ArrayList<Object> getExtDtaObjects() {
        return this.currentDrdaRs.getExtDtaObjects();
    }

    public void setSplitQRYDTA(byte[] data) {
        this.currentDrdaRs.setSplitQRYDTA(data);
    }

    public byte[] getSplitQRYDTA() {
        return this.currentDrdaRs.getSplitQRYDTA();
    }

    protected void addExtDtaObject(Object o, int jdbcIndex) {
        this.currentDrdaRs.addExtDtaObject(o, jdbcIndex);
    }

    protected void clearExtDtaObjects() {
        this.currentDrdaRs.clearExtDtaObjects();
    }

    protected boolean isExtDtaValueNullable(int index) {
        return this.currentDrdaRs.isExtDtaValueNullable(index);
    }

    protected void setOPNQRYOptions(int blksize, int qryblkctl, int maxblkext, int outovropt, int qryrowset, int qryclsimpl) {
        this.blksize = blksize;
        this.qryprctyp = qryblkctl;
        this.maxblkext = maxblkext;
        this.outovropt = outovropt;
        this.qryrowset = qryrowset;
        this.currentDrdaRs.setOPNQRYOptions(blksize, qryblkctl, maxblkext, outovropt, qryrowset, qryclsimpl);
    }

    protected void setQueryOptions(int blksize, boolean qryrelscr, long qryrownbr, boolean qryfrtbl, int nbrrow, int maxblkext, int qryscrorn, boolean qryrowsns, boolean qryblkrst, boolean qryrtndta, int qryrowset, int rtnextdta) {
        this.currentDrdaRs.blksize = blksize;
        this.currentDrdaRs.qryrelscr = qryrelscr;
        this.currentDrdaRs.qryrownbr = qryrownbr;
        this.currentDrdaRs.qryrfrtbl = this.qryrfrtbl;
        this.currentDrdaRs.nbrrow = nbrrow;
        this.currentDrdaRs.maxblkext = maxblkext;
        this.currentDrdaRs.qryscrorn = qryscrorn;
        this.currentDrdaRs.qryrowsns = qryrowsns;
        this.currentDrdaRs.qryblkrst = qryblkrst;
        this.currentDrdaRs.qryrtndta = qryrtndta;
        this.currentDrdaRs.qryrowset = qryrowset;
        this.currentDrdaRs.rtnextdta = rtnextdta;
    }

    protected void setQryprctyp(int qryprctyp) {
        this.qryprctyp = qryprctyp;
        this.currentDrdaRs.setQryprctyp(qryprctyp);
    }

    protected int getQryprctyp() throws SQLException {
        return this.currentDrdaRs.getQryprctyp();
    }

    protected void setQryrownbr(long qryrownbr) {
        this.currentDrdaRs.qryrownbr = qryrownbr;
    }

    protected long getQryrownbr() {
        return this.currentDrdaRs.qryrownbr;
    }

    protected int getQryrowset() {
        return this.currentDrdaRs.qryrowset;
    }

    protected int getBlksize() {
        return this.currentDrdaRs.blksize;
    }

    protected void setQryrtndta(boolean qryrtndta) {
        this.currentDrdaRs.qryrtndta = qryrtndta;
    }

    protected boolean getQryrtndta() {
        return this.currentDrdaRs.qryrtndta;
    }

    protected void setQryscrorn(int qryscrorn) {
        this.currentDrdaRs.qryscrorn = qryscrorn;
    }

    protected int getQryscrorn() {
        return this.currentDrdaRs.qryscrorn;
    }

    protected void setScrollType(int scrollType) {
        this.currentDrdaRs.scrollType = scrollType;
    }

    protected int getScrollType() {
        return this.currentDrdaRs.scrollType;
    }

    protected boolean isScrollable() {
        return this.getScrollType() != 1003;
    }

    protected void setConcurType(int scrollType) {
        this.currentDrdaRs.concurType = scrollType;
    }

    protected int getConcurType() {
        return this.currentDrdaRs.concurType;
    }

    protected void setOutovr_drdaType(int[] outovr_drdaType) {
        this.currentDrdaRs.outovr_drdaType = outovr_drdaType;
    }

    protected int[] getOutovr_drdaType() {
        return this.currentDrdaRs.outovr_drdaType;
    }

    protected boolean hasdata() {
        return this.currentDrdaRs.hasdata;
    }

    protected void setHasdata(boolean hasdata) {
        this.currentDrdaRs.hasdata = hasdata;
    }

    protected void initialize() {
        this.setTypDefValues();
    }

    protected PreparedStatement explicitPrepare(String sqlStmt) throws SQLException {
        this.explicitlyPrepared = true;
        return this.prepare(sqlStmt);
    }

    protected boolean wasExplicitlyPrepared() {
        return this.explicitlyPrepared;
    }

    protected PreparedStatement prepare(String sqlStmt) throws SQLException {
        int saveIsolationLevel = -1;
        boolean isolationSet = false;
        if (this.pkgnamcsn != null && this.isolationLevel != 0) {
            saveIsolationLevel = this.database.getPrepareIsolation();
            this.database.setPrepareIsolation(this.isolationLevel);
            isolationSet = true;
        }
        this.parsePkgidToFindHoldability();
        if (this.isCallableSQL(sqlStmt)) {
            this.isCall = true;
            this.ps = (EnginePreparedStatement)((Object)this.database.getConnection().prepareCall(sqlStmt, this.scrollType, this.concurType, this.withHoldCursor));
            this.setupCallableStatementParams((CallableStatement)((Object)this.ps));
        } else {
            this.ps = (EnginePreparedStatement)this.database.getConnection().prepareStatement(sqlStmt, this.scrollType, this.concurType, this.withHoldCursor);
        }
        if (this.cursorName != null) {
            this.ps.setCursorName(this.cursorName);
        }
        if (isolationSet) {
            this.database.setPrepareIsolation(saveIsolationLevel);
        }
        this.versionCounter = this.ps.getVersionCounter();
        return this.ps;
    }

    protected EnginePreparedStatement getPreparedStatement() throws SQLException {
        return this.ps;
    }

    protected boolean execute() throws SQLException {
        boolean hasResultSet = this.ps.execute();
        try {
            this.drdaParamState_.drainStreamedParameter();
        }
        catch (IOException e) {
            throw Util.javaException(e);
        }
        this.numResultSets = 0;
        ResultSet rs = null;
        boolean isCallable = this.ps instanceof CallableStatement;
        if (isCallable) {
            this.needsToSendParamData = true;
        }
        do {
            if ((rs = this.ps.getResultSet()) == null) continue;
            if (isCallable) {
                this.addResultSet(rs, rs.getHoldability());
            } else {
                this.addResultSet(rs, this.withHoldCursor);
            }
            hasResultSet = true;
        } while (isCallable && this.getMoreResults(2));
        return hasResultSet;
    }

    protected void finishParams() {
        this.needsToSendParamData = false;
    }

    protected void setPkgnamcsn(Pkgnamcsn pkgnamcsn) {
        this.pkgnamcsn = pkgnamcsn;
        String pkgid = pkgnamcsn.getPkgid();
        if (this.isDynamicPkgid(pkgid)) {
            this.isolationLevel = Integer.parseInt(pkgid.substring(5, 6));
            String shortPkgid = pkgid.substring(pkgid.length() - 5, pkgid.length());
            int pkgsn = pkgnamcsn.getPkgsn();
            this.cursorName = "SQL_CUR" + shortPkgid + "C" + pkgsn;
        } else {
            this.isolationLevel = this.getStaticPackageIsolation(pkgid);
        }
    }

    private int getStaticPackageIsolation(String pkgid) {
        if (pkgid.equals("SYSSTAT")) {
            return 1;
        }
        return 0;
    }

    protected Pkgnamcsn getPkgnamcsn() {
        return this.pkgnamcsn;
    }

    protected ResultSet getResultSet() {
        return this.currentDrdaRs.getResultSet();
    }

    protected DRDAResultSet getCurrentDrdaResultSet() {
        return this.currentDrdaRs;
    }

    protected void setCurrentDrdaResultSet(int rsNum) {
        ConsistencyToken consistToken = this.getResultSetPkgcnstkn(rsNum);
        if (this.currentDrdaRs.pkgcnstkn == consistToken) {
            return;
        }
        this.currentDrdaRs = this.getDrdaResultSet(consistToken);
    }

    protected void setCurrentDrdaResultSet(Pkgnamcsn pkgnamcsn) {
        this.pkgnamcsn = pkgnamcsn;
        ConsistencyToken consistToken = pkgnamcsn.getPkgcnstkn();
        DRDAResultSet newDrdaRs = this.getDrdaResultSet(consistToken);
        if (newDrdaRs != null) {
            this.currentDrdaRs = newDrdaRs;
        }
    }

    private DRDAResultSet getDrdaResultSet(ConsistencyToken consistToken) {
        if (this.resultSetTable == null || this.currentDrdaRs != null && this.currentDrdaRs.pkgcnstkn == consistToken) {
            return this.currentDrdaRs;
        }
        return this.resultSetTable.get(consistToken);
    }

    private DRDAResultSet getDrdaResultSet(int rsNum) {
        ConsistencyToken consistToken = this.getResultSetPkgcnstkn(rsNum);
        return this.getDrdaResultSet(consistToken);
    }

    protected ConsistencyToken addResultSet(ResultSet value, int holdValue) throws SQLException {
        DRDAResultSet newDrdaRs = null;
        int rsNum = this.numResultSets;
        ConsistencyToken newRsPkgcnstkn = this.calculateResultSetPkgcnstkn(rsNum);
        if (rsNum == 0) {
            newDrdaRs = this.currentDrdaRs;
        } else {
            newDrdaRs = new DRDAResultSet();
            if (this.resultSetTable == null) {
                this.resultSetTable = new Hashtable();
                ConsistencyToken pkgcnstkn = this.pkgnamcsn.getPkgcnstkn();
                this.resultSetTable.put(pkgcnstkn, this.currentDrdaRs);
                this.resultSetKeyList = new ArrayList();
                this.resultSetKeyList.add(0, pkgcnstkn);
            }
            this.resultSetTable.put(newRsPkgcnstkn, newDrdaRs);
            this.resultSetKeyList.add(rsNum, newRsPkgcnstkn);
        }
        newDrdaRs.setResultSet(value);
        newDrdaRs.setPkgcnstkn(newRsPkgcnstkn);
        newDrdaRs.withHoldCursor = holdValue;
        this.setRsDefaultOptions(newDrdaRs);
        newDrdaRs.suspend();
        ++this.numResultSets;
        return newRsPkgcnstkn;
    }

    protected int getNumResultSets() {
        return this.numResultSets;
    }

    protected ConsistencyToken getResultSetPkgcnstkn(int rsNum) {
        if (rsNum == 0) {
            return this.pkgnamcsn.getPkgcnstkn();
        }
        return this.resultSetKeyList.get(rsNum);
    }

    protected int[] getRsDRDATypes() {
        return this.currentDrdaRs.getRsDRDATypes();
    }

    protected void rsClose() throws SQLException {
        if (this.currentDrdaRs.getResultSet() == null) {
            return;
        }
        this.currentDrdaRs.close();
        this.needsToSendParamData = false;
        --this.numResultSets;
    }

    protected void CLSQRY() {
        this.currentDrdaRs.CLSQRY();
    }

    protected boolean wasExplicitlyClosed() {
        return this.currentDrdaRs.wasExplicitlyClosed();
    }

    protected void close() throws SQLException {
        if (this.ps != null) {
            this.ps.close();
        }
        if (this.stmt != null) {
            this.stmt.close();
        }
        this.currentDrdaRs.close();
        this.resultSetTable = null;
        this.resultSetKeyList = null;
        this.ps = null;
        this.stmtPmeta = null;
        this.stmt = null;
        this.truncationWarnings = null;
        this.rslsetflg = null;
        this.procName = null;
        this.outputTypes = null;
        this.outputPrecision = null;
        this.outputScale = null;
        this.drdaParamState_.clear(true);
    }

    protected void reset() {
        this.setTypDefValues();
        this.withHoldCursor = -1;
        this.scrollType = 1003;
        this.concurType = 1007;
        this.rowCount = 0L;
        this.rslsetflg = null;
        this.maxrslcnt = 0;
        this.ps = null;
        this.stmtPmeta = null;
        this.isCall = false;
        this.procName = null;
        this.outputTypes = null;
        this.outputExpected = false;
        this.stmt = null;
        this.truncationWarnings = null;
        this.currentDrdaRs.reset();
        this.resultSetTable = null;
        this.resultSetKeyList = null;
        this.numResultSets = 0;
        this.drdaParamState_.clear(false);
        this.nbrrow = 0;
        this.qryrowset = 0;
        this.blksize = 0;
        this.maxblkext = 0;
        this.outovropt = 0;
        this.qryrfrtbl = false;
        this.qryprctyp = 9239;
        this.needsToSendParamData = false;
        this.explicitlyPrepared = false;
    }

    protected boolean rsIsClosed() {
        return this.currentDrdaRs.isClosed();
    }

    protected void rsSuspend() {
        this.currentDrdaRs.suspend();
    }

    protected void setRsPrecision(int index, int precision) {
        this.currentDrdaRs.setRsPrecision(index, precision);
    }

    protected int getRsPrecision(int index) {
        return this.currentDrdaRs.getRsPrecision(index);
    }

    protected void setRsScale(int index, int scale) {
        this.currentDrdaRs.setRsScale(index, scale);
    }

    protected int getRsScale(int index) {
        return this.currentDrdaRs.getRsScale(index);
    }

    protected void setRsDRDAType(int index, int type) {
        this.currentDrdaRs.setRsDRDAType(index, type);
    }

    protected void clearDrdaParams() {
        this.drdaParamState_.clear(false);
    }

    protected int getExtPositionCount() {
        return this.drdaParamState_.getExtPosCount();
    }

    protected int getExtPosition(int i) {
        return this.drdaParamState_.getExtPos(i);
    }

    protected void addExtPosition(int pos) {
        this.drdaParamState_.addExtPos(pos);
    }

    protected int getDrdaParamCount() {
        return this.drdaParamState_.getDrdaParamCount();
    }

    protected void addDrdaParam(byte t, int l) {
        this.drdaParamState_.addDrdaParam(t, l);
    }

    protected void setStreamedParameter(EXTDTAReaderInputStream eis) {
        this.drdaParamState_.setStreamedParameter(eis);
    }

    protected int getParamDRDAType(int index) {
        return this.drdaParamState_.getDrdaType(index - 1);
    }

    protected int getParamLen(int index) {
        return this.drdaParamState_.getDrdaLen(index - 1);
    }

    protected int getParamPrecision(int index) throws SQLException {
        if (this.ps != null && this.ps instanceof CallableStatement) {
            ParameterMetaData pmeta = this.getParameterMetaData();
            return Math.min(pmeta.getPrecision(index), FdocaConstants.NUMERIC_MAX_PRECISION);
        }
        return -1;
    }

    protected int getParamScale(int index) throws SQLException {
        if (this.ps != null && this.ps instanceof CallableStatement) {
            ParameterMetaData pmeta = this.getParameterMetaData();
            return Math.min(pmeta.getScale(index), FdocaConstants.NUMERIC_MAX_PRECISION);
        }
        return -1;
    }

    protected int getNumRsCols() {
        int[] rsDrdaTypes = this.getRsDRDATypes();
        if (rsDrdaTypes != null) {
            return rsDrdaTypes.length;
        }
        return 0;
    }

    protected int getRsDRDAType(int index) {
        return this.currentDrdaRs.getRsDRDAType(index);
    }

    protected int getRsLen(int index) {
        return this.currentDrdaRs.getRsLen(index);
    }

    public String getResultSetCursorName(int rsNum) throws SQLException {
        DRDAResultSet drdaRs = this.getDrdaResultSet(rsNum);
        return drdaRs.getResultSetCursorName();
    }

    protected String toDebugString(String indent) {
        Object s = "";
        if (this.ps == null) {
            s = (String)s + indent + String.valueOf(this.ps);
        } else {
            s = (String)s + indent + this.pkgnamcsn.getPkgid() + this.pkgnamcsn.getPkgsn();
            s = (String)s + "\t" + this.getSQLText();
        }
        return s;
    }

    protected ConsistencyToken calculateResultSetPkgcnstkn(int rsNum) {
        ConsistencyToken consistToken = this.pkgnamcsn.getPkgcnstkn();
        if (rsNum == 0 || consistToken == null) {
            return consistToken;
        }
        BigInteger consistTokenBi = new BigInteger(consistToken.getBytes());
        BigInteger rsNumBi = BigInteger.valueOf(rsNum);
        consistTokenBi = consistTokenBi.subtract(rsNumBi);
        consistToken = new ConsistencyToken(consistTokenBi.toByteArray());
        return consistToken;
    }

    protected boolean isCallableStatement() {
        return this.isCall;
    }

    private boolean isCallableSQL(String sql) {
        StringTokenizer tokenizer = new StringTokenizer(sql, "\t\n\r\f=? (");
        if (!tokenizer.hasMoreTokens()) {
            return false;
        }
        String firstToken = tokenizer.nextToken();
        return StringUtil.SQLEqualsIgnoreCase(firstToken, "call");
    }

    private void setupCallableStatementParams(CallableStatement cs) throws SQLException {
        ParameterMetaData pmeta = this.getParameterMetaData();
        int numElems = pmeta.getParameterCount();
        for (int i = 0; i < numElems; ++i) {
            boolean outputFlag = false;
            int parameterMode = pmeta.getParameterMode(i + 1);
            int parameterType = pmeta.getParameterType(i + 1);
            int parameterPrecision = pmeta.getPrecision(i + 1);
            int parameterScale = pmeta.getScale(i + 1);
            switch (parameterMode) {
                case 1: {
                    break;
                }
                case 2: 
                case 4: {
                    outputFlag = true;
                    break;
                }
                case 0: {
                    String objectType = pmeta.getParameterClassName(i + 1);
                    parameterType = DRDAStatement.getOutputParameterTypeFromClassName(objectType);
                    if (parameterType == NOT_OUTPUT_PARAM) break;
                    outputFlag = true;
                }
            }
            if (!outputFlag) continue;
            if (this.outputTypes == null) {
                this.outputTypes = new int[numElems];
                this.outputPrecision = new int[numElems];
                this.outputScale = new int[numElems];
                for (int j = 0; j < numElems; ++j) {
                    this.outputTypes[j] = NOT_OUTPUT_PARAM;
                    this.outputPrecision[j] = NOT_OUTPUT_PARAM;
                    this.outputScale[j] = NOT_OUTPUT_PARAM;
                }
            }
            this.outputTypes[i] = parameterType;
            this.outputPrecision[i] = parameterPrecision;
            this.outputScale[i] = parameterScale;
        }
    }

    protected static int getOutputParameterTypeFromClassName(String objectName) {
        if (objectName.endsWith("[]")) {
            if (objectName.equals("byte[]")) {
                return NOT_OUTPUT_PARAM;
            }
            if (objectName.equals("java.lang.Byte[]")) {
                return -6;
            }
            if (objectName.equals("byte[][]")) {
                return -3;
            }
            if (objectName.equals("java.lang.String[]")) {
                return 12;
            }
            if (objectName.equals("int[]") || objectName.equals("java.lang.Integer[]")) {
                return 4;
            }
            if (objectName.equals("long[]") || objectName.equals("java.lang.Long[]")) {
                return -5;
            }
            if (objectName.equals("java.math.BigDecimal[]")) {
                return 2;
            }
            if (objectName.equals("boolean[]") || objectName.equals("java.lang.Boolean[]")) {
                return -7;
            }
            if (objectName.equals("short[]")) {
                return 5;
            }
            if (objectName.equals("float[]") || objectName.equals("java.lang.Float[]")) {
                return 7;
            }
            if (objectName.equals("double[]") || objectName.equals("java.lang.Double[]")) {
                return 8;
            }
            if (objectName.equals("java.sql.Date[]")) {
                return 91;
            }
            if (objectName.equals("java.sql.Time[]")) {
                return 92;
            }
            if (objectName.equals("java.sql.Timestamp[]")) {
                return 93;
            }
        }
        return NOT_OUTPUT_PARAM;
    }

    public void registerAllOutParams() throws SQLException {
        if (this.isCall && this.outputTypes != null) {
            for (int i = 1; i <= this.outputTypes.length; ++i) {
                this.registerOutParam(i);
            }
        }
    }

    public void registerOutParam(int paramNum) throws SQLException {
        if (this.isOutputParam(paramNum)) {
            CallableStatement cs = (CallableStatement)((Object)this.ps);
            cs.registerOutParameter(paramNum, this.getOutputParamType(paramNum));
        }
    }

    protected boolean hasOutputParams() {
        return this.outputTypes != null;
    }

    boolean isOutputParam(int paramNum) {
        if (this.outputTypes != null) {
            return this.outputTypes[paramNum - 1] != NOT_OUTPUT_PARAM;
        }
        return false;
    }

    int getOutputParamType(int paramNum) {
        if (this.outputTypes != null) {
            return this.outputTypes[paramNum - 1];
        }
        return NOT_OUTPUT_PARAM;
    }

    int getOutputParamScale(int paramNum) {
        if (this.outputScale != null) {
            return this.outputScale[paramNum - 1];
        }
        return NOT_OUTPUT_PARAM;
    }

    int getOutputParamPrecision(int paramNum) {
        if (this.outputPrecision != null) {
            return this.outputPrecision[paramNum - 1];
        }
        return NOT_OUTPUT_PARAM;
    }

    private boolean isDynamicPkgid(String pkgid) {
        char size = pkgid.charAt(3);
        char holdability = pkgid.charAt(4);
        return !(!pkgid.substring(0, 3).equals("SYS") || size != 'S' && size != 'L' || holdability != 'H' && holdability != 'N');
    }

    private void parsePkgidToFindHoldability() {
        if (this.withHoldCursor != -1) {
            return;
        }
        String pkgid = this.pkgnamcsn.getPkgid();
        this.withHoldCursor = this.isDynamicPkgid(pkgid) ? (pkgid.charAt(4) == 'N' ? 2 : 1) : 1;
    }

    protected ParameterMetaData getParameterMetaData() throws SQLException {
        if (this.stmtPmeta != null) {
            return this.stmtPmeta;
        }
        this.stmtPmeta = this.ps.getParameterMetaData();
        return this.stmtPmeta;
    }

    private boolean getMoreResults(int current) throws SQLException {
        return this.getPreparedStatement().getMoreResults(current);
    }

    private String getSQLText() {
        String retVal = null;
        Class[] emptyPARAM = new Class[]{};
        Object[] args = null;
        try {
            Method sh = this.getPreparedStatement().getClass().getMethod("getSQLText", emptyPARAM);
            retVal = (String)sh.invoke((Object)this.getPreparedStatement(), args);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    boolean isRSCloseImplicit(boolean lmtblkprcOK) throws SQLException {
        return this.currentDrdaRs.qryclsimp == 1 && !this.isScrollable() && (lmtblkprcOK || this.currentDrdaRs.getQryprctyp() != 9239);
    }

    private static class DrdaParamState {
        private EXTDTAReaderInputStream streamedParameter = null;
        private int typeLstEnd_ = 0;
        private byte[] typeLst_ = new byte[10];
        private int[] lenLst_ = new int[10];
        private int extLstEnd_ = 0;
        private int[] extLst_ = new int[10];

        private DrdaParamState() {
        }

        private static Object growArray(Object array) {
            int oldLen = Array.getLength(array);
            Object tmp = Array.newInstance(array.getClass().getComponentType(), Math.max(oldLen, 1) * 2);
            System.arraycopy(array, 0, tmp, 0, oldLen);
            return tmp;
        }

        protected void clear(boolean trim) {
            this.streamedParameter = null;
            this.typeLstEnd_ = 0;
            this.extLstEnd_ = 0;
            if (trim && this.typeLst_.length > 10) {
                this.typeLst_ = new byte[10];
                this.lenLst_ = new int[10];
                this.extLst_ = new int[10];
            }
        }

        protected void addDrdaParam(byte t, int s) {
            if (this.typeLstEnd_ >= this.typeLst_.length) {
                this.typeLst_ = (byte[])DrdaParamState.growArray(this.typeLst_);
                this.lenLst_ = (int[])DrdaParamState.growArray(this.lenLst_);
            }
            this.typeLst_[this.typeLstEnd_] = t;
            this.lenLst_[this.typeLstEnd_] = s;
            ++this.typeLstEnd_;
        }

        protected int getDrdaParamCount() {
            return this.typeLstEnd_;
        }

        protected byte getDrdaType(int i) {
            return this.typeLst_[i];
        }

        protected int getDrdaLen(int i) {
            return this.lenLst_[i];
        }

        protected void addExtPos(int p) {
            if (this.extLstEnd_ >= this.extLst_.length) {
                this.extLst_ = (int[])DrdaParamState.growArray(this.extLst_);
            }
            this.extLst_[this.extLstEnd_] = p;
            ++this.extLstEnd_;
        }

        protected int getExtPosCount() {
            return this.extLstEnd_;
        }

        protected int getExtPos(int i) {
            return this.extLst_[i];
        }

        protected void drainStreamedParameter() throws IOException {
            if (this.streamedParameter != null) {
                int i;
                byte[] buffer = new byte[1000];
                while ((i = this.streamedParameter.read(buffer, 0, 1000)) != -1) {
                }
            }
        }

        public void setStreamedParameter(EXTDTAReaderInputStream eis) {
            this.streamedParameter = eis;
        }
    }
}

