/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ProcedureInTriggerTest
extends BaseJDBCTestCase {
    private static int zeroArgCount = 0;
    private static int getConnectionProcCount = 0;
    private static int selectRowsCount = 0;

    public ProcedureInTriggerTest(String string) {
        super(string);
    }

    public void testTriggerNoSql() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create trigger after_stmt_trig_no_sql AFTER insert on t2 for each STATEMENT call proc_no_sql()");
        zeroArgCount = 0;
        statement.execute("insert into t2 values (1,2), (2,4)");
        this.checkAndResetZeroArgCount(1);
        ResultSet resultSet = statement.executeQuery("SELECT * FROM T2");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "2"}, {"2", "4"}});
        ProcedureInTriggerTest.assertStatementError("X0Y25", statement, "drop procedure proc_no_sql");
        statement.execute("insert into t2 values (3,6)");
        this.checkAndResetZeroArgCount(1);
        resultSet = statement.executeQuery("SELECT * FROM T2");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "2"}, {"2", "4"}, {"3", "6"}});
        statement.execute("create trigger after_row_trig_no_sql AFTER delete on t2 for each ROW call proc_no_sql()");
        statement.execute("delete from t2");
        this.checkAndResetZeroArgCount(3);
        resultSet = statement.executeQuery("select * from t2");
        JDBC.assertEmpty(resultSet);
        statement.execute("drop trigger after_stmt_trig_no_sql");
        statement.execute("drop trigger after_row_trig_no_sql");
        statement.execute("create trigger before_stmt_trig_no_sql no cascade BEFORE insert on t2 for each STATEMENT call proc_no_sql()");
        statement.execute("insert into t2 values (1,2), (2,4)");
        this.checkAndResetZeroArgCount(1);
        resultSet = statement.executeQuery("select * from t2");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "2"}, {"2", "4"}});
        ProcedureInTriggerTest.assertStatementError("X0Y25", statement, "drop procedure proc_no_sql");
        statement.execute("insert into t2 values (3,6)");
        this.checkAndResetZeroArgCount(1);
        resultSet = statement.executeQuery("SELECT * FROM T2");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "2"}, {"2", "4"}, {"3", "6"}});
        statement.execute("create trigger before_row_trig_no_sql no cascade BEFORE delete on t2 for each ROW call proc_no_sql()");
        statement.execute("delete from t2");
        this.checkAndResetZeroArgCount(3);
        resultSet = statement.executeQuery("select * from t2");
        JDBC.assertEmpty(resultSet);
        statement.execute("drop trigger before_stmt_trig_no_sql");
        statement.execute("drop trigger before_row_trig_no_sql");
        statement.close();
    }

    public void testTriggerContainsSql() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("insert into t2 values (1,2), (2,4)");
        statement.execute("create trigger after_row_trig_contains_sql AFTER update on t2 for each ROW call proc_contains_sql()");
        statement.execute("update t2 set x = x*2");
        this.checkAndResetGetConnectionProcCount(2);
        ResultSet resultSet = statement.executeQuery("select * from t2");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"2", "2"}, {"4", "4"}});
        statement.execute("create trigger before_stmt_trig_contains_sql no cascade BEFORE delete on t2 for each STATEMENT call proc_contains_sql()");
        statement.execute("delete from t2");
        this.checkAndResetGetConnectionProcCount(1);
        resultSet = statement.executeQuery("select * from t2");
        JDBC.assertEmpty(resultSet);
        statement.execute("drop trigger after_row_trig_contains_sql");
        statement.execute("drop trigger before_stmt_trig_contains_sql");
        statement.close();
    }

    public void testTriggerReadsSql() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("insert into t1 values (1, 'one')");
        statement.execute("create trigger after_stmt_trig_reads_sql AFTER insert on t2 for each STATEMENT call proc_reads_sql(1)");
        selectRowsCount = 0;
        statement.execute("insert into t2 values (1,2), (2,4)");
        this.checkAndResetSelectRowsCount(1);
        ResultSet resultSet = statement.executeQuery("select * from t2");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "2"}, {"2", "4"}});
        statement.execute("drop trigger after_stmt_trig_reads_sql");
        statement.execute("create trigger before_row_trig_reads_sql no cascade BEFORE delete on t2 for each ROW call proc_reads_sql(1)");
        statement.execute("delete from t2");
        this.checkAndResetSelectRowsCount(2);
        resultSet = statement.executeQuery("select * from t2");
        JDBC.assertEmpty(resultSet);
        statement.execute("drop trigger before_row_trig_reads_sql");
        statement.execute("delete from t1");
        statement.close();
    }

    public void testModifiesSql() throws SQLException {
        String[][] stringArray;
        Statement statement = this.createStatement();
        statement.execute("create trigger after_stmt_trig_modifies_sql_insert_op AFTER insert on t2 for each STATEMENT call proc_modifies_sql_insert_op(1, 'one')");
        statement.execute("insert into t2 values (1,2), (2,4)");
        ResultSet resultSet = statement.executeQuery("select * from t1");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "one"}});
        resultSet = statement.executeQuery("select * from t2");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "2"}, {"2", "4"}});
        statement.execute("create trigger after_row_trig_modifies_sql_update_op AFTER update of x on t2 for each ROW call proc_modifies_sql_update_op(2)");
        statement.execute("update t2 set x=x*2");
        resultSet = statement.executeQuery("select * from t1");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"5", "one"}});
        resultSet = statement.executeQuery("select * from t2");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"2", "2"}, {"4", "4"}});
        statement.execute("create trigger after_stmt_trig_modifies_sql_delete_op AFTER delete on t2 for each STATEMENT call proc_modifies_sql_delete_op(5)");
        statement.execute("delete from t2");
        resultSet = statement.executeQuery("select * from t1");
        JDBC.assertEmpty(resultSet);
        resultSet = statement.executeQuery("select * from t2");
        JDBC.assertEmpty(resultSet);
        statement.execute("drop trigger after_stmt_trig_modifies_sql_insert_op");
        statement.execute("drop trigger after_row_trig_modifies_sql_update_op");
        statement.execute("drop trigger after_stmt_trig_modifies_sql_delete_op");
        statement.execute("create trigger refer_new_row_trig AFTER insert on t2 REFERENCING NEW as new for each ROW call proc_modifies_sql_insert_op(new.x, 'new')");
        statement.execute("insert into t2 values (25, 50)");
        resultSet = statement.executeQuery("select * from t1");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"25", "new"}});
        resultSet = statement.executeQuery("select * from t2");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"25", "50"}});
        statement.execute("create trigger refer_old_row_trig AFTER delete on t2 REFERENCING OLD as old for each ROW call proc_modifies_sql_delete_op(old.x)");
        statement.execute("delete from t2 where x=25");
        resultSet = statement.executeQuery("select * from t1");
        JDBC.assertEmpty(resultSet);
        resultSet = statement.executeQuery("select * from t2");
        JDBC.assertEmpty(resultSet);
        statement.execute("drop trigger refer_new_row_trig");
        statement.execute("drop trigger refer_old_row_trig");
        ProcedureInTriggerTest.assertStatementError("42Z9D", statement, "create trigger before_trig_modifies_sql no cascade BEFORE insert on t2 for each STATEMENT call proc_modifies_sql_insert_op(1, 'one')");
        statement.execute("create trigger bad_before_trig no cascade BEFORE insert on t2 for each STATEMENT call proc_wrongly_defined_as_no_sql(50, 'fifty')");
        try {
            statement.execute("insert into t2 values (1,2), (2,4)");
        }
        catch (SQLException sQLException) {
            ProcedureInTriggerTest.assertSQLState("38000", sQLException);
            stringArray = sQLException.getNextException();
            ProcedureInTriggerTest.assertSQLState("38001", (SQLException)stringArray);
        }
        resultSet = statement.executeQuery("select * from t1");
        JDBC.assertEmpty(resultSet);
        resultSet = statement.executeQuery("select * from t2");
        JDBC.assertEmpty(resultSet);
        statement.execute("drop trigger bad_before_trig");
        statement.execute("create trigger insert_trig AFTER update on t1 for each STATEMENT call proc_modifies_sql_insert_op(1, 'one')");
        statement.execute("insert into t1 values(2, 'two')");
        statement.execute("update t1 set i=i+1");
        resultSet = statement.executeQuery("select * from t1");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"3", "two"}, {"1", "one"}});
        statement.execute("drop trigger insert_trig");
        statement.execute("create trigger update_trig AFTER insert on t1 for each STATEMENT call proc_modifies_sql_update_op(2)");
        statement.execute("insert into t1 values (4,'four')");
        resultSet = statement.executeQuery("select * from t1");
        stringArray = new String[][]{{"5", "two            "}, {"3", "one            "}, {"6", "four           "}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.execute("drop trigger update_trig");
        statement.execute("create trigger delete_trig AFTER insert on t1 for each STATEMENT call proc_modifies_sql_delete_op(3)");
        statement.execute("insert into t1 values (8,'eight')");
        resultSet = statement.executeQuery("select * from t1");
        stringArray = new String[][]{{"5", "two            "}, {"6", "four           "}, {"8", "eight          "}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.execute("drop trigger delete_trig");
        statement.execute("create trigger call_proc_in_default_schema AFTER insert on t2 for each STATEMENT call APP.proc_no_sql()");
        statement.execute("insert into t2 values (1,2), (2,4)");
        resultSet = statement.executeQuery("select * from t2");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "2"}, {"2", "4"}});
        statement.execute("drop trigger call_proc_in_default_schema");
        statement.execute("create trigger call_proc_in_default_schema no cascade BEFORE delete on t2 for each ROW call APP.proc_no_sql()");
        statement.execute("delete from t2");
        resultSet = statement.executeQuery("select * from t2");
        JDBC.assertEmpty(resultSet);
        statement.execute("drop trigger call_proc_in_default_schema");
        statement.execute("create trigger call_proc_in_new_schema no cascade BEFORE insert on t2 for each STATEMENT call new_schema.proc_in_new_schema()");
        statement.execute("insert into t2 values (1,2), (2,4)");
        resultSet = statement.executeQuery("select * from t2");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "2"}, {"2", "4"}});
        statement.execute("drop trigger call_proc_in_new_schema");
        statement.execute("create trigger call_proc_in_new_schema AFTER delete on t2 for each ROW call new_schema.proc_in_new_schema()");
        statement.execute("delete from t2");
        resultSet = statement.executeQuery("select * from t2");
        JDBC.assertEmpty(resultSet);
        statement.execute("drop trigger call_proc_in_new_schema");
        statement.close();
    }

    public void testTriggerNegative() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("insert into t1 values (5,'two'), (6,'four'), (8,'eight')");
        ProcedureInTriggerTest.assertStatementError("42Y03", statement, "create trigger call_non_existent_proc1 AFTER insert on t2 for each ROW call non_existent_proc()");
        ResultSet resultSet = statement.executeQuery("select count(*) from SYS.SYSTRIGGERS where CAST(triggername AS VARCHAR(128))='CALL_NON_EXISTENT_PROC1'");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"0"}});
        ProcedureInTriggerTest.assertStatementError("42Y03", statement, "create trigger call_proc_with_non_existent_proc2 AFTER insert on t2 for each ROW call new_schema.non_existent_proc()");
        resultSet = statement.executeQuery("select count(*) from SYS.SYSTRIGGERS where CAST(triggername AS VARCHAR(128))='CALL_NON_EXISTENT_PROC2'");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"0"}});
        ProcedureInTriggerTest.assertStatementError("42Y07", statement, "create trigger call_proc_in_non_existent_schema AFTER insert on t2 for each ROW call non_existent_schema.non_existent_proc()");
        resultSet = statement.executeQuery("select count(*) from SYS.SYSTRIGGERS where CAST(triggername AS VARCHAR(128))='CALL_PROC_IN_NON_EXISTENT_SCHEMA'");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"0"}});
        ProcedureInTriggerTest.assertStatementError("42X50", statement, "create trigger call_proc_using_non_existent_method AFTER insert on t2 for each ROW call proc_using_non_existent_method()");
        resultSet = statement.executeQuery("select count(*) from SYS.SYSTRIGGERS where CAST(triggername as VARCHAR(128))='CALL_PROC_WITH_NON_EXISTENT_METHOD'");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"0"}});
        ProcedureInTriggerTest.assertStatementError("42Y03", statement, "create trigger call_non_existent_proc1 no cascade BEFORE insert on t2 for each ROW call non_existent_proc()");
        resultSet = statement.executeQuery("select count(*) from SYS.SYSTRIGGERS where CAST(triggername AS VARCHAR(128))='CALL_NON_EXISTENT_PROC1'");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"0"}});
        ProcedureInTriggerTest.assertStatementError("42Y07", statement, "create trigger call_proc_in_non_existent_schema no cascade BEFORE insert on t2 for each ROW call non_existent_schema.non_existent_proc()");
        resultSet = statement.executeQuery("select count(*) from SYS.SYSTRIGGERS where CAST(triggername AS VARCHAR(128))='CALL_PROC_IN_NON_EXISTENT_SCHEMA'");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"0"}});
        ProcedureInTriggerTest.assertStatementError("42X50", statement, "create trigger call_proc_using_non_existent_method no cascade BEFORE insert on t2 for each ROW call proc_using_non_existent_method()");
        resultSet = statement.executeQuery("select count(*) from SYS.SYSTRIGGERS where CAST(triggername AS VARCHAR(128))='CALL_PROC_WITH_NON_EXISTENT_METHOD'");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"0"}});
        ProcedureInTriggerTest.assertStatementError("42Y27", statement, "create trigger update_trig AFTER insert on t1 for each STATEMENT call proc_modifies_sql_update_op(?)");
        statement.execute("insert into t2 values (1,2), (2,4)");
        statement.execute("create trigger commit_trig AFTER delete on t2 for each STATEMENT call commit_proc()");
        ProcedureInTriggerTest.assertStatementError("38000", statement, "delete from t2");
        resultSet = statement.executeQuery("select * from t2");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "2"}, {"2", "4"}});
        statement.execute("drop trigger commit_trig");
        statement.execute("create trigger commit_trig no cascade BEFORE delete on t2 for each STATEMENT call commit_proc()");
        ProcedureInTriggerTest.assertStatementError("38000", statement, "delete from t2");
        resultSet = statement.executeQuery("select * from t2");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "2"}, {"2", "4"}});
        statement.execute("drop trigger commit_trig");
        statement.execute("create trigger rollback_trig AFTER delete on t2 for each STATEMENT call rollback_proc()");
        ProcedureInTriggerTest.assertStatementError("38000", statement, "delete from t2");
        resultSet = statement.executeQuery("select * from t2");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "2"}, {"2", "4"}});
        statement.execute("drop trigger rollback_trig");
        statement.execute("create trigger rollback_trig no cascade BEFORE delete on t2 for each STATEMENT call rollback_proc()");
        ProcedureInTriggerTest.assertStatementError("38000", statement, "delete from t2");
        resultSet = statement.executeQuery("select * from t2");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "2"}, {"2", "4"}});
        statement.execute("drop trigger rollback_trig");
        statement.execute("create trigger set_isolation_trig AFTER delete on t2 for each STATEMENT call set_isolation_proc()");
        ProcedureInTriggerTest.assertStatementError("38000", statement, "delete from t2");
        resultSet = statement.executeQuery("select * from t2");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "2"}, {"2", "4"}});
        statement.execute("drop trigger set_isolation_trig");
        statement.execute("create trigger set_isolation_trig no cascade BEFORE delete on t2 for each STATEMENT call set_isolation_proc()");
        ProcedureInTriggerTest.assertStatementError("38000", statement, "delete from t2");
        resultSet = statement.executeQuery("select * from t2");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "2"}, {"2", "4"}});
        statement.execute("drop trigger set_isolation_trig");
        statement.execute("create trigger select_from_trig_table AFTER insert on t1 for each STATEMENT call proc_reads_sql(1)");
        statement.execute("insert into t1 values (10, 'ten')");
        resultSet = statement.executeQuery("select * from t1");
        String[][] stringArray = new String[][]{{"5", "two"}, {"6", "four"}, {"8", "eight"}, {"10", "ten"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.execute("drop trigger select_from_trig_table");
        statement.execute("create trigger select_from_trig_table no cascade before delete on t1 for each STATEMENT call proc_reads_sql(1)");
        statement.execute("delete from t1 where i=10");
        resultSet = statement.executeQuery("select * from t1");
        stringArray = new String[][]{{"5", "two"}, {"6", "four"}, {"8", "eight"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.execute("drop trigger select_from_trig_table");
        statement.execute("create trigger alter_table_trig AFTER delete on t1 for each STATEMENT call alter_table_proc()");
        ProcedureInTriggerTest.assertStatementError("38000", statement, "delete from t1");
        resultSet = statement.executeQuery("select * from t1");
        stringArray = new String[][]{{"5", "two"}, {"6", "four"}, {"8", "eight"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.execute("create trigger drop_table_trig AFTER delete on t2 for each STATEMENT call drop_table_proc()");
        ProcedureInTriggerTest.assertStatementError("38000", statement, "delete from t2");
        resultSet = statement.executeQuery("select * from t2");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "2"}, {"2", "4"}});
        statement.execute("drop trigger drop_table_trig");
        statement.execute("create trigger create_trigger_trig AFTER delete on t1 for each STATEMENT call create_trigger_proc()");
        ProcedureInTriggerTest.assertStatementError("38000", statement, "delete from t1");
        resultSet = statement.executeQuery("select * from t1");
        stringArray = new String[][]{{"5", "two"}, {"6", "four"}, {"8", "eight"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select count(*) from SYS.SYSTRIGGERS where  CAST(triggername AS VARCHAR(128))='TEST_TRIG'");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"0"}});
        statement.execute("drop trigger create_trigger_trig");
        statement.execute("create trigger test_trig AFTER delete on t1 for each STATEMENT insert into  t1 values(20, 'twenty')");
        statement.execute("create trigger drop_trigger_trig AFTER delete on t2 for each STATEMENT call drop_trigger_proc()");
        ProcedureInTriggerTest.assertStatementError("38000", statement, "delete from t2");
        resultSet = statement.executeQuery("select * from t2");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "2"}, {"2", "4"}});
        resultSet = statement.executeQuery("select count(*) from SYS.SYSTRIGGERS where CAST(triggername AS VARCHAR(128))='TEST_TRIG'");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1"}});
        statement.execute("drop trigger drop_trigger_trig");
        statement.execute("create trigger create_index_trig AFTER delete on t2 for each STATEMENT call create_index_proc()");
        ProcedureInTriggerTest.assertStatementError("38000", statement, "delete from t2");
        resultSet = statement.executeQuery("select * from t2");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "2"}, {"2", "4"}});
        resultSet = statement.executeQuery("select count(*) from SYS.SYSCONGLOMERATES where CAST(CONGLOMERATENAME AS VARCHAR(128))='IX' and ISINDEX");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"0"}});
        statement.execute("drop trigger create_index_trig");
        statement.execute("create index ix on t1(i,b)");
        statement.execute("create trigger drop_index_trig AFTER delete on t1 for each STATEMENT call drop_index_proc()");
        ProcedureInTriggerTest.assertStatementError("38000", statement, "delete from t1");
        resultSet = statement.executeQuery("select * from t1");
        stringArray = new String[][]{{"5", "two"}, {"6", "four"}, {"8", "eight"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select count(*) from SYS.SYSCONGLOMERATES where CAST(CONGLOMERATENAME AS VARCHAR(128))='IX' and ISINDEX");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1"}});
        statement.execute("drop trigger alter_table_trig");
        statement.execute("drop trigger test_trig");
        statement.execute("drop trigger drop_index_trig");
        statement.execute("drop index ix");
        statement.close();
    }

    private static Test basesuite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite(ProcedureInTriggerTest.class);
        CleanDatabaseTestSetup cleanDatabaseTestSetup = new CleanDatabaseTestSetup((Test)baseTestSuite){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.execute("create table t1 (i int primary key, b char(15))");
                statement.execute("create table t2 (x integer, y integer)");
                statement.execute("create procedure proc_no_sql() parameter style java language java NO SQL external name 'org.apache.derbyTesting.functionTests.tests.lang.ProcedureInTriggerTest.zeroArg'");
                statement.execute("create procedure proc_contains_sql() parameter style java language java CONTAINS SQL external name 'org.apache.derbyTesting.functionTests.tests.lang.ProcedureInTriggerTest.getConnectionProc'");
                statement.execute("create procedure proc_reads_sql(i integer) parameter style java language java READS SQL DATA external name 'org.apache.derbyTesting.functionTests.tests.lang.ProcedureInTriggerTest.selectRows' dynamic result sets 1");
                statement.execute("create procedure proc_modifies_sql_insert_op(p1 int, p2 char(10)) parameter style java language java MODIFIES SQL DATA external name 'org.apache.derbyTesting.functionTests.tests.lang.ProcedureInTriggerTest.insertRow'");
                statement.execute("create procedure proc_modifies_sql_update_op(p1 int) parameter style java language java  MODIFIES SQL DATA  external name 'org.apache.derbyTesting.functionTests.tests.lang.ProcedureInTriggerTest.updateRow'");
                statement.execute("create procedure proc_modifies_sql_delete_op(p1 int) parameter style java language java MODIFIES SQL DATA external name 'org.apache.derbyTesting.functionTests.tests.lang.ProcedureInTriggerTest.deleteRow'");
                statement.execute("create procedure alter_table_proc() parameter style java language java external name 'org.apache.derbyTesting.functionTests.tests.lang.ProcedureInTriggerTest.alterTable'");
                statement.execute("create procedure drop_table_proc() parameter style java language java external name 'org.apache.derbyTesting.functionTests.tests.lang.ProcedureInTriggerTest.dropTable'");
                statement.execute("create procedure commit_proc() parameter style java dynamic result sets 0 language java contains sql external name 'org.apache.derbyTesting.functionTests.tests.lang.ProcedureInTriggerTest.doConnCommit'");
                statement.execute("create procedure rollback_proc() parameter style java dynamic result sets 0 language java contains sql external name 'org.apache.derbyTesting.functionTests.tests.lang.ProcedureInTriggerTest.doConnRollback'");
                statement.execute("create procedure set_isolation_proc() parameter style java dynamic result sets 0 language java contains sql external name 'org.apache.derbyTesting.functionTests.tests.lang.ProcedureInTriggerTest.doConnectionSetIsolation'");
                statement.execute("create procedure create_index_proc() parameter style java dynamic result sets 0 language java  contains sql external name 'org.apache.derbyTesting.functionTests.tests.lang.ProcedureInTriggerTest.createIndex'");
                statement.execute("create procedure drop_index_proc() parameter style java dynamic result sets 0 language java contains sql external name 'org.apache.derbyTesting.functionTests.tests.lang.ProcedureInTriggerTest.dropIndex'");
                statement.execute("create procedure create_trigger_proc() parameter style java dynamic result sets 0 language java contains sql external name 'org.apache.derbyTesting.functionTests.tests.lang.ProcedureInTriggerTest.createTrigger'");
                statement.execute(" create procedure drop_trigger_proc() parameter style java dynamic result sets 0 language java contains sql external name 'org.apache.derbyTesting.functionTests.tests.lang.ProcedureInTriggerTest.dropTrigger'");
                statement.execute("create procedure proc_wrongly_defined_as_no_sql(p1 int, p2 char(10)) parameter style java language java NO SQL external name 'org.apache.derbyTesting.functionTests.tests.lang.ProcedureInTriggerTest.insertRow'");
                statement.execute("create schema new_schema");
                statement.execute("create procedure new_schema.proc_in_new_schema() parameter style java language java NO SQL external name 'org.apache.derbyTesting.functionTests.tests.lang.ProcedureInTriggerTest.zeroArg'");
                statement.execute("create procedure proc_using_non_existent_method() parameter style java language java NO SQL external name 'org.apache.derbyTesting.functionTests.tests.lang.ProcedureInTriggerTest.nonexistentMethod'");
            }
        };
        return cleanDatabaseTestSetup;
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite();
        if (!JDBC.vmSupportsJSR169()) {
            baseTestSuite.addTest(ProcedureInTriggerTest.basesuite());
            baseTestSuite.addTest(TestConfiguration.clientServerDecorator(ProcedureInTriggerTest.basesuite()));
        }
        return baseTestSuite;
    }

    @Override
    protected void tearDown() throws Exception {
        this.rollback();
        Statement statement = this.createStatement();
        statement.execute("truncate table t1");
        statement.execute("truncate table t2");
        this.commit();
        zeroArgCount = 0;
        getConnectionProcCount = 0;
        selectRowsCount = 0;
        super.tearDown();
    }

    private void checkAndResetZeroArgCount(int n) {
        ProcedureInTriggerTest.assertEquals((int)n, (int)zeroArgCount);
        zeroArgCount = 0;
    }

    public static void zeroArg() {
        ++zeroArgCount;
    }

    private void checkAndResetGetConnectionProcCount(int n) {
        ProcedureInTriggerTest.assertEquals((int)n, (int)getConnectionProcCount);
        getConnectionProcCount = 0;
    }

    public static void getConnectionProc() throws Throwable {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = connection.createStatement();
        connection.close();
        ++getConnectionProcCount;
    }

    private void checkAndResetSelectRowsCount(int n) {
        ProcedureInTriggerTest.assertEquals((int)n, (int)selectRowsCount);
        selectRowsCount = 0;
    }

    public static void selectRows(int n, ResultSet[] resultSetArray) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("select * from t1 where i = ?");
        preparedStatement.setInt(1, n);
        resultSetArray[0] = preparedStatement.executeQuery();
        connection.close();
        ++selectRowsCount;
    }

    public static void selectRows(int n, int n2, ResultSet[] resultSetArray, ResultSet[] resultSetArray2) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("select * from t1 where i = ?");
        preparedStatement.setInt(1, n);
        resultSetArray[0] = preparedStatement.executeQuery();
        preparedStatement = connection.prepareStatement("select * from t1 where i >= ?");
        preparedStatement.setInt(1, n2);
        resultSetArray2[0] = preparedStatement.executeQuery();
        if (n2 == 99) {
            resultSetArray2[0].close();
        }
        if (n2 == 199) {
            resultSetArray[0].close();
            resultSetArray[0] = null;
            resultSetArray2[0].close();
            resultSetArray2[0] = null;
        }
        if (n2 == 299) {
            ResultSet resultSet = resultSetArray[0];
            resultSetArray[0] = resultSetArray2[0];
            resultSetArray2[0] = resultSet;
        }
        connection.close();
        ++selectRowsCount;
    }

    public static void selectRows(String string, ResultSet[] resultSetArray) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = connection.createStatement();
        resultSetArray[0] = statement.executeQuery("SELECT * FROM " + string);
        connection.close();
        ++selectRowsCount;
    }

    public static void insertRow(int n) throws SQLException {
        ProcedureInTriggerTest.insertRow(n, "int");
    }

    public static void insertRow(int n, String string) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into t1 values (?, ?)");
        preparedStatement.setInt(1, n);
        preparedStatement.setString(2, string);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        connection.close();
    }

    public static void updateRow(int n) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("update t1 set i=i+?");
        preparedStatement.setInt(1, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        connection.close();
    }

    public static void deleteRow(int n) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("delete from t1 where i=?");
        preparedStatement.setInt(1, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        connection.close();
    }

    public static void alterTable() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("alter table t1 add column test integer");
        preparedStatement.execute();
        preparedStatement.close();
        connection.close();
    }

    public static void dropTable() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("drop table t1");
        preparedStatement.execute();
        preparedStatement.close();
        connection.close();
    }

    public static int doConnCommitInt() throws Throwable {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        connection.commit();
        return 1;
    }

    public static void doConnCommit() throws Throwable {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        connection.commit();
    }

    public static void doConnRollback() throws Throwable {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        connection.rollback();
    }

    public static void doConnectionSetIsolation() throws Throwable {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        connection.setTransactionIsolation(8);
    }

    public static void createIndex() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("create index ix on t1(i,b)");
        preparedStatement.execute();
        preparedStatement.close();
        connection.close();
    }

    public static void dropIndex() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("drop index ix");
        preparedStatement.execute();
        preparedStatement.close();
        connection.close();
    }

    public static void createTrigger() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("create trigger test_trig AFTER delete on t1 for each STATEMENT insert into t1 values(20, 'twenty')");
        preparedStatement.execute();
        preparedStatement.close();
        connection.close();
    }

    public static void dropTrigger() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("drop trigger test_trig");
        preparedStatement.execute();
        preparedStatement.close();
        connection.close();
    }
}

