/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.perf.clients;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Random;
import org.apache.derbyTesting.perf.clients.BankAccountFiller;
import org.apache.derbyTesting.perf.clients.Client;

public class BankTransactionClient
implements Client {
    private final Random random = new Random();
    private final int branches;
    private final int tellersPerBranch;
    private final int accountsPerBranch;
    private Connection conn;
    private PreparedStatement updateAccount;
    private PreparedStatement updateHistory;
    private PreparedStatement updateTeller;
    private PreparedStatement updateBranch;
    private PreparedStatement retrieveAccountBalance;

    public BankTransactionClient(int branches, int tellersPerBranch, int accountsPerBranch) {
        if (branches <= 0 || tellersPerBranch <= 0 || accountsPerBranch <= 0) {
            throw new IllegalArgumentException("all arguments must be greater than 0");
        }
        this.branches = branches;
        this.tellersPerBranch = tellersPerBranch;
        this.accountsPerBranch = accountsPerBranch;
    }

    public BankTransactionClient(int scale) {
        this(scale, 10, 100000);
    }

    @Override
    public void init(Connection c) throws SQLException {
        this.conn = c;
        c.setAutoCommit(false);
        this.updateAccount = c.prepareStatement("UPDATE ACCOUNTS SET ACCOUNT_BALANCE = ACCOUNT_BALANCE + ? WHERE ACCOUNT_ID = ?");
        this.updateHistory = c.prepareStatement("INSERT INTO HISTORY(ACCOUNT_ID, TELLER_ID, BRANCH_ID, AMOUNT, TIME_STAMP, EXTRA_DATA) VALUES (?, ?, ?, ?, CURRENT_TIMESTAMP, '" + BankAccountFiller.createJunk(18) + "')");
        this.updateTeller = c.prepareStatement("UPDATE TELLERS SET TELLER_BALANCE = TELLER_BALANCE + ? WHERE TELLER_ID = ?");
        this.updateBranch = c.prepareStatement("UPDATE BRANCHES SET BRANCH_BALANCE = BRANCH_BALANCE + ? WHERE BRANCH_ID = ?");
        this.retrieveAccountBalance = c.prepareStatement("SELECT ACCOUNT_BALANCE FROM ACCOUNTS WHERE ACCOUNT_ID = ?");
    }

    @Override
    public void doWork() throws SQLException {
        int tellerId = this.fetchTellerId();
        int branchId = this.fetchBranchId(tellerId);
        int accountId = this.fetchAccountId(branchId);
        int delta = this.fetchDelta();
        this.updateAccount.setInt(1, delta);
        this.updateAccount.setInt(2, accountId);
        this.updateAccount.executeUpdate();
        this.updateHistory.setInt(1, accountId);
        this.updateHistory.setInt(2, tellerId);
        this.updateHistory.setInt(3, branchId);
        this.updateHistory.setInt(4, delta);
        this.updateHistory.executeUpdate();
        this.updateTeller.setInt(1, delta);
        this.updateTeller.setInt(2, tellerId);
        this.updateTeller.executeUpdate();
        this.updateBranch.setInt(1, delta);
        this.updateBranch.setInt(2, branchId);
        this.updateBranch.executeUpdate();
        this.retrieveAccountBalance.setInt(1, accountId);
        ResultSet rs = this.retrieveAccountBalance.executeQuery();
        rs.next();
        rs.getString(1);
        rs.close();
        this.conn.commit();
    }

    @Override
    public void printReport(PrintStream out) {
    }

    private int fetchTellerId() {
        return this.random.nextInt(this.tellersPerBranch * this.branches);
    }

    private int fetchBranchId(int tellerId) {
        return tellerId / this.tellersPerBranch;
    }

    private int fetchAccountId(int branchId) {
        int branch;
        if (this.branches == 1 || this.random.nextFloat() < 0.85f) {
            branch = branchId;
        } else {
            branch = this.random.nextInt(this.branches - 1);
            if (branch >= branchId) {
                ++branch;
            }
        }
        return branch * this.accountsPerBranch + this.random.nextInt(this.accountsPerBranch);
    }

    private int fetchDelta() {
        return this.random.nextInt(199999) - 99999;
    }
}

