/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.IOException;
import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.extensions.TestSetup;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.optional.api.LuceneIndexDescriptor;
import org.apache.derby.optional.api.LuceneUtils;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.LocaleTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.util.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class LuceneSupportTest
extends BaseJDBCTestCase {
    private static final String ILLEGAL_CHARACTER = "42XBD";

    public LuceneSupportTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("LuceneSupportTest");
        Test test = TestConfiguration.embeddedSuite(LuceneSupportTest.class);
        TestSetup testSetup = TestConfiguration.singleUseDatabaseDecorator(test);
        LocaleTestSetup localeTestSetup = new LocaleTestSetup((Test)testSetup, new Locale("en", "US"));
        baseTestSuite.addTest((Test)localeTestSetup);
        return baseTestSuite;
    }

    public void testCreateAndQueryIndex() throws Exception {
        Statement statement = this.createStatement();
        this.getConnection().prepareStatement("create function getDatabaseLocale() returns varchar( 20 )\nlanguage java parameter style java reads sql data\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.LuceneSupportTest.getDatabaseLocale()'\n").executeUpdate();
        JDBC.assertFullResultSet(statement.executeQuery("values ( substr( getDatabaseLocale(), 1, 2 ) )"), new String[][]{{"en"}});
        this.getConnection().prepareStatement("drop function getDatabaseLocale").executeUpdate();
        CallableStatement callableStatement = this.prepareCall("call LuceneSupport.createIndex('lucenetest','titles','title', null )");
        LuceneSupportTest.assertUpdateCount(callableStatement, 0);
        String[][] stringArray = new String[][]{{"1", "0", "0.8048013"}, {"3", "2", "0.643841"}};
        JDBC.assertFullResultSet(statement.executeQuery("select * from table ( lucenetest.titles__title( 'grapes', 1000, null ) ) luceneResults"), stringArray);
        stringArray = new String[][]{{"3", "2", "0.643841"}};
        JDBC.assertFullResultSet(statement.executeQuery("select * from table ( lucenetest.titles__title( 'grapes', 1000, .75 ) ) luceneResults"), stringArray);
        JDBC.assertEmpty(statement.executeQuery("select * from table ( lucenetest.titles__title( 'grapes',  1000, 0.5) ) luceneResults"));
        stringArray = new String[][]{{"The Grapes Of Wrath", "John Steinbeck", "The Viking Press", "0"}, {"Vines, Grapes, and Wines", "Jancis Robinson", "Alfred A. Knopf", "2"}};
        JDBC.assertFullResultSet(statement.executeQuery("select title, author, publisher, documentID\nfrom lucenetest.titles t, table ( lucenetest.titles__title( 'grapes', 1000, null ) ) l\nwhere t.id = l.id\n"), stringArray);
        callableStatement = this.prepareCall("call LuceneSupport.dropIndex('lucenetest','titles','title')");
        LuceneSupportTest.assertUpdateCount(callableStatement, 0);
    }

    public void testUpdateIndex() throws Exception {
        Statement statement = this.createStatement();
        CallableStatement callableStatement = this.prepareCall("call LuceneSupport.createIndex('lucenetest','titles','title', null)");
        LuceneSupportTest.assertUpdateCount(callableStatement, 0);
        JDBC.assertEmpty(statement.executeQuery("select *\nfrom table ( lucenetest.titles__title( 'mice', 1000, null ) ) luceneResults\n"));
        callableStatement = this.prepareCall("update TITLES SET TITLE='Of Mice and Men' WHERE ID=1");
        LuceneSupportTest.assertUpdateCount(callableStatement, 1);
        JDBC.assertEmpty(statement.executeQuery("select *\nfrom table ( lucenetest.titles__title( 'mice', 1000, null ) ) luceneResults\n"));
        callableStatement = this.prepareCall("call LuceneSupport.updateIndex('lucenetest','titles','title', null)");
        LuceneSupportTest.assertUpdateCount(callableStatement, 0);
        String[][] stringArray = new String[][]{{"1", "0", "1.058217"}};
        JDBC.assertFullResultSet(statement.executeQuery("select *\nfrom table ( lucenetest.titles__title( 'mice', 1000, null ) ) luceneResults\n"), stringArray);
        callableStatement = this.prepareCall("call LuceneSupport.dropIndex('lucenetest','titles','title')");
        LuceneSupportTest.assertUpdateCount(callableStatement, 0);
    }

    public void testListIndex() throws Exception {
        Statement statement = this.createStatement();
        CallableStatement callableStatement = this.prepareCall("call LuceneSupport.createIndex('lucenetest','titles','title', null)");
        LuceneSupportTest.assertUpdateCount(callableStatement, 0);
        callableStatement = this.prepareCall("call LuceneSupport.createIndex('lucenetest','titles','author', null)");
        LuceneSupportTest.assertUpdateCount(callableStatement, 0);
        String[][] stringArray = new String[][]{{"LUCENETEST", "TITLES", "AUTHOR"}, {"LUCENETEST", "TITLES", "TITLE"}};
        JDBC.assertFullResultSet(statement.executeQuery("select schemaname, tablename, columnname from table ( LuceneSupport.listIndexes() ) listindexes order by schemaname, tablename, columnname"), stringArray);
        callableStatement = this.prepareCall("call LuceneSupport.dropIndex('lucenetest','titles','title')");
        LuceneSupportTest.assertUpdateCount(callableStatement, 0);
        stringArray = new String[][]{{"LUCENETEST", "TITLES", "AUTHOR"}};
        JDBC.assertFullResultSet(statement.executeQuery("select schemaname, tablename, columnname from table ( LuceneSupport.listIndexes() ) listindexes order by schemaname, tablename, columnname"), stringArray);
        callableStatement = this.prepareCall("call LuceneSupport.dropIndex('lucenetest','titles','author')");
        LuceneSupportTest.assertUpdateCount(callableStatement, 0);
        JDBC.assertEmpty(statement.executeQuery("select schemaname, tablename, columnname from table ( LuceneSupport.listIndexes() ) listindexes"));
    }

    public void testDropIndexBadCharacters() throws Exception {
        this.assertCallError(ILLEGAL_CHARACTER, "call LuceneSupport.dropIndex('../','','')");
        this.assertCallError(ILLEGAL_CHARACTER, "call LuceneSupport.dropIndex('','../','')");
        this.assertCallError(ILLEGAL_CHARACTER, "call LuceneSupport.dropIndex('','','../')");
    }

    public void testMultipleFields() throws SQLException {
        LuceneSupportTest.println("Running multi-field test.");
        Statement statement = this.createStatement();
        statement.execute("create table multifield(id int primary key, c clob)");
        statement.execute("insert into multifield values (1, '<document><secret/>No one must know!</document>'), (2, '<document>No secret here!</document>')");
        statement.execute("call lucenesupport.createindex('lucenetest', 'multifield', 'c', '" + ((Object)((Object)this)).getClass().getName() + ".makeMultiFieldIndexDescriptor')");
        PreparedStatement preparedStatement = this.prepareStatement("select id from table(multifield__c(?, 100, null)) t");
        String[][] stringArray = new String[][]{{"1"}, {"2"}};
        preparedStatement.setString(1, "text:secret");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "2");
        preparedStatement.setString(1, "tags:secret");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "1");
        preparedStatement.setString(1, "secret");
        JDBC.assertUnorderedResultSet(preparedStatement.executeQuery(), stringArray);
    }

    public static LuceneIndexDescriptor makeMultiFieldIndexDescriptor() {
        return new MultiFieldIndexDescriptor();
    }

    public static QueryParser createXMLQueryParser(Version version, String[] stringArray, Analyzer analyzer) {
        return new MultiFieldQueryParser(version, stringArray, (Analyzer)new StandardAnalyzer(version));
    }

    private static Document parseXMLDocument(Reader reader) {
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(reader));
            reader.close();
        }
        catch (Exception exception) {
            LuceneSupportTest.fail("Failed to parse XML document", exception);
        }
        return document;
    }

    private static List<String> getAllXMLTags(Node node) {
        ArrayList<String> arrayList = new ArrayList<String>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            arrayList.add(node2.getNodeName());
            arrayList.addAll(LuceneSupportTest.getAllXMLTags(node2));
        }
        return arrayList;
    }

    private static void getAllText(Node node, StringBuilder stringBuilder) {
        if (node.getNodeType() == 3) {
            stringBuilder.append(node.getNodeValue());
        } else {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                LuceneSupportTest.getAllText(nodeList.item(i), stringBuilder);
            }
        }
    }

    protected void setUp() throws SQLException {
        Statement statement = this.createStatement();
        try {
            statement.executeUpdate("create schema lucenetest");
        }
        catch (Exception exception) {
            // empty catch block
        }
        statement.executeUpdate("set schema lucenetest");
        statement.executeUpdate("create table titles (ID int generated always as identity primary key, ISBN varchar(16), PRINTISBN varchar(16), title varchar(1024), subtitle varchar(1024), author varchar(1024), series varchar(1024), publisher varchar(1024), collections varchar(128), collections2 varchar(128))");
        statement.executeUpdate("insert into titles (ISBN, PRINTISBN, TITLE, SUBTITLE, AUTHOR, SERIES, PUBLISHER, COLLECTIONS, COLLECTIONS2) values ('9765087650324','9765087650324','The Grapes Of Wrath','The Great Depression in Oklahoma','John Steinbeck','Noble Winners','The Viking Press','National Book Award','Pulitzer Prize')");
        statement.executeUpdate("insert into titles (ISBN, PRINTISBN, TITLE, SUBTITLE, AUTHOR, SERIES, PUBLISHER, COLLECTIONS, COLLECTIONS2) values ('6754278542987','6754278542987','Identical: Portraits of Twins','Best Photo Book 2012 by American Photo Magazine','Martin Schoeller','Portraits','teNeues','Photography','')");
        statement.executeUpdate("insert into titles (ISBN, PRINTISBN, TITLE, SUBTITLE, AUTHOR, SERIES, PUBLISHER, COLLECTIONS, COLLECTIONS2) values ('2747583475882','2747583475882','Vines, Grapes, and Wines','The wine drinker''s guide to grape varieties','Jancis Robinson','Reference','Alfred A. Knopf','Wine','')");
        statement.executeUpdate("insert into titles (ISBN, PRINTISBN, TITLE, SUBTITLE, AUTHOR, SERIES, PUBLISHER, COLLECTIONS, COLLECTIONS2) values ('4356123483483','4356123483483','A Tale of Two Cities','A fictional account of events leading up to the French revolution','Charles Dickens','Classics','Chapman & Hall','Fiction','Social Criticism')");
        CallableStatement callableStatement = this.prepareCall("call syscs_util.syscs_register_tool('luceneSupport',true)");
        LuceneSupportTest.assertUpdateCount(callableStatement, 0);
    }

    @Override
    protected void tearDown() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("drop table titles");
        CallableStatement callableStatement = this.prepareCall("call syscs_util.syscs_register_tool('luceneSupport',false)");
        LuceneSupportTest.assertUpdateCount(callableStatement, 0);
        super.tearDown();
    }

    static void loadTestTable(Connection connection) throws Exception {
        connection.prepareStatement("create table textTable( keyCol int primary key, textCol clob )").execute();
        connection.prepareStatement("insert into textTable values\n( 1, 'one' ),\n( 2, 'one two' ),\n( 3, 'one two three' ),\n( 4, 'one two three four' ),\n( 5, 'one two three four five' ),\n( 6, 'one two three four five six' ),\n( 7, 'one two three four five six seven' ),\n( 8, 'one two three four five six seven eight' ),\n( 9, 'one two three four five six seven eight nine' ),\n( 10, 'one two three four five six seven eight nine ten' ),\n( 101, 'bricks' ),\n( 102, 'bricks and mortar' ),\n( 103, 'bricks and mortar, tea' ),\n( 104, 'bricks and mortar, tea, tears' ),\n( 105, 'bricks and mortar, tea, tears, turtle' ),\n( 106, 'bricks and mortar, tea, tears, turtle, soup' ),\n( 107, 'bricks and mortar, tea, tears, turtle, soup, when in the course' ),\n( 108, 'bricks and mortar, tea, tears, turtle, soup, when in the course of human events' ),\n( 109, 'bricks and mortar, tea, tears, turtle, soup, when in the course of human events you want' ),\n( 110, 'bricks and mortar, tea, tears, turtle, soup, when in the course of human events you want better cell coverage' )\n").execute();
    }

    static void unloadTestTable(Connection connection) throws Exception {
        connection.prepareStatement("drop table textTable").execute();
    }

    public static String getDatabaseLocale() throws SQLException {
        return ConnectionUtil.getCurrentLCC().getDatabase().getLocale().toString();
    }

    public static class MultiFieldIndexDescriptor
    implements LuceneIndexDescriptor {
        public String[] getFieldNames() {
            return new String[]{"tags", "text"};
        }

        public Analyzer getAnalyzer() {
            return new XMLAnalyzer();
        }

        public QueryParser getQueryParser() {
            Version version = LuceneUtils.currentVersion();
            return new MultiFieldQueryParser(version, this.getFieldNames(), (Analyzer)new StandardAnalyzer(version));
        }
    }

    private static class XMLTagsTokenizer
    extends AbstractTokenizer {
        XMLTagsTokenizer(Reader reader) {
            super(reader);
        }

        @Override
        Iterable<String> getTokens() {
            return LuceneSupportTest.getAllXMLTags(LuceneSupportTest.parseXMLDocument(this.input));
        }
    }

    private static class XMLTextTokenizer
    extends AbstractTokenizer {
        XMLTextTokenizer(Reader reader) {
            super(reader);
        }

        @Override
        Iterable<String> getTokens() {
            StringBuilder stringBuilder = new StringBuilder();
            LuceneSupportTest.getAllText(LuceneSupportTest.parseXMLDocument(this.input), stringBuilder);
            return Arrays.asList(stringBuilder.toString().split("[ \r\n\t]"));
        }
    }

    private static abstract class AbstractTokenizer
    extends Tokenizer {
        Iterator<String> tokens;
        final CharTermAttribute charTermAttr = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        final PositionIncrementAttribute posIncrAttr = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);

        AbstractTokenizer(Reader reader) {
            super(reader);
        }

        public boolean incrementToken() throws IOException {
            if (this.tokens == null) {
                this.tokens = this.getTokens().iterator();
            }
            if (this.tokens.hasNext()) {
                this.charTermAttr.setEmpty();
                this.charTermAttr.append(this.tokens.next());
                this.posIncrAttr.setPositionIncrement(1);
                return true;
            }
            return false;
        }

        public void reset() throws IOException {
            this.tokens = null;
            super.reset();
        }

        abstract Iterable<String> getTokens();
    }

    public static class XMLAnalyzer
    extends Analyzer {
        public XMLAnalyzer() {
            super(PER_FIELD_REUSE_STRATEGY);
        }

        protected Analyzer.TokenStreamComponents createComponents(String string, Reader reader) {
            if (string.equals("text")) {
                return new Analyzer.TokenStreamComponents((Tokenizer)new XMLTextTokenizer(reader));
            }
            if (string.equals("tags")) {
                return new Analyzer.TokenStreamComponents((Tokenizer)new XMLTagsTokenizer(reader));
            }
            Assert.fail((String)("unknown field name: " + string));
            return null;
        }
    }
}

