/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.oe.direct;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.derbyTesting.system.oe.client.Display;
import org.apache.derbyTesting.system.oe.client.Operations;
import org.apache.derbyTesting.system.oe.direct.OrderItem4Sort;
import org.apache.derbyTesting.system.oe.direct.StatementHelper;
import org.apache.derbyTesting.system.oe.model.Customer;
import org.apache.derbyTesting.system.oe.model.District;
import org.apache.derbyTesting.system.oe.model.Order;
import org.apache.derbyTesting.system.oe.model.OrderLine;
import org.apache.derbyTesting.system.oe.model.Warehouse;

public class Standard
extends StatementHelper
implements Operations {
    private final Customer customer = new Customer();
    private final Warehouse warehouse = new Warehouse();
    private final District district = new District();
    private final Order order = new Order();
    private final List<Object> nameList = new ArrayList<Object>();
    private static final String[] STOCK_INFO = new String[]{"SELECT S_QUANTITY, S_DIST_01, S_DATA FROM STOCK WHERE S_I_ID = ? AND S_W_ID = ?", "SELECT S_QUANTITY, S_DIST_02, S_DATA FROM STOCK WHERE S_I_ID = ? AND S_W_ID = ?", "SELECT S_QUANTITY, S_DIST_03, S_DATA FROM STOCK WHERE S_I_ID = ? AND S_W_ID = ?", "SELECT S_QUANTITY, S_DIST_04, S_DATA FROM STOCK WHERE S_I_ID = ? AND S_W_ID = ?", "SELECT S_QUANTITY, S_DIST_05, S_DATA FROM STOCK WHERE S_I_ID = ? AND S_W_ID = ?", "SELECT S_QUANTITY, S_DIST_06, S_DATA FROM STOCK WHERE S_I_ID = ? AND S_W_ID = ?", "SELECT S_QUANTITY, S_DIST_07, S_DATA FROM STOCK WHERE S_I_ID = ? AND S_W_ID = ?", "SELECT S_QUANTITY, S_DIST_08, S_DATA FROM STOCK WHERE S_I_ID = ? AND S_W_ID = ?", "SELECT S_QUANTITY, S_DIST_09, S_DATA FROM STOCK WHERE S_I_ID = ? AND S_W_ID = ?", "SELECT S_QUANTITY, S_DIST_10, S_DATA FROM STOCK WHERE S_I_ID = ? AND S_W_ID = ?"};

    public Standard(Connection connection) throws SQLException {
        super(connection, false, 8);
    }

    public static Operations noReset(Connection connection) throws SQLException {
        return new Standard(connection){

            @Override
            protected void reset(PreparedStatement preparedStatement) {
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stockLevel(Display display, Object object, short s, short s2, int n) throws Exception {
        int n2;
        int n3 = this.conn.getTransactionIsolation();
        try {
            try {
                this.conn.setTransactionIsolation(2);
                PreparedStatement preparedStatement = this.prepareStatement("SELECT D_NEXT_O_ID FROM DISTRICT WHERE D_W_ID = ? AND D_ID = ?");
                PreparedStatement preparedStatement2 = this.prepareStatement("SELECT COUNT(DISTINCT(S_I_ID)) AS LOW_STOCK FROM ORDERLINE, STOCK WHERE OL_W_ID = ? AND OL_D_ID = ? AND OL_O_ID < ? AND OL_O_ID >= ? AND S_W_ID = ? AND S_I_ID = OL_I_ID AND S_QUANTITY < ?");
                preparedStatement.setShort(1, s);
                preparedStatement.setShort(2, s2);
                preparedStatement2.setShort(1, s);
                preparedStatement2.setShort(2, s2);
                preparedStatement2.setShort(5, s);
                preparedStatement2.setInt(6, n);
                ResultSet resultSet = preparedStatement.executeQuery();
                resultSet.next();
                int n4 = resultSet.getInt("D_NEXT_O_ID");
                this.reset(preparedStatement);
                preparedStatement2.setInt(3, n4);
                preparedStatement2.setInt(4, n4 - 20);
                resultSet = preparedStatement2.executeQuery();
                resultSet.next();
                n2 = resultSet.getInt("LOW_STOCK");
                this.reset(preparedStatement2);
                this.conn.commit();
            }
            finally {
                this.conn.setTransactionIsolation(n3);
            }
        }
        catch (SQLException sQLException) {
            this.conn.rollback();
            this.conn.setTransactionIsolation(n3);
            throw sQLException;
        }
        if (display != null) {
            display.displayStockLevel(object, s, s2, n, n2);
        }
    }

    @Override
    public void orderStatus(Display display, Object object, short s, short s2, String string) throws Exception {
        PreparedStatement preparedStatement = this.prepareStatement("SELECT C_ID, C_BALANCE, C_FIRST, C_MIDDLE FROM CUSTOMER WHERE C_W_ID = ? AND C_D_ID = ? AND C_LAST = ? ORDER BY C_FIRST");
        try {
            preparedStatement.setShort(1, s);
            preparedStatement.setShort(2, s2);
            preparedStatement.setString(3, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            this.nameList.clear();
            while (resultSet.next()) {
                Customer customer = new Customer();
                customer.setWarehouse(s);
                customer.setDistrict(s2);
                customer.setLast(string);
                customer.setId(resultSet.getInt("C_ID"));
                customer.setBalance(resultSet.getString("C_BALANCE"));
                customer.setFirst(resultSet.getString("C_FIRST"));
                customer.setMiddle(resultSet.getString("C_MIDDLE"));
                this.nameList.add(customer);
            }
            this.reset(preparedStatement);
            if (this.nameList.isEmpty()) {
                throw new SQLException("Order Status by name - no matching customer " + string);
            }
            int n = this.nameList.size() / 2;
            if (n != 0 && this.nameList.size() % 2 == 1) {
                ++n;
            }
            Customer customer = (Customer)this.nameList.get(n);
            this.nameList.clear();
            this.getOrderStatusForCustomer(display, object, true, customer);
        }
        catch (SQLException sQLException) {
            this.conn.rollback();
            throw sQLException;
        }
    }

    @Override
    public void orderStatus(Display display, Object object, short s, short s2, int n) throws Exception {
        PreparedStatement preparedStatement = this.prepareStatement("SELECT C_BALANCE, C_FIRST, C_MIDDLE, C_LAST FROM CUSTOMER WHERE C_W_ID = ? AND C_D_ID = ? AND C_ID = ?");
        this.customer.clear();
        this.customer.setWarehouse(s);
        this.customer.setDistrict(s2);
        this.customer.setId(n);
        try {
            preparedStatement.setShort(1, s);
            preparedStatement.setShort(2, s2);
            preparedStatement.setInt(3, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            this.customer.setBalance(resultSet.getString("C_BALANCE"));
            this.customer.setFirst(resultSet.getString("C_FIRST"));
            this.customer.setMiddle(resultSet.getString("C_MIDDLE"));
            this.customer.setLast(resultSet.getString("C_LAST"));
            this.reset(preparedStatement);
            this.getOrderStatusForCustomer(display, object, false, this.customer);
        }
        catch (SQLException sQLException) {
            this.conn.rollback();
            throw sQLException;
        }
    }

    private void getOrderStatusForCustomer(Display display, Object object, boolean bl, Customer customer) throws Exception {
        PreparedStatement preparedStatement = this.prepareStatement("SELECT MAX(O_ID) AS LAST_ORDER FROM ORDERS WHERE O_W_ID = ? AND O_D_ID = ? AND O_C_ID = ?");
        PreparedStatement preparedStatement2 = this.prepareStatement("SELECT O_ENTRY_D, O_CARRIER_ID, O_OL_CNT FROM ORDERS WHERE O_W_ID = ? AND O_D_ID = ? AND O_ID = ?");
        PreparedStatement preparedStatement3 = this.prepareStatement("SELECT OL_I_ID, OL_SUPPLY_W_ID, OL_QUANTITY, OL_AMOUNT, OL_DELIVERY_D FROM ORDERLINE WHERE OL_W_ID = ? AND OL_D_ID = ? AND OL_O_ID = ?");
        this.order.clear();
        this.order.setWarehouse(customer.getWarehouse());
        this.order.setDistrict(customer.getDistrict());
        preparedStatement.setShort(1, customer.getWarehouse());
        preparedStatement.setShort(2, customer.getDistrict());
        preparedStatement.setInt(3, customer.getId());
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        this.order.setId(resultSet.getInt("LAST_ORDER"));
        this.reset(preparedStatement);
        preparedStatement2.setShort(1, customer.getWarehouse());
        preparedStatement2.setShort(2, customer.getDistrict());
        preparedStatement2.setInt(3, this.order.getId());
        resultSet = preparedStatement2.executeQuery();
        resultSet.next();
        this.order.setEntry_d(resultSet.getTimestamp("O_ENTRY_D"));
        this.order.setCarrier_id((Integer)resultSet.getObject("O_CARRIER_ID"));
        this.order.setOl_cnt(resultSet.getInt("O_OL_CNT"));
        resultSet.close();
        OrderLine[] orderLineArray = new OrderLine[this.order.getOl_cnt()];
        preparedStatement3.setShort(1, this.order.getWarehouse());
        preparedStatement3.setShort(2, this.order.getDistrict());
        preparedStatement3.setInt(3, this.order.getId());
        resultSet = preparedStatement3.executeQuery();
        int n = 0;
        while (resultSet.next()) {
            OrderLine orderLine = new OrderLine();
            orderLine.setI_id(resultSet.getInt("OL_I_ID"));
            orderLine.setSupply_w_id(resultSet.getShort("OL_SUPPLY_W_ID"));
            orderLine.setQuantity(resultSet.getShort("OL_QUANTITY"));
            orderLine.setAmount(resultSet.getString("OL_AMOUNT"));
            orderLine.setDelivery_d(resultSet.getTimestamp("OL_DELIVERY_D"));
            orderLineArray[n++] = orderLine;
        }
        resultSet.close();
        this.conn.commit();
        if (display != null) {
            display.displayOrderStatus(object, bl, customer, this.order, orderLineArray);
        }
    }

    @Override
    public void payment(Display display, Object object, short s, short s2, short s3, short s4, String string, String string2) throws Exception {
        PreparedStatement preparedStatement = this.prepareStatement("SELECT C_ID FROM CUSTOMER WHERE C_W_ID = ? AND C_D_ID = ? AND C_LAST = ? ORDER BY C_FIRST");
        try {
            preparedStatement.setShort(1, s3);
            preparedStatement.setShort(2, s4);
            preparedStatement.setString(3, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            this.nameList.clear();
            while (resultSet.next()) {
                this.nameList.add(resultSet.getObject("C_ID"));
            }
            this.reset(preparedStatement);
            if (this.nameList.isEmpty()) {
                throw new SQLException("Payment by name - no matching customer " + string);
            }
            int n = this.nameList.size() / 2;
            if (n != 0 && this.nameList.size() % 2 == 1) {
                ++n;
            }
            int n2 = (Integer)this.nameList.get(n);
            this.paymentById(display, object, s, s2, s3, s4, n2, string2);
        }
        catch (SQLException sQLException) {
            this.conn.rollback();
            throw sQLException;
        }
        if (display != null) {
            // empty if block
        }
    }

    @Override
    public void payment(Display display, Object object, short s, short s2, short s3, short s4, int n, String string) throws Exception {
        try {
            this.paymentById(display, object, s, s2, s3, s4, n, string);
        }
        catch (SQLException sQLException) {
            this.conn.rollback();
            throw sQLException;
        }
        if (display != null) {
            // empty if block
        }
    }

    private void paymentById(Display display, Object object, short s, short s2, short s3, short s4, int n, String string) throws Exception {
        PreparedStatement preparedStatement = this.prepareStatement("UPDATE CUSTOMER SET C_BALANCE = C_BALANCE - ?, C_YTD_PAYMENT = C_YTD_PAYMENT + ?, C_PAYMENT_CNT = C_PAYMENT_CNT + 1 WHERE C_W_ID = ? AND C_D_ID = ? AND C_ID = ?");
        PreparedStatement preparedStatement2 = this.prepareStatement("SELECT C_FIRST, C_MIDDLE, C_LAST, C_BALANCE, C_STREET_1, C_STREET_2, C_CITY, C_STATE, C_ZIP, C_PHONE, C_SINCE, C_CREDIT, C_CREDIT_LIM, C_DISCOUNT FROM CUSTOMER WHERE C_W_ID = ? AND C_D_ID = ? AND C_ID = ?");
        PreparedStatement preparedStatement3 = this.prepareStatement("UPDATE CUSTOMER SET C_DATA =  BAD_CREDIT_DATA(C_DATA, ?, ?, C_W_ID, C_W_ID, C_ID, ?) WHERE C_W_ID = ? AND C_D_ID = ? AND C_ID = ?");
        PreparedStatement preparedStatement4 = this.prepareStatement("SELECT SUBSTR(C_DATA, 1, 200) AS C_DATA_200 FROM CUSTOMER WHERE C_W_ID = ? AND C_D_ID = ? AND C_ID = ?");
        PreparedStatement preparedStatement5 = this.prepareStatement("UPDATE DISTRICT SET D_YTD = D_YTD + ? WHERE D_W_ID = ? AND D_ID = ?");
        PreparedStatement preparedStatement6 = this.prepareStatement("SELECT D_NAME, D_STREET_1, D_STREET_2, D_CITY, D_STATE, D_ZIP FROM DISTRICT WHERE D_W_ID = ? AND D_ID = ? ");
        PreparedStatement preparedStatement7 = this.prepareStatement("UPDATE WAREHOUSE SET W_YTD = W_YTD + ? WHERE W_ID = ?");
        PreparedStatement preparedStatement8 = this.prepareStatement("SELECT W_NAME, W_STREET_1, W_STREET_2, W_CITY, W_STATE, W_ZIP FROM WAREHOUSE WHERE W_ID = ?");
        PreparedStatement preparedStatement9 = this.prepareStatement("INSERT INTO HISTORY(H_C_ID, H_C_D_ID, H_C_W_ID, H_D_ID, H_W_ID, H_DATE, H_AMOUNT, H_DATA) VALUES (?, ?, ?, ?, ?, CURRENT TIMESTAMP, ?, ?)");
        Customer customer = new Customer();
        customer.setWarehouse(s3);
        customer.setDistrict(s4);
        customer.setId(n);
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string);
        preparedStatement.setShort(3, s3);
        preparedStatement.setShort(4, s4);
        preparedStatement.setInt(5, n);
        preparedStatement.executeUpdate();
        preparedStatement2.setShort(1, s3);
        preparedStatement2.setShort(2, s4);
        preparedStatement2.setInt(3, n);
        ResultSet resultSet = preparedStatement2.executeQuery();
        resultSet.next();
        customer.setFirst(resultSet.getString("C_FIRST"));
        customer.setMiddle(resultSet.getString("C_MIDDLE"));
        customer.setLast(resultSet.getString("C_LAST"));
        customer.setBalance(resultSet.getString("C_BALANCE"));
        customer.setAddress(this.getAddress(resultSet, "C_STREET_1"));
        customer.setPhone(resultSet.getString("C_PHONE"));
        customer.setSince(resultSet.getTimestamp("C_SINCE"));
        customer.setCredit(resultSet.getString("C_CREDIT"));
        customer.setCredit_lim(resultSet.getString("C_CREDIT_LIM"));
        customer.setDiscount(resultSet.getString("C_DISCOUNT"));
        this.reset(preparedStatement2);
        if ("BC".equals(customer.getCredit())) {
            preparedStatement3.setShort(1, s);
            preparedStatement3.setShort(2, s2);
            preparedStatement3.setString(3, string);
            preparedStatement3.setShort(4, s3);
            preparedStatement3.setShort(5, s4);
            preparedStatement3.setInt(6, n);
            preparedStatement3.executeUpdate();
            this.reset(preparedStatement3);
            preparedStatement4.setShort(1, s3);
            preparedStatement4.setShort(2, s4);
            preparedStatement4.setInt(3, n);
            resultSet = preparedStatement4.executeQuery();
            resultSet.next();
            customer.setData(resultSet.getString("C_DATA_200"));
            this.reset(preparedStatement4);
        }
        this.district.clear();
        this.district.setWarehouse(s);
        this.district.setId(s2);
        preparedStatement5.setString(1, string);
        preparedStatement5.setShort(2, s);
        preparedStatement5.setShort(3, s2);
        preparedStatement5.executeUpdate();
        this.reset(preparedStatement5);
        preparedStatement6.setShort(1, s);
        preparedStatement6.setShort(2, s2);
        resultSet = preparedStatement6.executeQuery();
        resultSet.next();
        this.district.setName(resultSet.getString("D_NAME"));
        this.district.setAddress(this.getAddress(resultSet, "D_STREET_1"));
        this.reset(preparedStatement6);
        this.warehouse.clear();
        this.warehouse.setId(s);
        preparedStatement7.setString(1, string);
        preparedStatement7.setShort(2, s);
        preparedStatement7.executeUpdate();
        this.reset(preparedStatement7);
        preparedStatement8.setShort(1, s);
        resultSet = preparedStatement8.executeQuery();
        resultSet.next();
        this.warehouse.setName(resultSet.getString("W_NAME"));
        this.warehouse.setAddress(this.getAddress(resultSet, "W_STREET_1"));
        this.reset(preparedStatement8);
        preparedStatement9.setInt(1, n);
        preparedStatement9.setShort(2, s4);
        preparedStatement9.setShort(3, s3);
        preparedStatement9.setShort(4, s2);
        preparedStatement9.setShort(5, s);
        preparedStatement9.setString(6, string);
        StringBuffer stringBuffer = new StringBuffer(24);
        stringBuffer.append(this.warehouse.getName());
        stringBuffer.append("    ");
        stringBuffer.append(this.district.getName());
        preparedStatement9.setString(7, stringBuffer.toString());
        preparedStatement9.executeUpdate();
        this.reset(preparedStatement9);
        this.conn.commit();
    }

    @Override
    public void newOrder(Display display, Object object, short s, short s2, int n, int[] nArray, short[] sArray, short[] sArray2) throws Exception {
        this.sortOrderItems(nArray, sArray, sArray2);
        try {
            BigDecimal bigDecimal;
            PreparedStatement preparedStatement = this.prepareStatement("SELECT W_TAX FROM WAREHOUSE WHERE W_ID = ?");
            preparedStatement.setShort(1, s);
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            BigDecimal bigDecimal2 = (BigDecimal)resultSet.getObject(1);
            this.reset(preparedStatement);
            PreparedStatement preparedStatement2 = this.prepareStatement("UPDATE DISTRICT SET D_NEXT_O_ID = D_NEXT_O_ID + 1 WHERE D_W_ID = ? AND D_ID = ?");
            preparedStatement2.setShort(1, s);
            preparedStatement2.setShort(2, s2);
            preparedStatement2.executeUpdate();
            this.reset(preparedStatement2);
            PreparedStatement preparedStatement3 = this.prepareStatement("SELECT D_NEXT_O_ID - 1, D_TAX FROM DISTRICT WHERE D_W_ID = ? AND D_ID = ?");
            preparedStatement3.setShort(1, s);
            preparedStatement3.setShort(2, s2);
            resultSet = preparedStatement3.executeQuery();
            resultSet.next();
            int n2 = resultSet.getInt(1);
            BigDecimal bigDecimal3 = (BigDecimal)resultSet.getObject(2);
            this.reset(preparedStatement3);
            PreparedStatement preparedStatement4 = this.prepareStatement("SELECT C_LAST, C_DISCOUNT, C_CREDIT FROM CUSTOMER WHERE C_W_ID = ? AND C_D_ID = ? AND C_ID = ?");
            preparedStatement4.setShort(1, s);
            preparedStatement4.setShort(2, s2);
            preparedStatement4.setInt(3, n);
            resultSet = preparedStatement4.executeQuery();
            resultSet.next();
            this.reset(preparedStatement4);
            short s3 = 1;
            for (int i = 0; i < sArray2.length; ++i) {
                if (sArray2[i] == s) continue;
                s3 = 0;
                break;
            }
            PreparedStatement preparedStatement5 = this.prepareStatement("INSERT INTO ORDERS VALUES (?, ?, ?, ?, CURRENT_TIMESTAMP, NULL, ?, ?)");
            preparedStatement5.setInt(1, n2);
            preparedStatement5.setShort(2, s2);
            preparedStatement5.setShort(3, s);
            preparedStatement5.setInt(4, n);
            preparedStatement5.setShort(5, (short)nArray.length);
            preparedStatement5.setShort(6, s3);
            preparedStatement5.executeUpdate();
            this.reset(preparedStatement5);
            PreparedStatement preparedStatement6 = this.prepareStatement("INSERT INTO NEWORDERS VALUES(?, ?, ?)");
            preparedStatement6.setInt(1, n2);
            preparedStatement6.setShort(2, s2);
            preparedStatement6.setShort(3, s);
            preparedStatement6.executeUpdate();
            this.reset(preparedStatement6);
            PreparedStatement preparedStatement7 = this.prepareStatement("INSERT INTO ORDERLINE(OL_W_ID, OL_D_ID, OL_O_ID, OL_NUMBER, OL_I_ID, OL_SUPPLY_W_ID, OL_QUANTITY, OL_AMOUNT, OL_DIST_INFO, OL_DELIVERY_D) VALUES (?, ?, ?, ?, ?, ?, ?, CAST (? AS DECIMAL(5,2)) * CAST (? AS SMALLINT), ?, NULL)");
            preparedStatement7.setShort(1, s);
            preparedStatement7.setShort(2, s2);
            preparedStatement7.setInt(3, n2);
            PreparedStatement preparedStatement8 = this.prepareStatement("SELECT I_PRICE, I_NAME, I_DATA FROM ITEM WHERE I_ID = ?");
            PreparedStatement preparedStatement9 = this.prepareStatement("UPDATE STOCK SET S_ORDER_CNT = S_ORDER_CNT + 1, S_YTD = S_YTD + ?, S_REMOTE_CNT = S_REMOTE_CNT + ?, S_QUANTITY = ? WHERE S_I_ID = ? AND S_W_ID = ?");
            for (int i = 0; i < nArray.length; ++i) {
                preparedStatement8.setInt(1, nArray[i]);
                resultSet = preparedStatement8.executeQuery();
                resultSet.next();
                bigDecimal = (BigDecimal)resultSet.getObject(1);
                String string = resultSet.getString(2);
                String string2 = resultSet.getString(3);
                resultSet.close();
                PreparedStatement preparedStatement10 = this.prepareStatement(STOCK_INFO[s2 - 1]);
                preparedStatement10.setInt(1, nArray[i]);
                preparedStatement10.setShort(2, s);
                resultSet = preparedStatement10.executeQuery();
                resultSet.next();
                int n3 = resultSet.getInt(1);
                String string3 = resultSet.getString(2);
                String string4 = resultSet.getString(3);
                this.reset(preparedStatement10);
                preparedStatement9.setInt(1, sArray[i]);
                preparedStatement9.setInt(2, s == sArray2[i] ? 0 : 1);
                n3 = n3 - sArray[i] > 10 ? (n3 -= sArray[i]) : n3 - sArray[i] + 91;
                preparedStatement9.setInt(3, n3);
                preparedStatement9.setInt(4, nArray[i]);
                preparedStatement9.setShort(5, s);
                preparedStatement9.executeUpdate();
                preparedStatement7.setShort(4, (short)(i + 1));
                preparedStatement7.setInt(5, nArray[i]);
                preparedStatement7.setShort(6, sArray2[i]);
                preparedStatement7.setShort(7, sArray[i]);
                preparedStatement7.setObject(8, (Object)bigDecimal, 3);
                preparedStatement7.setShort(9, sArray[i]);
                preparedStatement7.setString(10, string3);
                preparedStatement7.executeUpdate();
            }
            this.reset(preparedStatement7);
            this.reset(preparedStatement8);
            this.reset(preparedStatement7);
            this.reset(preparedStatement9);
            PreparedStatement preparedStatement11 = this.prepareStatement("SELECT SUM(OL_AMOUNT) FROM ORDERLINE WHERE OL_W_ID = ? AND OL_D_ID = ? AND OL_O_ID = ?");
            preparedStatement11.setShort(1, s);
            preparedStatement11.setShort(2, s2);
            preparedStatement11.setInt(3, n2);
            resultSet = preparedStatement11.executeQuery();
            resultSet.next();
            bigDecimal = (BigDecimal)resultSet.getObject(1);
            this.reset(preparedStatement11);
            this.conn.commit();
        }
        catch (SQLException sQLException) {
            this.conn.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scheduleDelivery(Display display, Object object, short s, short s2) throws Exception {
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO DELIVERY_REQUEST(DR_W_ID, DR_CARRIER_ID, DR_STATE) VALUES(?, ?, 'Q')");
        int n = this.conn.getTransactionIsolation();
        try {
            this.conn.setTransactionIsolation(2);
            preparedStatement.setShort(1, s);
            preparedStatement.setShort(2, s2);
            preparedStatement.executeUpdate();
            this.reset(preparedStatement);
            this.conn.commit();
        }
        finally {
            this.conn.setTransactionIsolation(n);
        }
        if (display != null) {
            display.displayScheduleDelivery(object, s, s2);
        }
    }

    @Override
    public void delivery() throws Exception {
        PreparedStatement preparedStatement = this.prepareStatement("SELECT DR_ID, DR_W_ID, DR_CARRIER_ID FROM DELIVERY_REQUEST WHERE DR_STATE = 'Q' ORDER BY DR_QUEUED");
        preparedStatement.setMaxRows(1);
        PreparedStatement preparedStatement2 = this.prepareStatement("UPDATE DELIVERY_REQUEST SET DR_STATE = ? WHERE DR_ID = ?");
        PreparedStatement preparedStatement3 = this.prepareStatement("UPDATE DELIVERY_REQUEST SET DR_STATE = 'C', DR_COMPLETED = CURRENT TIMESTAMP WHERE DR_ID = ?");
        PreparedStatement preparedStatement4 = this.prepareStatement("SELECT MIN(NO_O_ID) AS ORDER_TO_DELIVER FROM NEWORDERS WHERE NO_W_ID = ? AND NO_D_ID = ?");
        PreparedStatement preparedStatement5 = this.prepareStatement("DELETE FROM NEWORDERS WHERE NO_W_ID = ? AND NO_D_ID = ? AND NO_O_ID = ?");
        PreparedStatement preparedStatement6 = this.prepareStatement("UPDATE ORDERS SET O_CARRIER_ID = ? WHERE O_W_ID = ? AND O_D_ID = ? AND O_ID = ?");
        PreparedStatement preparedStatement7 = this.prepareStatement("UPDATE ORDERLINE SET OL_DELIVERY_D = CURRENT TIMESTAMP WHERE OL_W_ID = ? AND OL_D_ID = ? AND OL_O_ID = ?");
        PreparedStatement preparedStatement8 = this.prepareStatement("UPDATE CUSTOMER SET C_BALANCE = (SELECT SUM(OL_AMOUNT) FROM ORDERLINE WHERE OL_W_ID = ? AND OL_D_ID = ? AND OL_O_ID = ?), C_DELIVERY_CNT = C_DELIVERY_CNT + 1 WHERE C_W_ID = ? AND C_D_ID = ? AND C_ID = (SELECT O_C_ID FROM ORDERS WHERE O_W_ID = ? AND O_D_ID = ? AND O_ID = ?)");
        PreparedStatement preparedStatement9 = this.prepareStatement("INSERT INTO DELIVERY_ORDERS(DO_DR_ID, DO_D_ID, DO_O_ID) VALUES (?, ?, ?)");
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        int n = resultSet.getInt("DR_ID");
        short s = resultSet.getShort("DR_W_ID");
        short s2 = resultSet.getShort("DR_CARRIER_ID");
        this.reset(preparedStatement);
        preparedStatement2.setString(1, "I");
        preparedStatement2.setInt(2, n);
        preparedStatement2.executeUpdate();
        this.reset(preparedStatement2);
        this.conn.commit();
        preparedStatement9.setInt(1, n);
        for (short s3 = 1; s3 <= 10; s3 = (short)(s3 + 1)) {
            preparedStatement9.setShort(2, s3);
            preparedStatement4.setShort(1, s);
            preparedStatement4.setShort(2, s3);
            resultSet = preparedStatement4.executeQuery();
            resultSet.next();
            int n2 = resultSet.getInt("ORDER_TO_DELIVER");
            if (resultSet.wasNull()) {
                preparedStatement9.setNull(3, 4);
                preparedStatement9.addBatch();
            }
            this.reset(preparedStatement4);
            preparedStatement5.setShort(1, s);
            preparedStatement5.setShort(2, s3);
            preparedStatement5.setInt(3, n2);
            preparedStatement5.executeUpdate();
            this.reset(preparedStatement5);
            preparedStatement6.setShort(1, s2);
            preparedStatement6.setShort(2, s);
            preparedStatement6.setShort(3, s3);
            preparedStatement6.setInt(4, n2);
            preparedStatement6.executeUpdate();
            this.reset(preparedStatement6);
            preparedStatement7.setShort(1, s);
            preparedStatement7.setShort(2, s3);
            preparedStatement7.setInt(3, n2);
            preparedStatement7.executeUpdate();
            this.reset(preparedStatement7);
            preparedStatement8.setShort(1, s);
            preparedStatement8.setShort(2, s3);
            preparedStatement8.setInt(3, n2);
            preparedStatement8.setShort(4, s);
            preparedStatement8.setShort(5, s3);
            preparedStatement8.setShort(6, s);
            preparedStatement8.setShort(7, s3);
            preparedStatement8.setInt(8, n2);
            preparedStatement8.executeUpdate();
            this.reset(preparedStatement8);
            this.conn.commit();
            preparedStatement9.setInt(3, n2);
            preparedStatement9.addBatch();
        }
        preparedStatement9.executeBatch();
        this.reset(preparedStatement9);
        preparedStatement3.setInt(1, n);
        preparedStatement3.executeUpdate();
        this.reset(preparedStatement3);
        this.conn.commit();
    }

    public void sortOrderItems(int[] nArray, short[] sArray, short[] sArray2) {
        int n;
        Object[] objectArray = new OrderItem4Sort[nArray.length];
        for (n = 0; n < nArray.length; ++n) {
            objectArray[n] = new OrderItem4Sort(nArray[n], sArray[n], sArray2[n]);
        }
        Arrays.sort(objectArray);
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = ((OrderItem4Sort)objectArray[n]).i;
            sArray[n] = ((OrderItem4Sort)objectArray[n]).q;
            sArray2[n] = ((OrderItem4Sort)objectArray[n]).w;
        }
    }
}

