/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.TestConfiguration;

public class CursorTest
extends BaseJDBCTestCase {
    public CursorTest(String string) {
        super(string);
    }

    public void testCursor() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select i, c from t for update");
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        CursorTest.assertEquals((int)1956, (int)resultSet.getInt(1));
        CursorTest.assertEquals((String)"hello world", (String)resultSet.getString(2).trim());
        resultSet.close();
        if (CursorTest.usingEmbedded()) {
            CursorTest.assertNextError("XCL16", resultSet);
        } else if (CursorTest.usingDerbyNetClient()) {
            CursorTest.assertNextError("XCL16", resultSet);
        }
        resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
        }
        resultSet.next();
        if (CursorTest.usingEmbedded()) {
            CursorTest.assertGetIntError(1, "24000", resultSet);
        } else if (CursorTest.usingDerbyNetClient()) {
            CursorTest.assertGetIntError(1, "XJ121", resultSet);
        }
        resultSet.close();
    }

    public void testCursorParam() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select i, c from t where ?=1 for update");
        preparedStatement.setInt(1, 1);
        ResultSet resultSet = preparedStatement.executeQuery();
        CursorTest.assertTrue((String)"FAIL: unable to fetch row.", (boolean)resultSet.next());
        CursorTest.assertEquals((String)"FAIL: Wrong row on fetch with param", (int)1956, (int)resultSet.getInt(1));
        resultSet.close();
        CursorTest.assertNextError("XCL16", resultSet);
        preparedStatement.setBoolean(1, false);
        preparedStatement.setCursorName("ForCoverageSake");
        resultSet = preparedStatement.executeQuery();
        CursorTest.assertEquals((String)"ForCoverageSake", (String)resultSet.getCursorName());
        resultSet.next();
        if (CursorTest.usingEmbedded()) {
            CursorTest.assertGetIntError(1, "24000", resultSet);
        } else if (CursorTest.usingDerbyNetClient()) {
            CursorTest.assertGetIntError(1, "XJ121", resultSet);
        }
        resultSet.close();
    }

    public void testGetCursorName() throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from t");
        if (CursorTest.usingEmbedded()) {
            CursorTest.assertNull((Object)resultSet.getCursorName());
        } else if (CursorTest.usingDerbyNetClient()) {
            CursorTest.assertNotNull((Object)resultSet.getCursorName());
        }
        resultSet.close();
        resultSet = statement.executeQuery("select * from t for update");
        CursorTest.assertNotNull((Object)resultSet.getCursorName());
        resultSet.close();
        resultSet = statement.executeQuery("select * from t for update of i");
        CursorTest.assertNotNull((Object)resultSet.getCursorName());
        resultSet.close();
        statement.setCursorName("myselect");
        resultSet = statement.executeQuery("select * from t");
        CursorTest.assertEquals((String)"myselect", (String)resultSet.getCursorName());
        resultSet.close();
        statement.setCursorName("myselect2");
        resultSet = statement.executeQuery("select * from t for update");
        CursorTest.assertEquals((String)"myselect2", (String)resultSet.getCursorName());
        resultSet.close();
        statement.setCursorName("myselect3");
        resultSet = statement.executeQuery("select * from t for update of i");
        CursorTest.assertEquals((String)"myselect3", (String)resultSet.getCursorName());
        resultSet.close();
        statement.close();
    }

    public void derby2417testSetCursorNextExecute() throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from t for update");
        statement.setCursorName("AFTER_EXECUTE");
        CursorTest.assertFalse((boolean)"AFTER_EXECUTE".equals(resultSet.getCursorName()));
        resultSet.close();
        resultSet = statement.executeQuery("select * from t");
        CursorTest.assertEquals((String)"AFTER_EXECUTE", (String)resultSet.getCursorName());
        statement.setCursorName("CHANGE_AGAIN");
        CursorTest.assertEquals((String)"AFTER_EXECUTE", (String)resultSet.getCursorName());
        resultSet.close();
        resultSet = statement.executeQuery("select * from t");
        CursorTest.assertEquals((String)"CHANGE_AGAIN", (String)resultSet.getCursorName());
        statement.close();
        PreparedStatement preparedStatement = this.prepareStatement("select * from t for update");
        resultSet = preparedStatement.executeQuery();
        preparedStatement.setCursorName("AFTER_EXECUTE");
        CursorTest.assertFalse((boolean)"AFTER_EXECUTE".equals(resultSet.getCursorName()));
        resultSet.close();
        resultSet = preparedStatement.executeQuery();
        CursorTest.assertEquals((String)"AFTER_EXECUTE", (String)resultSet.getCursorName());
        preparedStatement.setCursorName("CHANGE_AGAIN");
        CursorTest.assertEquals((String)"AFTER_EXECUTE", (String)resultSet.getCursorName());
        resultSet.close();
        resultSet = preparedStatement.executeQuery();
        CursorTest.assertEquals((String)"CHANGE_AGAIN", (String)resultSet.getCursorName());
        preparedStatement.close();
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("CursorTest");
        baseTestSuite.addTest(TestConfiguration.defaultSuite(CursorTest.class));
        baseTestSuite.addTest((Test)new CursorTest("derby2417testSetCursorNextExecute"));
        return baseTestSuite;
    }

    protected void setUp() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t (i int, c char(50))");
        statement.executeUpdate("create table s (i int, c char(50))");
        statement.executeUpdate("insert into t values (1956, 'hello world')");
        statement.executeUpdate("insert into t values (456, 'hi yourself')");
        statement.executeUpdate("insert into t values (180, 'rubber ducky')");
        statement.executeUpdate("insert into t values (3, 'you are the one')");
        statement.close();
        this.commit();
    }

    @Override
    protected void tearDown() throws Exception {
        Statement statement = this.createStatement();
        this.rollback();
        statement.executeUpdate("drop table t");
        statement.executeUpdate("drop table s");
        statement.close();
        this.commit();
        super.tearDown();
    }
}

