/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class LuceneBackupTest
extends GeneratedColumnsHelper {
    private static final String DB_NAME = "lucenebackupdb";
    private static final String BACKUP_DIR = "extinout/backupdir";
    private static final String BACKUP_DIR2 = "extinout/backupdir2";
    private static final String TEST_DBO = "TEST_DBO";
    private static final String RUTH = "RUTH";
    private static final String ALICE = "ALICE";
    private static final String FRANK = "FRANK";
    private static final String[] LEGAL_USERS = new String[]{"TEST_DBO", "ALICE", "RUTH", "FRANK"};
    private static final String POLICY_FILE = "org/apache/derbyTesting/functionTests/tests/lang/luceneSupport.policy";
    private static final String ENGLISH_ANALYZER = "org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getEnglishAnalyzer";
    private static final String LOAD_TOOL = "call syscs_util.syscs_register_tool( 'luceneSupport', true )";
    private static final String UNLOAD_TOOL = "call syscs_util.syscs_register_tool( 'luceneSupport', false )";
    private static final String INDEX_POEMS = "call LuceneSupport.createIndex( 'ruth', 'poems', 'poemText', 'org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getEnglishAnalyzer' )";
    private static final String DROP_POEMS_INDEX = "call LuceneSupport.dropIndex( 'ruth', 'poems', 'poemText' )";
    private static final String READ_POEMS_INDEX = "select p.originalAuthor, i.score\nfrom ruth.poems p, table ( ruth.poems__poemText( 'star', 1000, null ) ) i\nwhere p.poemID = i.poemID and p.versionStamp = i.versionStamp\norder by i.score desc\n";
    private static final String[][] DEFAULT_POEMS_RESULT = new String[][]{{"Walt Whitman", "0.26756266"}, {"Lord Byron", "0.22933942"}, {"John Milton", "0.22933942"}};
    private static final String GOOD_SHUTDOWN = "08006";

    public LuceneBackupTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = (BaseTestSuite)TestConfiguration.embeddedSuite(LuceneBackupTest.class);
        SecurityManagerSetup securityManagerSetup = new SecurityManagerSetup((Test)baseTestSuite, POLICY_FILE);
        Test test = DatabasePropertyTestSetup.builtinAuthentication((Test)securityManagerSetup, LEGAL_USERS, "LuceneBackupPermissions");
        Test test2 = TestConfiguration.sqlAuthorizationDecoratorSingleUse(test, DB_NAME, true);
        SupportFilesSetup supportFilesSetup = new SupportFilesSetup(test2);
        return supportFilesSetup;
    }

    public void test_001_basic() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(RUTH);
        LuceneCoarseAuthorizationTest.createSchema(connection2);
        this.goodStatement(connection, LOAD_TOOL);
        this.goodStatement(connection2, INDEX_POEMS);
        this.assertResults(connection2, READ_POEMS_INDEX, DEFAULT_POEMS_RESULT, false);
        this.goodStatement(connection, "call syscs_util.syscs_backup_database( 'extinout/backupdir' )");
        this.goodStatement(connection2, DROP_POEMS_INDEX);
        this.goodStatement(connection, UNLOAD_TOOL);
        LuceneCoarseAuthorizationTest.dropSchema(connection2);
        String string = BACKUP_DIR + File.separator + DB_NAME;
        String string2 = this.getTestConfiguration().getPassword(TEST_DBO);
        String string3 = this.getTestConfiguration().getPassword(RUTH);
        connection = DriverManager.getConnection("jdbc:derby:memory:lbt1;user=TEST_DBO;password=" + string2 + ";restoreFrom=" + string);
        connection2 = DriverManager.getConnection("jdbc:derby:memory:lbt1;user=RUTH;password=" + string3);
        this.assertResults(connection2, READ_POEMS_INDEX, DEFAULT_POEMS_RESULT, false);
        this.goodStatement(connection, "call syscs_util.syscs_backup_database( 'extinout/backupdir2' )");
        try {
            connection = DriverManager.getConnection("jdbc:derby:memory:lbt1;user=TEST_DBO;password=" + string2 + ";drop=true");
            LuceneBackupTest.fail((String)"Expected to get an exception!");
        }
        catch (SQLException sQLException) {
            LuceneBackupTest.assertEquals((String)GOOD_SHUTDOWN, (String)sQLException.getSQLState());
        }
        string = BACKUP_DIR2 + File.separator + "lbt1";
        connection = DriverManager.getConnection("jdbc:derby:memory:lbt2;user=TEST_DBO;password=" + string2 + ";restoreFrom=" + string);
        connection2 = DriverManager.getConnection("jdbc:derby:memory:lbt2;user=RUTH;password=" + string3);
        this.assertResults(connection2, READ_POEMS_INDEX, DEFAULT_POEMS_RESULT, false);
        try {
            connection = DriverManager.getConnection("jdbc:derby:memory:lbt2;user=TEST_DBO;password=" + string2 + ";drop=true");
            LuceneBackupTest.fail((String)"Expected to get an exception!");
        }
        catch (SQLException sQLException) {
            LuceneBackupTest.assertEquals((String)GOOD_SHUTDOWN, (String)sQLException.getSQLState());
        }
    }
}

