/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ShutDownDBWhenNSShutsDownTest
extends BaseJDBCTestCase {
    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("ShutDownDBWhenNSShutsDownTest");
        suite.addTest(TestConfiguration.clientServerDecorator((Test)new ShutDownDBWhenNSShutsDownTest("testEngineShutdownDoesNotTakeDownNSManualReload")));
        suite.addTest(TestConfiguration.clientServerDecorator((Test)new ShutDownDBWhenNSShutsDownTest("testDatabasesShutDownWhenNSShutdownAPI")));
        return suite;
    }

    public ShutDownDBWhenNSShutsDownTest(String name) {
        super(name);
    }

    public void testEngineShutdownDoesNotTakeDownNSManualReload() throws Exception {
        this.scenarioEngineShutdownDoesNotTakeDownNS(true);
    }

    public void testEngineShutdownDoesNotTakeDownNSAutoReload() throws Exception {
        this.scenarioEngineShutdownDoesNotTakeDownNS(false);
    }

    private void scenarioEngineShutdownDoesNotTakeDownNS(boolean loadEmbeddedDriver) throws Exception {
        int i;
        Connection[] conns = new Connection[20];
        for (i = 0; i < conns.length; ++i) {
            conns[i] = this.openDefaultConnection();
        }
        for (i = 0; i < conns.length; ++i) {
            conns[i].close();
            conns[i] = null;
        }
        Thread.sleep(500L);
        TestConfiguration.getCurrent().shutdownEngine();
        if (loadEmbeddedDriver) {
            Class<?> clazz = Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
            clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        for (int i2 = 0; i2 < 20; ++i2) {
            this.openDefaultConnection().close();
        }
    }

    public void testDatabasesShutDownWhenNSShutdownAPI() throws Exception {
        this.shutdownServerCheckDBShutDown(false);
    }

    public void XXtestDatabasesShutDownWhenNSShutdown() throws Exception {
        this.shutdownServerCheckDBShutDown(true);
    }

    private void shutdownServerCheckDBShutDown(boolean dbShutDown) throws Exception {
        this.createDatabase();
        NetworkServerControl server = NetworkServerTestSetup.getNetworkServerControl();
        server.shutdown();
        String fileName = ShutDownDBWhenNSShutsDownTest.getSystemProperty("derby.system.home") + File.separator + TestConfiguration.getCurrent().getDefaultDatabaseName() + File.separator + "db.lck";
        File lockFile = new File(fileName);
        boolean fileNotFound = false;
        int i = 0;
        do {
            Thread.sleep(500L);
        } while ((fileNotFound = !PrivilegedFileOpsForTests.exists(lockFile)) != dbShutDown && ++i < 120);
        ShutDownDBWhenNSShutsDownTest.assertEquals((String)"Database is shut down", (boolean)dbShutDown, (boolean)fileNotFound);
    }

    private void createDatabase() throws SQLException {
        Connection conn = this.getConnection();
        conn.setAutoCommit(false);
        Statement st = conn.createStatement();
        st.execute("CREATE TABLE T1 (a int)");
        st.execute("INSERT INTO T1 VALUES (1), (2), (3), (4), (5)");
        st.execute("DROP TABLE T1");
        conn.commit();
        conn.close();
    }
}

