/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;

class SimpleStringOperatorNode
extends UnaryOperatorNode {
    SimpleStringOperatorNode(ValueNode operand, String methodName, ContextManager cm) throws StandardException {
        super(operand, methodName, methodName, cm);
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        this.bindOperand(fromList, subqueryList, aggregates);
        TypeId operandType = this.operand.getTypeId();
        switch (operandType.getJDBCTypeId()) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                break;
            }
            case 1111: 
            case 2000: {
                throw StandardException.newException("42X25", this.methodName, operandType.getSQLTypeName());
            }
            default: {
                DataTypeDescriptor dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, true, this.operand.getTypeCompiler().getCastToCharWidth(this.operand.getTypeServices()));
                this.operand = new CastNode(this.operand, dtd, this.getContextManager());
                this.operand.setCollationUsingCompilationSchema();
                ((CastNode)this.operand).bindCastNodeOnly();
                operandType = this.operand.getTypeId();
            }
        }
        this.setType(new DataTypeDescriptor(operandType, this.operand.getTypeServices().isNullable(), this.operand.getTypeCompiler().getCastToCharWidth(this.operand.getTypeServices())));
        this.setCollationInfo(this.operand.getTypeServices());
        return this;
    }

    @Override
    void bindParameter() throws StandardException {
        this.operand.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(12));
        this.operand.setCollationUsingCompilationSchema();
    }

    @Override
    String getReceiverInterfaceName() {
        return "org.apache.derby.iapi.types.StringDataValue";
    }
}

