/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.TimerTask;
import javax.transaction.xa.XAException;
import org.apache.derby.iapi.error.ExceptionUtil;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextImpl;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.timer.TimerFactory;
import org.apache.derby.iapi.store.access.xa.XAXactId;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.jdbc.EmbedXAResource;

final class XATransactionState
extends ContextImpl {
    static final int TRO_TIMEOUT = -3;
    static final int TRO_DEADLOCK = -2;
    static final int TRO_FAIL = -1;
    static final int T0_NOT_ASSOCIATED = 0;
    static final int T1_ASSOCIATED = 1;
    static final int TC_COMPLETED = 3;
    final EmbedConnection conn;
    final EmbedXAResource creatingResource;
    private EmbedXAResource associatedResource;
    final XAXactId xid;
    CleanupOrCancelMonitor cleanupOrCancelMonitor = new CleanupOrCancelMonitor();
    HashMap<EmbedXAResource, XATransactionState> suspendedList;
    int associationState;
    int rollbackOnlyCode;
    boolean isPrepared;
    boolean performTimeoutRollback;
    CancelXATransactionTask timeoutTask = null;

    private static TimerFactory getTimerFactory() {
        return XATransactionState.getMonitor().getTimerFactory();
    }

    XATransactionState(ContextManager cm, EmbedConnection conn, EmbedXAResource resource, XAXactId xid) {
        super(cm, "XATransactionState");
        this.conn = conn;
        this.associatedResource = resource;
        this.creatingResource = resource;
        this.associationState = 1;
        this.xid = xid;
        this.performTimeoutRollback = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanupOnError(Throwable t) {
        if (this.cleanupOrCancelMonitor.okToCleanup() && t instanceof StandardException) {
            StandardException se = (StandardException)t;
            if (se.getSeverity() >= 40000) {
                this.popMe();
                return;
            }
            if (se.getSeverity() == 30000) {
                XATransactionState xATransactionState = this;
                synchronized (xATransactionState) {
                    this.notifyAll();
                    this.associationState = -1;
                    this.rollbackOnlyCode = "40001".equals(se.getMessageId()) ? 102 : (se.isLockTimeout() ? 106 : 104);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start(EmbedXAResource resource, int flags) throws XAException {
        XATransactionState xATransactionState = this;
        synchronized (xATransactionState) {
            boolean isSuspendedByResource;
            if (this.associationState == -1) {
                throw new XAException(this.rollbackOnlyCode);
            }
            boolean bl = isSuspendedByResource = this.suspendedList != null && this.suspendedList.get(resource) != null;
            if (flags == 0x8000000 ? !isSuspendedByResource : isSuspendedByResource) {
                throw new XAException(-6);
            }
            while (this.associationState == 1) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    throw new XAException(4);
                }
            }
            switch (this.associationState) {
                case 0: {
                    break;
                }
                case -3: 
                case -2: 
                case -1: {
                    throw new XAException(this.rollbackOnlyCode);
                }
                default: {
                    throw new XAException(-4);
                }
            }
            if (this.isPrepared) {
                throw new XAException(-6);
            }
            if (isSuspendedByResource) {
                this.suspendedList.remove(resource);
            }
            this.associationState = 1;
            this.associatedResource = resource;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean end(EmbedXAResource resource, int flags, boolean endingCurrentXid) throws XAException {
        boolean rollbackOnly = false;
        XATransactionState xATransactionState = this;
        synchronized (xATransactionState) {
            boolean isSuspendedByResource;
            boolean bl = isSuspendedByResource = this.suspendedList != null && this.suspendedList.get(resource) != null;
            if (!endingCurrentXid) {
                while (this.associationState == 1) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ie) {
                        throw new XAException(4);
                    }
                }
            }
            switch (this.associationState) {
                case 3: {
                    throw new XAException(-4);
                }
                case -1: {
                    if (endingCurrentXid) {
                        flags = 0x20000000;
                        break;
                    }
                    throw new XAException(this.rollbackOnlyCode);
                }
            }
            boolean notify = false;
            switch (flags) {
                case 0x4000000: {
                    if (isSuspendedByResource) {
                        this.suspendedList.remove(resource);
                    } else {
                        if (resource != this.associatedResource) {
                            throw new XAException(-6);
                        }
                        this.associationState = 0;
                        this.associatedResource = null;
                        notify = true;
                    }
                    this.conn.setApplicationConnection(null);
                    break;
                }
                case 0x20000000: {
                    if (isSuspendedByResource) {
                        this.suspendedList.remove(resource);
                    } else {
                        if (resource != this.associatedResource) {
                            throw new XAException(-6);
                        }
                        this.associatedResource = null;
                    }
                    if (this.associationState != -1) {
                        this.associationState = -1;
                        this.rollbackOnlyCode = 100;
                    }
                    this.conn.setApplicationConnection(null);
                    notify = true;
                    rollbackOnly = true;
                    break;
                }
                case 0x2000000: {
                    if (isSuspendedByResource) {
                        throw new XAException(-6);
                    }
                    if (resource != this.associatedResource) {
                        throw new XAException(-6);
                    }
                    if (this.suspendedList == null) {
                        this.suspendedList = new HashMap();
                    }
                    this.suspendedList.put(resource, this);
                    this.associationState = 0;
                    this.associatedResource = null;
                    this.conn.setApplicationConnection(null);
                    notify = true;
                    break;
                }
                default: {
                    throw new XAException(-5);
                }
            }
            if (notify) {
                this.notifyAll();
            }
            return rollbackOnly;
        }
    }

    synchronized void scheduleTimeoutTask(long timeoutMillis) {
        this.performTimeoutRollback = true;
        if (timeoutMillis > 0L) {
            this.timeoutTask = new CancelXATransactionTask(this);
            XATransactionState.getTimerFactory().schedule(this.timeoutTask, timeoutMillis);
        } else {
            this.timeoutTask = null;
        }
    }

    synchronized void xa_rollback() throws SQLException {
        this.conn.xa_rollback();
        this.xa_finalize();
    }

    synchronized void xa_commit(boolean onePhase) throws SQLException {
        this.conn.xa_commit(onePhase);
        this.xa_finalize();
    }

    synchronized int xa_prepare() throws SQLException {
        int retVal;
        try {
            retVal = this.conn.xa_prepare();
        }
        catch (SQLException e) {
            if (ExceptionUtil.isDeferredConstraintViolation(e.getSQLState())) {
                this.xa_finalize();
            }
            throw e;
        }
        if (retVal == 1) {
            this.xa_finalize();
        }
        return retVal;
    }

    private void xa_finalize() {
        if (this.timeoutTask != null) {
            XATransactionState.getTimerFactory().cancel(this.timeoutTask);
            this.timeoutTask = null;
        }
        this.performTimeoutRollback = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel(String messageId) throws XAException {
        if (this.cleanupOrCancelMonitor.okToCancel()) {
            XATransactionState xATransactionState = this;
            synchronized (xATransactionState) {
                this.creatingResource.removeXATransaction(this.xid);
                if (this.performTimeoutRollback) {
                    if (messageId != null) {
                        Monitor.logTextMessage(messageId, this.xid.toString());
                    }
                    if (this.associationState == 1) {
                        this.conn.cancelRunningStatement();
                        EmbedXAResource assocRes = this.associatedResource;
                        this.end(assocRes, 0x20000000, true);
                    }
                    try {
                        this.conn.xa_rollback();
                    }
                    catch (SQLException sqle) {
                        XAException ex = new XAException(-3);
                        ex.initCause(sqle);
                        throw ex;
                    }
                    this.creatingResource.returnConnectionToResource(this, this.xid);
                }
            }
        }
    }

    private static ModuleFactory getMonitor() {
        return AccessController.doPrivileged(new PrivilegedAction<ModuleFactory>(){

            @Override
            public ModuleFactory run() {
                return Monitor.getMonitor();
            }
        });
    }

    private static class CancelXATransactionTask
    extends TimerTask {
        private XATransactionState xaState;

        public CancelXATransactionTask(XATransactionState xaState) {
            this.xaState = xaState;
        }

        @Override
        public synchronized boolean cancel() {
            this.xaState = null;
            return super.cancel();
        }

        @Override
        public synchronized void run() {
            try {
                if (null != this.xaState) {
                    this.xaState.cancel("J135");
                }
            }
            catch (Throwable th) {
                Monitor.logThrowable(th);
            }
        }
    }

    private static class CleanupOrCancelMonitor {
        private Long cancelThreadId;
        private Long cleanupThreadId;

        private CleanupOrCancelMonitor() {
        }

        public synchronized boolean okToCancel() {
            boolean res = false;
            if (null == this.cancelThreadId && null == this.cleanupThreadId) {
                this.cancelThreadId = Thread.currentThread().getId();
                res = true;
            }
            return res;
        }

        private synchronized boolean okToCleanup() {
            boolean res = false;
            if (null == this.cleanupThreadId && null == this.cancelThreadId) {
                this.cleanupThreadId = Thread.currentThread().getId();
                res = true;
            }
            return res;
        }
    }
}

