/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Arrays;
import junit.framework.Test;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.Utf8CcsidManager;
import org.apache.derbyTesting.functionTests.util.TestNullOutputStream;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Utf8CcsidManagerClientTest
extends BaseTestCase {
    private static final String CANNOT_CONVERT = "22005";
    private Utf8CcsidManager ccsidManager = new Utf8CcsidManager();
    private Agent agent;

    public Utf8CcsidManagerClientTest(String name) throws Exception {
        super(name);
        PrintWriter pw = new PrintWriter(new TestNullOutputStream());
        this.agent = new NetAgent(null, new LogWriter(pw, 0));
    }

    protected void tearDown() {
        this.ccsidManager = null;
        this.agent = null;
    }

    public void testConvertFromJavaString() throws Exception {
        String ucs2String = new String(new String("\u4f60\u597d\u4e16\u754c").getBytes("UTF-16"), "UTF-16");
        byte[] utf8Bytes = new String("\u4f60\u597d\u4e16\u754c").getBytes("UTF-8");
        byte[] utf8Converted = this.ccsidManager.convertFromJavaString(ucs2String, null);
        Utf8CcsidManagerClientTest.assertTrue((String)"UTF-8 conversion isn't equal to bytes", (boolean)Arrays.equals(utf8Bytes, utf8Converted));
    }

    public void testConvertFromJavaStringWithOffset() throws Exception {
        String ucs2String = new String(new String("\u4f60\u597d\u4e16\u754c").getBytes("UTF-16"), "UTF-16");
        byte[] additionalBytes = new String("\u53f0\u4f60\u597d\u4e16\u754c").getBytes("UTF-8");
        byte[] buffer = new byte[additionalBytes.length];
        buffer[0] = additionalBytes[0];
        buffer[1] = additionalBytes[1];
        buffer[2] = additionalBytes[2];
        ByteBuffer wrapper = ByteBuffer.wrap(buffer);
        wrapper.position(3);
        this.ccsidManager.startEncoding();
        boolean success = this.ccsidManager.encode(CharBuffer.wrap(ucs2String), wrapper, null);
        Utf8CcsidManagerClientTest.assertTrue((String)"Overflow in encode()", (boolean)success);
        Utf8CcsidManagerClientTest.assertTrue((String)"UTF-8 conversion isn't equal to bytes (with buffer)", (boolean)Arrays.equals(additionalBytes, buffer));
    }

    public void testConvertToJavaString() throws Exception {
        byte[] utf8Bytes = new String("\u4f60\u597d\u4e16\u754c").getBytes("UTF-8");
        String offsetUcs2String = new String(new String("\u597d\u4e16").getBytes("UTF-16"), "UTF-16");
        String convertedOffset = this.ccsidManager.convertToJavaString(utf8Bytes, 3, 6);
        Utf8CcsidManagerClientTest.assertEquals((String)offsetUcs2String, (String)convertedOffset);
    }

    public void testInvalidCharacters() {
        block5: {
            String invalidString;
            block4: {
                invalidString = "\ud800";
                this.ccsidManager.startEncoding();
                try {
                    this.ccsidManager.encode(CharBuffer.wrap(invalidString), ByteBuffer.allocate(10), this.agent);
                    Utf8CcsidManagerClientTest.fail((String)"Encoding invalid codepoint should fail");
                }
                catch (SqlException sqle) {
                    if (CANNOT_CONVERT.equals(sqle.getSQLState())) break block4;
                    Utf8CcsidManagerClientTest.fail("Expected SQLState 22005", sqle);
                }
            }
            try {
                this.ccsidManager.convertFromJavaString(invalidString, this.agent);
                Utf8CcsidManagerClientTest.fail((String)"Encoding invalid codepoint should fail");
            }
            catch (SqlException sqle) {
                if (CANNOT_CONVERT.equals(sqle.getSQLState())) break block5;
                Utf8CcsidManagerClientTest.fail("Expected SQLState 22005", sqle);
            }
        }
    }

    public static Test suite() {
        return TestConfiguration.clientServerSuite(Utf8CcsidManagerClientTest.class);
    }
}

