/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors.parsers;

import java.io.Serializable;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.util.Maybe$;
import org.apache.daffodil.runtime1.processors.DelimiterIterator;
import org.apache.daffodil.runtime1.processors.Evaluatable;
import org.apache.daffodil.runtime1.processors.LocalTypedDelimiterIterator;
import org.apache.daffodil.runtime1.processors.PrimProcessor;
import org.apache.daffodil.runtime1.processors.Processor;
import org.apache.daffodil.runtime1.processors.RemoteTerminatingMarkupAndLocalTypedDelimiterIterator;
import org.apache.daffodil.runtime1.processors.RuntimeData;
import org.apache.daffodil.runtime1.processors.TermRuntimeData;
import org.apache.daffodil.runtime1.processors.ToBriefXMLImpl;
import org.apache.daffodil.runtime1.processors.dfa.DFADelimiter;
import org.apache.daffodil.runtime1.processors.dfa.ParseResult;
import org.apache.daffodil.runtime1.processors.dfa.TextParser;
import org.apache.daffodil.runtime1.processors.parsers.DelimiterTextType;
import org.apache.daffodil.runtime1.processors.parsers.DelimiterTextType$Initiator$;
import org.apache.daffodil.runtime1.processors.parsers.DelimiterTextType$Terminator$;
import org.apache.daffodil.runtime1.processors.parsers.PState;
import org.apache.daffodil.runtime1.processors.parsers.Parser;
import org.apache.daffodil.runtime1.processors.parsers.TextPrimParser;
import scala.Function1;
import scala.Int$;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;

public class DelimiterTextParser
implements ToBriefXMLImpl,
Processor,
PrimProcessor,
Parser,
TextPrimParser {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(DelimiterTextParser.class.getDeclaredField("parserName$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DelimiterTextParser.class.getDeclaredField("org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1"));
    private volatile Object org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1;
    private boolean isInitialized;
    private volatile Object parserName$lzy1;
    private final TermRuntimeData rd;
    private final TextParser textParser;
    private final DelimiterTextType.Type delimiterType;
    private final boolean isDelimited;
    private final boolean mustMatchNonZeroData;
    private final String nom;

    public DelimiterTextParser(TermRuntimeData rd, TextParser textParser, DelimiterTextType.Type delimiterType, boolean isDelimited, boolean mustMatchNonZeroData) {
        this.rd = rd;
        this.textParser = textParser;
        this.delimiterType = delimiterType;
        this.isDelimited = isDelimited;
        this.mustMatchNonZeroData = mustMatchNonZeroData;
        ToBriefXMLImpl.$init$(this);
        Processor.$init$(this);
        Parser.$init$(this);
        this.nom = delimiterType.toString();
    }

    @Override
    public String org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_() {
        Object object = this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzyINIT1();
    }

    private Object org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = ToBriefXMLImpl.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$(this);
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public void isInitialized_$eq(boolean x$1) {
        this.isInitialized = x$1;
    }

    @Override
    public String parserName() {
        Object object = this.parserName$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.parserName$lzyINIT1();
    }

    private Object parserName$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.parserName$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = Parser.parserName$(this);
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.parserName$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public Vector<Evaluatable<Object>> runtimeDependencies() {
        return this.rd.encodingInfo().runtimeDependencies();
    }

    @Override
    public RuntimeData context() {
        return this.rd;
    }

    @Override
    public String nom() {
        return this.nom;
    }

    private boolean containsLocalMatch(ArrayBuffer<DFADelimiter> matchedDelimiters, PState state) {
        int localIndexStart = BoxesRunTime.unboxToInt(state.mpstate().delimitersLocalIndexStack().top());
        ArrayBuffer<DFADelimiter> inScopeDelimiters = state.mpstate().delimiters();
        int foundLocalDFAIndex = -1;
        for (int i = matchedDelimiters.length() - 1; foundLocalDFAIndex < 0 && i >= 0; --i) {
            DFADelimiter dfa = (DFADelimiter)matchedDelimiters.apply(i);
            DelimiterTextType.Type type = dfa.delimType();
            DelimiterTextType.Type type2 = this.delimiterType;
            if (type != null ? !type.equals(type2) : type2 != null) continue;
            foundLocalDFAIndex = inScopeDelimiters.indexWhere((Function1 & Serializable)_$2 -> dfa == _$2, localIndexStart);
        }
        return foundLocalDFAIndex >= 0;
    }

    private ArrayBuffer<DFADelimiter> localDelimiters(PState state) {
        int localIndexStart = BoxesRunTime.unboxToInt(state.mpstate().delimitersLocalIndexStack().top());
        ArrayBuffer<DFADelimiter> inScopeDelimiters = state.mpstate().delimiters();
        ArrayBuffer res = (ArrayBuffer)inScopeDelimiters.slice(localIndexStart, inScopeDelimiters.length());
        return res;
    }

    private void didNotFindExpectedDelimiter(ParseResult foundDelimiter, PState start) {
        ArrayBuffer<DFADelimiter> localDelims = this.localDelimiters(start);
        DFADelimiter foundDFA = (DFADelimiter)foundDelimiter.matchedDFAs().apply(0);
        this.PE(start, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Found enclosing delimiter: %s during scan for local delimiter(s): %s.\n         | The expected delimiter(s) were: %s.\n         | The enclosing delimiter was from %s %s.\n         |")), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{foundDFA.strForDiagnostic(), ((IterableOnceOps)localDelims.map((Function1 & Serializable)d -> d.strForDiagnostic())).mkString(", "), ((IterableOnceOps)localDelims.map((Function1 & Serializable)d -> "  " + d.delimType().toString() + " " + d.strForDiagnostic() + " from " + d.location() + " " + d.location().locationDescription() + ".")).mkString("\n", "\n", ""), foundDFA.location(), foundDFA.location().locationDescription()}));
    }

    @Override
    public void parse(PState start) {
        Object foundDelimiter;
        Object object;
        DelimiterTextType.Type type = this.delimiterType;
        DelimiterTextType$Terminator$ delimiterTextType$Terminator$ = DelimiterTextType$Terminator$.MODULE$;
        if (!(type != null ? !type.equals(delimiterTextType$Terminator$) : delimiterTextType$Terminator$ != null) && !this.isDelimited) {
            object = Maybe$.MODULE$.apply(new LocalTypedDelimiterIterator(this.delimiterType, start.mpstate().delimiters(), BoxesRunTime.unboxToInt(start.mpstate().delimitersLocalIndexStack().top())));
        } else {
            Object object2;
            DelimiterTextType.Type type2 = this.delimiterType;
            DelimiterTextType$Initiator$ delimiterTextType$Initiator$ = DelimiterTextType$Initiator$.MODULE$;
            object = !(type2 == null ? delimiterTextType$Initiator$ != null : !type2.equals(delimiterTextType$Initiator$)) || !Maybe$.MODULE$.isDefined$extension(object2 = start.delimitedParseResult()) ? Maybe$.MODULE$.apply(new RemoteTerminatingMarkupAndLocalTypedDelimiterIterator(this.delimiterType, start.mpstate().delimiters(), BoxesRunTime.unboxToInt(start.mpstate().delimitersLocalIndexStack().top()))) : Maybe$.MODULE$.Nope();
        }
        Object maybeDelimIter = object;
        Object object3 = foundDelimiter = Maybe$.MODULE$.isDefined$extension(maybeDelimIter) ? this.textParser.parse(start, start.dataInputStream(), (DelimiterIterator)Maybe$.MODULE$.get$extension(maybeDelimIter)) : start.delimitedParseResult();
        if (Maybe$.MODULE$.isDefined$extension(foundDelimiter)) {
            if (!this.containsLocalMatch(((ParseResult)Maybe$.MODULE$.get$extension(foundDelimiter)).matchedDFAs(), start)) {
                this.didNotFindExpectedDelimiter((ParseResult)Maybe$.MODULE$.get$extension(foundDelimiter), start);
                return;
            }
            Object object4 = ((ParseResult)Maybe$.MODULE$.get$extension(foundDelimiter)).matchedDelimiterValue();
            int nChars = ((String)Maybe$.MODULE$.get$extension(object4)).length();
            if (this.mustMatchNonZeroData && nChars == 0) {
                throw start.SDE("The initiator must match non-zero length data when dfdl:initiatedContent is 'yes'.", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            }
            boolean wasDelimiterTextSkipped = start.dataInputStream().skipChars(Int$.MODULE$.int2long(nChars), start);
            if (!wasDelimiterTextSkipped) {
                throw Assert$.MODULE$.abort("Invariant broken: wasDelimiterTextSkipped");
            }
            start.clearDelimitedParseResult();
            return;
        }
        DelimiterIterator scannedDelims = (DelimiterIterator)Maybe$.MODULE$.get$extension(maybeDelimIter);
        scannedDelims.reset();
        while (scannedDelims.hasNext() && scannedDelims.isRemote()) {
        }
        Object localTypedDelims = scannedDelims.next().lookingFor();
        while (scannedDelims.hasNext()) {
            localTypedDelims = (String)localTypedDelims + " " + scannedDelims.next().lookingFor();
        }
        this.PE(start, "%s '%s' not found", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.delimiterType.toString(), localTypedDelims}));
    }
}

