/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.core.dsom;

import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.TimeZone;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.exceptions.ThrowsSDE;
import org.apache.daffodil.lib.exceptions.UnsuppressableException;
import org.apache.daffodil.runtime1.dpath.NodeInfo;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$AnyURI$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$Boolean$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$Byte$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$Date$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$DateTime$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$Decimal$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$Double$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$Float$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$HexBinary$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$Int$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$Integer$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$Long$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$NonNegativeInteger$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$Short$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$String$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$Time$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$UnsignedByte$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$UnsignedInt$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$UnsignedLong$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$UnsignedShort$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.ControlThrowable;
import scala.util.matching.Regex;

public interface TypeChecks {
    public static BigDecimal dateToBigDecimal$(TypeChecks $this, String date, String format, String dateType, ThrowsSDE context) {
        return $this.dateToBigDecimal(date, format, dateType, context);
    }

    default public BigDecimal dateToBigDecimal(String date, String format, String dateType, ThrowsSDE context) {
        BigDecimal bigDecimal;
        SimpleDateFormat df = new SimpleDateFormat(format);
        df.setCalendar((Calendar)new GregorianCalendar());
        df.setTimeZone(TimeZone.GMT_ZONE);
        try {
            Date dt = df.parse(date);
            bigDecimal = new BigDecimal(dt.getTime());
        }
        catch (ControlThrowable s) {
            throw s;
        }
        catch (UnsuppressableException u) {
            throw u;
        }
        catch (Exception e1) {
            try {
                bigDecimal = new BigDecimal(date);
            }
            catch (ControlThrowable s) {
                throw s;
            }
            catch (UnsuppressableException u) {
                throw u;
            }
            catch (Exception e2) {
                throw context.SDE("Failed to parse (%s) to %s (%s) due to %s (after %s).", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{date, dateType, format, e2.getMessage(), e1.getMessage()}));
            }
        }
        BigDecimal bd = bigDecimal;
        return bd;
    }

    private BigDecimal convertStringToBigDecimal(String value, NodeInfo.PrimType primType, ThrowsSDE context) {
        NodeInfo.PrimType primType2 = primType;
        if (NodeInfo$PrimType$DateTime$.MODULE$.equals(primType2)) {
            return this.dateToBigDecimal(value, "uuuu-MM-dd'T'HH:mm:ss.SSSSSSxxx", NodeInfo$PrimType$DateTime$.MODULE$.toString(), context);
        }
        if (NodeInfo$PrimType$Date$.MODULE$.equals(primType2)) {
            return this.dateToBigDecimal(value, "uuuu-MM-ddxxx", NodeInfo$PrimType$Date$.MODULE$.toString(), context);
        }
        if (NodeInfo$PrimType$Time$.MODULE$.equals(primType2)) {
            return this.dateToBigDecimal(value, "HH:mm:ss.SSSSSSxxx", NodeInfo$PrimType$Time$.MODULE$.toString(), context);
        }
        return new BigDecimal(value);
    }

    public static Tuple2 checkRangeReturnsValue$(TypeChecks $this, String value, NodeInfo.PrimType primType, ThrowsSDE theContext) {
        return $this.checkRangeReturnsValue(value, primType, theContext);
    }

    default public Tuple2<Object, Option<BigDecimal>> checkRangeReturnsValue(String value, NodeInfo.PrimType primType, ThrowsSDE theContext) {
        if (value == null | value.length() == 0) {
            NodeInfo.PrimType primType2 = primType;
            if (NodeInfo$PrimType$HexBinary$.MODULE$.equals(primType2) || NodeInfo$PrimType$String$.MODULE$.equals(primType2)) {
                return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$);
            }
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)None$.MODULE$);
        }
        NodeInfo.PrimType primType3 = primType;
        if (NodeInfo$PrimType$String$.MODULE$.equals(primType3) || NodeInfo$PrimType$HexBinary$.MODULE$.equals(primType3) || NodeInfo$PrimType$AnyURI$.MODULE$.equals(primType3)) {
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$);
        }
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)value.toLowerCase(), (Object)primType);
        if (tuple2 != null) {
            boolean bl;
            List list;
            Option option;
            boolean bl2;
            String string = (String)tuple2._1();
            NodeInfo.PrimType primType4 = (NodeInfo.PrimType)tuple2._2();
            if ("true".equals(string) && NodeInfo$PrimType$Boolean$.MODULE$.equals(primType4)) {
                return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)Some$.MODULE$.apply((Object)BigDecimal.ONE));
            }
            if ("false".equals(string) && NodeInfo$PrimType$Boolean$.MODULE$.equals(primType4)) {
                return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)Some$.MODULE$.apply((Object)BigDecimal.ZERO));
            }
            String x = string;
            if (NodeInfo$PrimType$Boolean$.MODULE$.equals(primType4)) {
                throw theContext.SDE("%s is not a valid Boolean value. Expected 'true' or 'false'.", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{x}));
            }
            BigDecimal theValue = this.convertStringToBigDecimal(value, primType, theContext);
            NodeInfo.PrimType primType5 = primType;
            if (NodeInfo$PrimType$Int$.MODULE$.equals(primType5)) {
                bl2 = this.isInIntRange(theValue);
            } else if (NodeInfo$PrimType$Byte$.MODULE$.equals(primType5)) {
                bl2 = this.isInByteRange(theValue);
            } else if (NodeInfo$PrimType$Short$.MODULE$.equals(primType5)) {
                bl2 = this.isInShortRange(theValue);
            } else if (NodeInfo$PrimType$Long$.MODULE$.equals(primType5)) {
                bl2 = this.isInLongRange(theValue);
            } else if (NodeInfo$PrimType$Integer$.MODULE$.equals(primType5)) {
                bl2 = true;
            } else if (NodeInfo$PrimType$UnsignedInt$.MODULE$.equals(primType5)) {
                bl2 = this.isInUnsignedIntRange(theValue);
            } else if (NodeInfo$PrimType$UnsignedByte$.MODULE$.equals(primType5)) {
                bl2 = this.isInUnsignedByteRange(theValue);
            } else if (NodeInfo$PrimType$UnsignedShort$.MODULE$.equals(primType5)) {
                bl2 = this.isInUnsignedShortRange(theValue);
            } else if (NodeInfo$PrimType$UnsignedLong$.MODULE$.equals(primType5)) {
                bl2 = this.isInUnsignedLongRange(theValue);
            } else if (NodeInfo$PrimType$Double$.MODULE$.equals(primType5)) {
                bl2 = this.isInDoubleRange(theValue);
            } else if (NodeInfo$PrimType$Float$.MODULE$.equals(primType5)) {
                bl2 = this.isInFloatRange(theValue);
            } else if (NodeInfo$PrimType$DateTime$.MODULE$.equals(primType5)) {
                bl2 = true;
            } else if (NodeInfo$PrimType$Date$.MODULE$.equals(primType5)) {
                bl2 = true;
            } else if (NodeInfo$PrimType$Time$.MODULE$.equals(primType5)) {
                bl2 = true;
            } else {
                if (NodeInfo$PrimType$Boolean$.MODULE$.equals(primType5)) {
                    throw Assert$.MODULE$.impossibleCase();
                }
                if (NodeInfo$PrimType$Decimal$.MODULE$.equals(primType5)) {
                    bl2 = true;
                } else {
                    if (NodeInfo$PrimType$HexBinary$.MODULE$.equals(primType5)) {
                        throw Assert$.MODULE$.impossibleCase();
                    }
                    if (NodeInfo$PrimType$String$.MODULE$.equals(primType5)) {
                        throw Assert$.MODULE$.impossibleCase();
                    }
                    if (NodeInfo$PrimType$AnyURI$.MODULE$.equals(primType5)) {
                        throw Assert$.MODULE$.impossibleCase();
                    }
                    if (NodeInfo$PrimType$NonNegativeInteger$.MODULE$.equals(primType5)) {
                        bl2 = this.isInNonNegativeIntegerRange(theValue);
                    } else {
                        throw new MatchError((Object)primType5);
                    }
                }
            }
            boolean res = bl2;
            Regex IsWholeRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^[^.]*(\\.0*)?$"));
            String string2 = value;
            if (string2 != null && !(option = IsWholeRegex.unapplySeq((CharSequence)string2)).isEmpty() && (list = (List)option.get()).lengthCompare(1) == 0) {
                String string3 = (String)list.apply(0);
                bl = true;
            } else {
                bl = false;
            }
            boolean isValueWhole = bl;
            NodeInfo.PrimType primType6 = primType;
            if (NodeInfo$PrimType$Int$.MODULE$.equals(primType6) || NodeInfo$PrimType$Byte$.MODULE$.equals(primType6) || NodeInfo$PrimType$Short$.MODULE$.equals(primType6) || NodeInfo$PrimType$Long$.MODULE$.equals(primType6) || NodeInfo$PrimType$Integer$.MODULE$.equals(primType6) || NodeInfo$PrimType$UnsignedInt$.MODULE$.equals(primType6) || NodeInfo$PrimType$UnsignedByte$.MODULE$.equals(primType6) || NodeInfo$PrimType$UnsignedShort$.MODULE$.equals(primType6) || NodeInfo$PrimType$UnsignedLong$.MODULE$.equals(primType6)) {
                if (!isValueWhole) {
                    throw theContext.SDE("checkRange - Value (%s) must be a whole number.", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{value}));
                }
            }
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)res), (Object)Some$.MODULE$.apply((Object)theValue));
        }
        throw new MatchError((Object)tuple2);
    }

    public static boolean checkRange$(TypeChecks $this, String value, NodeInfo.PrimType primType, ThrowsSDE theContext) {
        return $this.checkRange(value, primType, theContext);
    }

    default public boolean checkRange(String value, NodeInfo.PrimType primType, ThrowsSDE theContext) {
        Tuple2<Object, Option<BigDecimal>> tuple2 = this.checkRangeReturnsValue(value, primType, theContext);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        boolean boolResult = BoxesRunTime.unboxToBoolean((Object)tuple2._1());
        boolean boolResult2 = boolResult;
        return boolResult2;
    }

    public static boolean isNumInRange$(TypeChecks $this, BigDecimal num, BigDecimal min, BigDecimal max) {
        return $this.isNumInRange(num, min, max);
    }

    default public boolean isNumInRange(BigDecimal num, BigDecimal min, BigDecimal max) {
        int checkMin = num.compareTo(min);
        if (checkMin < 0) {
            return false;
        }
        int checkMax = num.compareTo(max);
        return checkMax <= 0;
    }

    public static boolean isInByteRange$(TypeChecks $this, BigDecimal value) {
        return $this.isInByteRange(value);
    }

    default public boolean isInByteRange(BigDecimal value) {
        BigDecimal min = new BigDecimal(BoxesRunTime.boxToLong((long)-128).toString());
        BigDecimal max = new BigDecimal(BoxesRunTime.boxToLong((long)127).toString());
        return this.isNumInRange(value, min, max);
    }

    public static boolean isInShortRange$(TypeChecks $this, BigDecimal value) {
        return $this.isInShortRange(value);
    }

    default public boolean isInShortRange(BigDecimal value) {
        BigDecimal min = new BigDecimal(BoxesRunTime.boxToLong((long)Short.MIN_VALUE).toString());
        BigDecimal max = new BigDecimal(BoxesRunTime.boxToLong((long)Short.MAX_VALUE).toString());
        return this.isNumInRange(value, min, max);
    }

    public static boolean isInIntRange$(TypeChecks $this, BigDecimal value) {
        return $this.isInIntRange(value);
    }

    default public boolean isInIntRange(BigDecimal value) {
        BigDecimal min = new BigDecimal(BoxesRunTime.boxToInteger((int)Integer.MIN_VALUE).toString());
        BigDecimal max = new BigDecimal(BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE).toString());
        return this.isNumInRange(value, min, max);
    }

    public static boolean isInIntegerRange$(TypeChecks $this, BigDecimal value) {
        return $this.isInIntegerRange(value);
    }

    default public boolean isInIntegerRange(BigDecimal value) {
        BigDecimal min = new BigDecimal(BoxesRunTime.boxToInteger((int)Integer.MIN_VALUE).toString());
        int checkMin = value.compareTo(min);
        return checkMin >= 0;
    }

    public static boolean isInLongRange$(TypeChecks $this, BigDecimal value) {
        return $this.isInLongRange(value);
    }

    default public boolean isInLongRange(BigDecimal value) {
        BigDecimal min = new BigDecimal(BoxesRunTime.boxToLong((long)Long.MIN_VALUE).toString());
        BigDecimal max = new BigDecimal(BoxesRunTime.boxToLong((long)Long.MAX_VALUE).toString());
        return this.isNumInRange(value, min, max);
    }

    public static boolean isInDoubleRange$(TypeChecks $this, BigDecimal value) {
        return $this.isInDoubleRange(value);
    }

    default public boolean isInDoubleRange(BigDecimal value) {
        BigDecimal min = new BigDecimal(BoxesRunTime.boxToDouble((double)-1.7976931348623157E308).toString());
        BigDecimal max = new BigDecimal(BoxesRunTime.boxToDouble((double)Double.MAX_VALUE).toString());
        return this.isNumInRange(value, min, max);
    }

    public static boolean isInFloatRange$(TypeChecks $this, BigDecimal value) {
        return $this.isInFloatRange(value);
    }

    default public boolean isInFloatRange(BigDecimal value) {
        BigDecimal min = new BigDecimal(BoxesRunTime.boxToFloat((float)-3.4028235E38f).toString());
        BigDecimal max = new BigDecimal(BoxesRunTime.boxToFloat((float)Float.MAX_VALUE).toString());
        return this.isNumInRange(value, min, max);
    }

    public static boolean isInDecimalRange$(TypeChecks $this, BigDecimal value) {
        return $this.isInDecimalRange(value);
    }

    default public boolean isInDecimalRange(BigDecimal value) {
        return true;
    }

    public static boolean isInNegativeIntegerRange$(TypeChecks $this, BigDecimal value, ThrowsSDE context) {
        return $this.isInNegativeIntegerRange(value, context);
    }

    default public boolean isInNegativeIntegerRange(BigDecimal value, ThrowsSDE context) {
        boolean isNegative;
        BigDecimal min = new BigDecimal(BoxesRunTime.boxToInteger((int)Integer.MIN_VALUE).toString());
        boolean bl = isNegative = value.signum() == -1;
        if (!isNegative) {
            throw context.SDE("Expected a negative integer for this value.", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        int checkMin = value.compareTo(min);
        if (checkMin < 0) {
            throw context.SDE("Value (%s) was found to be more negative than allowed by Int.MinValue.", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)value.intValue())}));
        }
        return true;
    }

    public static boolean isInNonNegativeIntegerRange$(TypeChecks $this, BigDecimal value) {
        return $this.isInNonNegativeIntegerRange(value);
    }

    default public boolean isInNonNegativeIntegerRange(BigDecimal value) {
        boolean isNegative;
        boolean bl = isNegative = value.signum() == -1;
        return !isNegative;
    }

    public static boolean isInUnsignedXXXRange$(TypeChecks $this, BigDecimal value, int numBits, String typeName) {
        return $this.isInUnsignedXXXRange(value, numBits, typeName);
    }

    default public boolean isInUnsignedXXXRange(BigDecimal value, int numBits, String typeName) {
        boolean isNegative;
        if (numBits > 64) {
            throw Assert$.MODULE$.usageError2("isInUnsignedXXXRange: numBits must be <= 64.", "numBits.<=(64)");
        }
        BigDecimal max = new BigDecimal(BigInteger.ONE.shiftLeft(numBits)).subtract(new BigDecimal(1));
        boolean bl = isNegative = value.signum() == -1;
        if (isNegative) {
            return false;
        }
        int checkMax = value.compareTo(max);
        return checkMax <= 0;
    }

    public static boolean isInUnsignedLongRange$(TypeChecks $this, BigDecimal value) {
        return $this.isInUnsignedLongRange(value);
    }

    default public boolean isInUnsignedLongRange(BigDecimal value) {
        return this.isInUnsignedXXXRange(value, 64, "ulong");
    }

    public static boolean isInUnsignedIntRange$(TypeChecks $this, BigDecimal value) {
        return $this.isInUnsignedIntRange(value);
    }

    default public boolean isInUnsignedIntRange(BigDecimal value) {
        return this.isInUnsignedXXXRange(value, 32, "uint");
    }

    public static boolean isInUnsignedShortRange$(TypeChecks $this, BigDecimal value) {
        return $this.isInUnsignedShortRange(value);
    }

    default public boolean isInUnsignedShortRange(BigDecimal value) {
        return this.isInUnsignedXXXRange(value, 16, "ushort");
    }

    public static boolean isInUnsignedByteRange$(TypeChecks $this, BigDecimal value) {
        return $this.isInUnsignedByteRange(value);
    }

    default public boolean isInUnsignedByteRange(BigDecimal value) {
        return this.isInUnsignedXXXRange(value, 8, "ubyte");
    }
}

