/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.jetty9;

import java.security.Principal;
import java.time.Instant;
import java.util.Arrays;
import javax.security.auth.Subject;
import org.apache.cxf.fediz.core.processor.FedizResponse;
import org.eclipse.jetty.server.UserIdentity;
import org.w3c.dom.Element;

public class FederationUserIdentity
implements UserIdentity {
    private Subject subject;
    private Principal principal;
    private String[] roles;
    private FedizResponse fedResponse;

    public FederationUserIdentity(Subject subject, Principal principal, String[] roles, FedizResponse fedResponse) {
        this.subject = subject;
        this.principal = principal;
        if (roles != null) {
            this.roles = Arrays.copyOf(roles, roles.length);
        }
        this.fedResponse = fedResponse;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public boolean isUserInRole(String role, UserIdentity.Scope scope) {
        if (scope != null && scope.getRoleRefMap() != null) {
            role = (String)scope.getRoleRefMap().get(role);
        }
        if (this.roles != null) {
            for (String r : this.roles) {
                if (!r.equals(role)) continue;
                return true;
            }
        }
        return false;
    }

    public Instant getExpiryDate() {
        return this.fedResponse.getTokenExpires();
    }

    public String getIssuer() {
        return this.fedResponse.getIssuer();
    }

    public String getAudience() {
        return this.fedResponse.getAudience();
    }

    public String getId() {
        return this.fedResponse.getUniqueTokenId();
    }

    public Element getToken() {
        return this.fedResponse.getToken();
    }
}

