/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.handler;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.cxf.fediz.core.spi.RealmCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealmCallbackHandler
implements CallbackHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RealmCallbackHandler.class);

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof RealmCallback) {
                RealmCallback callback = (RealmCallback)callbacks[i];
                String param = "wtrealm";
                String wtRealm = (String)callback.getRequest().getAttribute(param);
                if (wtRealm == null || wtRealm.length() == 0) {
                    LOG.debug("No wtrealm found in request");
                    continue;
                }
                LOG.info("WTRealm '" + wtRealm + "' found in request");
                callback.setRealm(wtRealm);
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
        }
    }
}

