/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Objects;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.utils.XidCodecSupport;

public class SessionXARollbackMessage
extends PacketImpl {
    private Xid xid;

    public SessionXARollbackMessage(Xid xid) {
        super((byte)56);
        this.xid = xid;
    }

    public SessionXARollbackMessage() {
        super((byte)56);
    }

    public Xid getXid() {
        return this.xid;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        XidCodecSupport.encodeXid(this.xid, buffer);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.xid = XidCodecSupport.decodeXid(buffer);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hashCode(this.xid);
    }

    @Override
    protected String getPacketString() {
        StringBuilder sb = new StringBuilder(super.getPacketString());
        sb.append(", xid=" + String.valueOf(this.xid));
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionXARollbackMessage)) {
            return false;
        }
        SessionXARollbackMessage other = (SessionXARollbackMessage)obj;
        return Objects.equals(this.xid, other.xid);
    }
}

