/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.operation;

import jakarta.xml.bind.JAXBElement;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.sts.QNameConstants;
import org.apache.cxf.sts.RealmParser;
import org.apache.cxf.sts.event.STSRenewFailureEvent;
import org.apache.cxf.sts.event.STSRenewSuccessEvent;
import org.apache.cxf.sts.operation.AbstractOperation;
import org.apache.cxf.sts.request.KeyRequirements;
import org.apache.cxf.sts.request.ReceivedToken;
import org.apache.cxf.sts.request.RequestRequirements;
import org.apache.cxf.sts.request.TokenRequirements;
import org.apache.cxf.sts.service.EncryptionProperties;
import org.apache.cxf.sts.token.provider.TokenProviderParameters;
import org.apache.cxf.sts.token.provider.TokenReference;
import org.apache.cxf.sts.token.renewer.TokenRenewer;
import org.apache.cxf.sts.token.renewer.TokenRenewerParameters;
import org.apache.cxf.sts.token.renewer.TokenRenewerResponse;
import org.apache.cxf.sts.token.validator.TokenValidatorResponse;
import org.apache.cxf.ws.security.sts.provider.STSException;
import org.apache.cxf.ws.security.sts.provider.model.LifetimeType;
import org.apache.cxf.ws.security.sts.provider.model.RequestSecurityTokenResponseType;
import org.apache.cxf.ws.security.sts.provider.model.RequestSecurityTokenType;
import org.apache.cxf.ws.security.sts.provider.model.RequestedReferenceType;
import org.apache.cxf.ws.security.sts.provider.model.RequestedSecurityTokenType;
import org.apache.cxf.ws.security.sts.provider.operation.RenewOperation;
import org.apache.wss4j.common.ext.WSSecurityException;

public class TokenRenewOperation
extends AbstractOperation
implements RenewOperation {
    private static final Logger LOG = LogUtils.getL7dLogger(TokenRenewOperation.class);
    private List<TokenRenewer> tokenRenewers = new ArrayList<TokenRenewer>();

    public void setTokenRenewers(List<TokenRenewer> tokenRenewerList) {
        this.tokenRenewers = tokenRenewerList;
    }

    public List<TokenRenewer> getTokenRenewers() {
        return this.tokenRenewers;
    }

    public RequestSecurityTokenResponseType renew(RequestSecurityTokenType request, Principal principal, Map<String, Object> messageContext) {
        long start = System.currentTimeMillis();
        TokenRenewerParameters renewerParameters = new TokenRenewerParameters();
        try {
            RequestRequirements requestRequirements = this.parseRequest(request, messageContext);
            KeyRequirements keyRequirements = requestRequirements.getKeyRequirements();
            TokenRequirements tokenRequirements = requestRequirements.getTokenRequirements();
            renewerParameters.setStsProperties(this.stsProperties);
            renewerParameters.setPrincipal(principal);
            renewerParameters.setMessageContext(messageContext);
            renewerParameters.setTokenStore(this.getTokenStore());
            renewerParameters.setKeyRequirements(keyRequirements);
            renewerParameters.setTokenRequirements(tokenRequirements);
            ReceivedToken renewTarget = tokenRequirements.getRenewTarget();
            if (renewTarget == null || renewTarget.getToken() == null) {
                throw new STSException("No element presented for renewal", STSException.INVALID_REQUEST);
            }
            renewerParameters.setToken(renewTarget);
            if (tokenRequirements.getTokenType() == null) {
                LOG.fine("Received TokenType is null");
            }
            String realm = null;
            if (this.stsProperties.getRealmParser() != null) {
                RealmParser realmParser = this.stsProperties.getRealmParser();
                realm = realmParser.parseRealm(messageContext);
            }
            renewerParameters.setRealm(realm);
            TokenValidatorResponse tokenResponse = this.validateReceivedToken(principal, messageContext, realm, tokenRequirements, renewTarget);
            if (tokenResponse == null) {
                LOG.fine("No Token Validator has been found that can handle this token");
                renewTarget.setState(ReceivedToken.STATE.INVALID);
                throw new STSException("No Token Validator has been found that can handle this token" + tokenRequirements.getTokenType(), STSException.REQUEST_FAILED);
            }
            if (tokenResponse.getToken().getState() != ReceivedToken.STATE.EXPIRED && tokenResponse.getToken().getState() != ReceivedToken.STATE.VALID) {
                LOG.fine("The token is not valid or expired, and so it cannot be renewed");
                throw new STSException("No Token Validator has been found that can handle this token" + tokenRequirements.getTokenType(), STSException.REQUEST_FAILED);
            }
            TokenRenewerResponse tokenRenewerResponse = null;
            renewerParameters = this.createTokenRenewerParameters(requestRequirements, principal, messageContext);
            Map<String, Object> additionalProperties = tokenResponse.getAdditionalProperties();
            if (additionalProperties != null) {
                renewerParameters.setAdditionalProperties(additionalProperties);
            }
            renewerParameters.setRealm(tokenResponse.getTokenRealm());
            renewerParameters.setToken(tokenResponse.getToken());
            realm = tokenResponse.getTokenRealm();
            for (TokenRenewer tokenRenewer : this.tokenRenewers) {
                boolean canHandle = realm == null ? tokenRenewer.canHandleToken(tokenResponse.getToken()) : tokenRenewer.canHandleToken(tokenResponse.getToken(), realm);
                if (!canHandle) continue;
                try {
                    tokenRenewerResponse = tokenRenewer.renewToken(renewerParameters);
                    break;
                }
                catch (STSException ex) {
                    LOG.log(Level.WARNING, "", ex);
                    throw ex;
                }
                catch (RuntimeException ex) {
                    LOG.log(Level.WARNING, "", ex);
                    throw new STSException("Error in providing a token", (Throwable)ex, STSException.REQUEST_FAILED);
                }
            }
            if (tokenRenewerResponse == null || tokenRenewerResponse.getToken() == null) {
                LOG.fine("No Token Renewer has been found that can handle this token");
                throw new STSException("No token renewer found for requested token type", STSException.REQUEST_FAILED);
            }
            try {
                EncryptionProperties encryptionProperties = renewerParameters.getEncryptionProperties();
                RequestSecurityTokenResponseType response = this.createResponse(encryptionProperties, tokenRenewerResponse, tokenRequirements, keyRequirements);
                STSRenewSuccessEvent event = new STSRenewSuccessEvent(renewerParameters, System.currentTimeMillis() - start);
                this.publishEvent(event);
                this.cleanRequest(requestRequirements);
                return response;
            }
            catch (Throwable ex) {
                LOG.log(Level.WARNING, "", ex);
                throw new STSException("Error in creating the response", ex, STSException.REQUEST_FAILED);
            }
        }
        catch (RuntimeException ex) {
            STSRenewFailureEvent event = new STSRenewFailureEvent(renewerParameters, System.currentTimeMillis() - start, (Exception)ex);
            this.publishEvent(event);
            throw ex;
        }
    }

    protected RequestSecurityTokenResponseType createResponse(EncryptionProperties encryptionProperties, TokenRenewerResponse tokenRenewerResponse, TokenRequirements tokenRequirements, KeyRequirements keyRequirements) throws WSSecurityException {
        RequestSecurityTokenResponseType response = QNameConstants.WS_TRUST_FACTORY.createRequestSecurityTokenResponseType();
        String context = tokenRequirements.getContext();
        if (context != null) {
            response.setContext(context);
        }
        JAXBElement jaxbTokenType = QNameConstants.WS_TRUST_FACTORY.createTokenType(tokenRequirements.getTokenType());
        response.getAny().add(jaxbTokenType);
        RequestedSecurityTokenType requestedTokenType = QNameConstants.WS_TRUST_FACTORY.createRequestedSecurityTokenType();
        JAXBElement requestedToken = QNameConstants.WS_TRUST_FACTORY.createRequestedSecurityToken(requestedTokenType);
        LOG.fine("Encrypting Issued Token: " + this.encryptIssuedToken);
        requestedTokenType.setAny((Object)tokenRenewerResponse.getToken());
        response.getAny().add(requestedToken);
        if (this.returnReferences) {
            TokenReference attachedReference = tokenRenewerResponse.getAttachedReference();
            RequestedReferenceType requestedAttachedReferenceType = attachedReference != null ? TokenRenewOperation.createRequestedReference(attachedReference, true) : TokenRenewOperation.createRequestedReference(tokenRenewerResponse.getTokenId(), tokenRequirements.getTokenType(), true);
            JAXBElement requestedAttachedReference = QNameConstants.WS_TRUST_FACTORY.createRequestedAttachedReference(requestedAttachedReferenceType);
            response.getAny().add(requestedAttachedReference);
            TokenReference unAttachedReference = tokenRenewerResponse.getUnAttachedReference();
            RequestedReferenceType requestedUnattachedReferenceType = unAttachedReference != null ? TokenRenewOperation.createRequestedReference(unAttachedReference, false) : TokenRenewOperation.createRequestedReference(tokenRenewerResponse.getTokenId(), tokenRequirements.getTokenType(), false);
            JAXBElement requestedUnattachedReference = QNameConstants.WS_TRUST_FACTORY.createRequestedUnattachedReference(requestedUnattachedReferenceType);
            response.getAny().add(requestedUnattachedReference);
        }
        response.getAny().add(tokenRequirements.getAppliesTo());
        if (this.includeLifetimeElement) {
            LifetimeType lifetime = TokenRenewOperation.createLifetime(tokenRenewerResponse.getCreated(), tokenRenewerResponse.getExpires());
            JAXBElement lifetimeType = QNameConstants.WS_TRUST_FACTORY.createLifetime(lifetime);
            response.getAny().add(lifetimeType);
        }
        return response;
    }

    private TokenRenewerParameters createTokenRenewerParameters(RequestRequirements requestRequirements, Principal principal, Map<String, Object> messageContext) {
        TokenProviderParameters providerParameters = this.createTokenProviderParameters(requestRequirements, principal, messageContext);
        TokenRenewerParameters renewerParameters = new TokenRenewerParameters();
        renewerParameters.setAppliesToAddress(providerParameters.getAppliesToAddress());
        renewerParameters.setEncryptionProperties(providerParameters.getEncryptionProperties());
        renewerParameters.setKeyRequirements(providerParameters.getKeyRequirements());
        renewerParameters.setPrincipal(providerParameters.getPrincipal());
        renewerParameters.setStsProperties(providerParameters.getStsProperties());
        renewerParameters.setTokenRequirements(providerParameters.getTokenRequirements());
        renewerParameters.setTokenStore(providerParameters.getTokenStore());
        renewerParameters.setMessageContext(providerParameters.getMessageContext());
        return renewerParameters;
    }
}

