/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsVerificationSignature;

public class NoneJwsSignatureVerifier
implements JwsSignatureVerifier {
    @Override
    public boolean verify(JwsHeaders headers, String unsignedText, byte[] signature) {
        return headers.getSignatureAlgorithm() == this.getAlgorithm() && signature.length == 0;
    }

    @Override
    public SignatureAlgorithm getAlgorithm() {
        return SignatureAlgorithm.NONE;
    }

    @Override
    public JwsVerificationSignature createJwsVerificationSignature(JwsHeaders headers) {
        return new NoneJwsVerificationSignature();
    }

    private static final class NoneJwsVerificationSignature
    implements JwsVerificationSignature {
        private NoneJwsVerificationSignature() {
        }

        @Override
        public void update(byte[] src, int off, int len) {
        }

        @Override
        public boolean verify(byte[] signature) {
            return signature.length == 0;
        }
    }
}

