/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.encryption.keys.content.derivedKey;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.util.ArrayList;
import org.apache.xml.security.algorithms.MessageDigestAlgorithm;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xml.security.encryption.keys.content.derivedKey.DerivationAlgorithm;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcatKDF
implements DerivationAlgorithm {
    private static final Logger LOG = LoggerFactory.getLogger((String)ConcatKDF.class.getName());
    private final String algorithmURI;

    public ConcatKDF(String algorithmURI) {
        this.algorithmURI = algorithmURI;
    }

    public ConcatKDF() {
        this("http://www.w3.org/2001/04/xmlenc#sha256");
    }

    @Override
    public byte[] deriveKey(byte[] secret, byte[] otherInfo, int offset, long keyLength) throws XMLSecurityException {
        int toGenerateSize;
        long genKeyLength = (long)offset + keyLength;
        MessageDigest digest = MessageDigestAlgorithm.getDigestInstance(this.algorithmURI);
        int iDigestLength = digest.getDigestLength();
        if (genKeyLength / (long)iDigestLength > Integer.MAX_VALUE) {
            LOG.error("Key size is to long to be derived with hash algorithm [{0}]", (Object)this.algorithmURI);
            throw new XMLEncryptionException("errorInKeyDerivation");
        }
        digest.reset();
        ByteBuffer indexBuffer = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN);
        ByteBuffer result = ByteBuffer.allocate(toGenerateSize);
        int counter = 1;
        for (toGenerateSize = (int)genKeyLength; toGenerateSize > 0; toGenerateSize -= iDigestLength) {
            indexBuffer.position(0);
            indexBuffer.putInt(counter++);
            indexBuffer.position(0);
            digest.update(indexBuffer);
            digest.update(secret);
            if (otherInfo != null && otherInfo.length > 0) {
                digest.update(otherInfo);
            }
            result.put(digest.digest(), 0, Math.min(toGenerateSize, iDigestLength));
        }
        if (offset > 0) {
            result.position(offset);
            return result.slice().array();
        }
        return result.array();
    }

    public byte[] deriveKey(byte[] sharedSecret, String algID, String partyUInfo, String partyVInfo, String suppPubInfo, String suppPrivInfo, long keyLength) throws XMLSecurityException {
        byte[] otherInfo = ConcatKDF.concatParameters(algID, partyUInfo, partyVInfo, suppPubInfo, suppPrivInfo);
        return this.deriveKey(sharedSecret, otherInfo, keyLength);
    }

    private static byte[] concatParameters(String ... parameters) throws XMLEncryptionException {
        ArrayList<byte[]> byteParams = new ArrayList<byte[]>();
        for (String parameter : parameters) {
            byte[] bytes = ConcatKDF.parseBitString(parameter);
            byteParams.add(bytes);
        }
        int iSize = byteParams.stream().map(ConcatKDF::getSize).reduce(0, Integer::sum);
        ByteBuffer buffer = ByteBuffer.allocate(iSize);
        byteParams.forEach(buffer::put);
        return buffer.array();
    }

    private static byte[] parseBitString(String kdfParameter) throws XMLEncryptionException {
        int iPadding;
        if (kdfParameter == null || kdfParameter.isEmpty()) {
            return new byte[0];
        }
        String kdfP = kdfParameter.trim();
        int paramLen = kdfP.length();
        if (paramLen < 4) {
            LOG.error("ConcatKDF parameter is to short");
            throw new XMLEncryptionException("KeyDerivation.TooShortParameter", kdfParameter);
        }
        if (paramLen % 2 != 0) {
            LOG.error("Invalid length of ConcatKDF parameter [{0}]!", (Object)kdfP);
            throw new XMLEncryptionException("KeyDerivation.InvalidParameter", kdfParameter);
        }
        String strPadding = kdfP.substring(0, 2);
        try {
            iPadding = Integer.parseInt(strPadding, 16);
        }
        catch (NumberFormatException e) {
            LOG.error("Invalid padding number: [{0}]! Number is not Hexadecimal!", (Object)strPadding);
            throw new XMLEncryptionException(e, "KeyDerivation.InvalidParameter", new Object[]{kdfParameter});
        }
        if (iPadding != 0) {
            LOG.error("Padded ConcatKDF parameters are not supported");
            throw new XMLEncryptionException("KeyDerivation.NotSupportedParameter", kdfParameter);
        }
        kdfP = kdfP.substring(2);
        paramLen = kdfP.length();
        byte[] data = new byte[paramLen / 2];
        for (int i = 0; i < paramLen; i += 2) {
            data[i / 2] = (byte)((Character.digit(kdfP.charAt(i), 16) << 4) + Character.digit(kdfP.charAt(i + 1), 16));
        }
        return data;
    }

    private static int getSize(byte[] array) {
        return array == null ? 0 : array.length;
    }
}

