/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba.types;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.corba.CorbaTypeMap;
import org.apache.cxf.binding.corba.types.AbstractCorbaTypeListener;
import org.apache.cxf.binding.corba.types.CorbaExceptionHandler;
import org.apache.cxf.binding.corba.types.CorbaHandlerUtils;
import org.apache.cxf.binding.corba.types.CorbaObjectHandler;
import org.apache.cxf.binding.corba.types.CorbaTypeListener;
import org.apache.cxf.binding.corba.wsdl.Exception;
import org.apache.cxf.binding.corba.wsdl.MemberType;
import org.apache.cxf.service.model.ServiceInfo;
import org.omg.CORBA.ORB;

public class CorbaExceptionListener
extends AbstractCorbaTypeListener {
    private final CorbaTypeMap typeMap;
    private final ORB orb;
    private final List<MemberType> exMembers;
    private int memberCount;
    private CorbaTypeListener currentTypeListener;
    private QName memberElement;
    private ServiceInfo sInfo;

    public CorbaExceptionListener(CorbaObjectHandler handler, CorbaTypeMap map, ORB orbRef, ServiceInfo serviceInfo) {
        super(handler);
        this.orb = orbRef;
        this.typeMap = map;
        this.sInfo = serviceInfo;
        this.exMembers = ((Exception)handler.getType()).getMember();
    }

    @Override
    public void processStartElement(QName name) {
        if (this.currentTypeListener == null) {
            this.memberElement = name;
            this.currentTypeListener = CorbaHandlerUtils.getTypeListener(name, this.exMembers.get(this.memberCount).getIdltype(), this.typeMap, this.orb, this.sInfo);
            this.currentTypeListener.setNamespaceContext(this.ctx);
            ((CorbaExceptionHandler)this.handler).addMember(this.currentTypeListener.getCorbaObject());
            ++this.memberCount;
        } else {
            this.currentTypeListener.processStartElement(name);
        }
    }

    @Override
    public void processEndElement(QName name) {
        if (this.currentTypeListener != null) {
            this.currentTypeListener.processEndElement(name);
        }
        if (this.memberElement.equals(name)) {
            this.currentTypeListener = null;
        }
    }

    @Override
    public void processCharacters(String text) {
        this.currentTypeListener.processCharacters(text);
    }

    @Override
    public void processWriteAttribute(String prefix, String namespaceURI, String localName, String value) {
        if (this.currentTypeListener != null) {
            this.currentTypeListener.processWriteAttribute(prefix, namespaceURI, localName, value);
        }
    }

    @Override
    public void processWriteNamespace(String prefix, String namespaceURI) {
        if (this.currentTypeListener != null) {
            this.currentTypeListener.processWriteNamespace(prefix, namespaceURI);
        }
    }
}

