/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.report.claim;

import java.io.File;
import java.io.IOException;
import org.apache.rat.analysis.UnknownLicense;
import org.apache.rat.annotation.AbstractLicenseAppender;
import org.apache.rat.annotation.ApacheV2LicenseAppender;
import org.apache.rat.api.Document;
import org.apache.rat.api.RatException;
import org.apache.rat.report.RatReport;

public class LicenseAddingReport
implements RatReport {
    private final AbstractLicenseAppender appender;

    public LicenseAddingReport(String copyrightMsg, boolean overwrite) {
        this.appender = copyrightMsg == null ? new ApacheV2LicenseAppender() : new ApacheV2LicenseAppender(copyrightMsg);
        this.appender.setOverwrite(overwrite);
    }

    @Override
    public void report(Document document) throws RatException {
        File file;
        if (document.getMetaData().licenses().anyMatch(lic -> lic.equals(UnknownLicense.INSTANCE)) && (file = new File(document.getName().getName())).isFile()) {
            try {
                this.appender.append(file);
            }
            catch (IOException e) {
                throw new RatException(e.getMessage(), e);
            }
        }
    }
}

