/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.stat.descriptive.moment;

import org.apache.commons.math4.core.jdkmath.JdkMath;
import org.apache.commons.math4.legacy.exception.MathIllegalArgumentException;
import org.apache.commons.math4.legacy.exception.NullArgumentException;
import org.apache.commons.math4.legacy.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.apache.commons.math4.legacy.stat.descriptive.moment.SecondMoment;
import org.apache.commons.math4.legacy.stat.descriptive.moment.Variance;

public class StandardDeviation
extends AbstractStorelessUnivariateStatistic {
    private Variance variance;

    public StandardDeviation() {
        this.variance = new Variance();
    }

    public StandardDeviation(SecondMoment m2) {
        this.variance = new Variance(m2);
    }

    public StandardDeviation(StandardDeviation original) throws NullArgumentException {
        StandardDeviation.copy(original, this);
    }

    public StandardDeviation(boolean isBiasCorrected) {
        this.variance = new Variance(isBiasCorrected);
    }

    public StandardDeviation(boolean isBiasCorrected, SecondMoment m2) {
        this.variance = new Variance(isBiasCorrected, m2);
    }

    @Override
    public void increment(double d) {
        this.variance.increment(d);
    }

    @Override
    public long getN() {
        return this.variance.getN();
    }

    @Override
    public double getResult() {
        return JdkMath.sqrt((double)this.variance.getResult());
    }

    @Override
    public void clear() {
        this.variance.clear();
    }

    @Override
    public double evaluate(double[] values) throws MathIllegalArgumentException {
        return JdkMath.sqrt((double)this.variance.evaluate(values));
    }

    @Override
    public double evaluate(double[] values, int begin, int length) throws MathIllegalArgumentException {
        return JdkMath.sqrt((double)this.variance.evaluate(values, begin, length));
    }

    public double evaluate(double[] values, double mean, int begin, int length) throws MathIllegalArgumentException {
        return JdkMath.sqrt((double)this.variance.evaluate(values, mean, begin, length));
    }

    public double evaluate(double[] values, double mean) throws MathIllegalArgumentException {
        return JdkMath.sqrt((double)this.variance.evaluate(values, mean));
    }

    public boolean isBiasCorrected() {
        return this.variance.isBiasCorrected();
    }

    public void setBiasCorrected(boolean isBiasCorrected) {
        this.variance.setBiasCorrected(isBiasCorrected);
    }

    @Override
    public StandardDeviation copy() {
        StandardDeviation result = new StandardDeviation();
        StandardDeviation.copy(this, result);
        return result;
    }

    public static void copy(StandardDeviation source, StandardDeviation dest) throws NullArgumentException {
        NullArgumentException.check((Object)source);
        NullArgumentException.check((Object)dest);
        dest.variance = source.variance.copy();
    }
}

