/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode;

import java.lang.reflect.Array;
import org.apache.commons.math3.Field;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.ode.FieldODEState;
import org.apache.commons.math3.ode.FieldODEStateAndDerivative;
import org.apache.commons.math3.ode.TestFieldProblemAbstract;
import org.apache.commons.math3.ode.events.Action;
import org.apache.commons.math3.ode.events.FieldEventHandler;
import org.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestFieldProblem4<T extends RealFieldElement<T>>
extends TestFieldProblemAbstract<T> {
    private T a = this.convert(1.2);

    public TestFieldProblem4(Field<T> field) {
        super(field);
        RealFieldElement[] y0 = (RealFieldElement[])MathArrays.buildArray(field, (int)2);
        y0[0] = (RealFieldElement)this.a.sin();
        y0[1] = (RealFieldElement)this.a.cos();
        this.setInitialConditions((RealFieldElement)this.convert(0.0), y0);
        this.setFinalConditions(this.convert(15.0));
        this.setErrorScale(this.convert(new double[]{1.0, 0.0}));
    }

    @Override
    public FieldEventHandler<T>[] getEventsHandlers() {
        FieldEventHandler[] handlers = (FieldEventHandler[])Array.newInstance(FieldEventHandler.class, 2);
        handlers[0] = new Bounce();
        handlers[1] = new Stop();
        return handlers;
    }

    @Override
    public T[] getTheoreticalEventsTimes() {
        RealFieldElement[] array = (RealFieldElement[])MathArrays.buildArray(this.getField(), (int)5);
        array[0] = (RealFieldElement)((RealFieldElement)this.a.negate()).add(Math.PI);
        array[1] = (RealFieldElement)((RealFieldElement)this.a.negate()).add(Math.PI * 2);
        array[2] = (RealFieldElement)((RealFieldElement)this.a.negate()).add(Math.PI * 3);
        array[3] = (RealFieldElement)((RealFieldElement)this.a.negate()).add(Math.PI * 4);
        array[4] = this.convert(120.0);
        return array;
    }

    @Override
    public T[] doComputeDerivatives(T t, T[] y) {
        RealFieldElement[] yDot = (RealFieldElement[])MathArrays.buildArray(this.getField(), (int)this.getDimension());
        yDot[0] = y[1];
        yDot[1] = (RealFieldElement)y[0].negate();
        return yDot;
    }

    @Override
    public T[] computeTheoreticalState(T t) {
        RealFieldElement sin = (RealFieldElement)((RealFieldElement)t.add(this.a)).sin();
        RealFieldElement cos = (RealFieldElement)((RealFieldElement)t.add(this.a)).cos();
        RealFieldElement[] y = (RealFieldElement[])MathArrays.buildArray(this.getField(), (int)this.getDimension());
        y[0] = (RealFieldElement)sin.abs();
        y[1] = sin.getReal() >= 0.0 ? cos : (RealFieldElement)cos.negate();
        return y;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Stop<T extends RealFieldElement<T>>
    implements FieldEventHandler<T> {
        public void init(FieldODEStateAndDerivative<T> state0, T t) {
        }

        public T g(FieldODEStateAndDerivative<T> state) {
            return (T)((RealFieldElement)state.getTime().subtract(12.0));
        }

        public Action eventOccurred(FieldODEStateAndDerivative<T> state, boolean increasing) {
            return Action.STOP;
        }

        public FieldODEState<T> resetState(FieldODEStateAndDerivative<T> state) {
            return state;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Bounce<T extends RealFieldElement<T>>
    implements FieldEventHandler<T> {
        private int sign = 1;

        public void init(FieldODEStateAndDerivative<T> state0, T t) {
        }

        public T g(FieldODEStateAndDerivative<T> state) {
            return (T)((RealFieldElement)state.getState()[0].multiply(this.sign));
        }

        public Action eventOccurred(FieldODEStateAndDerivative<T> state, boolean increasing) {
            this.sign = -this.sign;
            return Action.RESET_STATE;
        }

        public FieldODEState<T> resetState(FieldODEStateAndDerivative<T> state) {
            RealFieldElement[] y = state.getState();
            y[0] = (RealFieldElement)y[0].negate();
            y[1] = (RealFieldElement)y[1].negate();
            return new FieldODEState(state.getTime(), y);
        }
    }
}

