/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.io.euclidean.threed.obj;

import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.function.DoubleFunction;
import java.util.stream.Stream;
import org.apache.commons.geometry.euclidean.threed.BoundarySource3D;
import org.apache.commons.geometry.euclidean.threed.PlaneConvexSubset;
import org.apache.commons.geometry.euclidean.threed.mesh.Mesh;
import org.apache.commons.geometry.io.core.GeometryFormat;
import org.apache.commons.geometry.io.core.internal.GeometryIOUtils;
import org.apache.commons.geometry.io.core.output.GeometryOutput;
import org.apache.commons.geometry.io.euclidean.threed.AbstractBoundaryWriteHandler3D;
import org.apache.commons.geometry.io.euclidean.threed.FacetDefinition;
import org.apache.commons.geometry.io.euclidean.threed.GeometryFormat3D;
import org.apache.commons.geometry.io.euclidean.threed.obj.ObjConstants;
import org.apache.commons.geometry.io.euclidean.threed.obj.ObjWriter;

public class ObjBoundaryWriteHandler3D
extends AbstractBoundaryWriteHandler3D {
    private static final String DEFAULT_LINE_SEPARATOR = "\n";
    private static final int DEFAULT_MESH_BUFFER_BATCH_SIZE = -1;
    private Charset defaultCharset = ObjConstants.DEFAULT_CHARSET;
    private String lineSeparator = "\n";
    private DoubleFunction<String> doubleFormat = Double::toString;
    private int meshBufferBatchSize = -1;

    public GeometryFormat getFormat() {
        return GeometryFormat3D.OBJ;
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    public void setDefaultCharset(Charset charset) {
        this.defaultCharset = charset;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public DoubleFunction<String> getDoubleFormat() {
        return this.doubleFormat;
    }

    public void setDoubleFormat(DoubleFunction<String> doubleFormat) {
        this.doubleFormat = doubleFormat;
    }

    public int getMeshBufferBatchSize() {
        return this.meshBufferBatchSize;
    }

    public void setMeshBufferBatchSize(int batchSize) {
        this.meshBufferBatchSize = batchSize;
    }

    @Override
    public void write(BoundarySource3D src, GeometryOutput out) {
        if (src instanceof Mesh) {
            try (ObjWriter writer = this.createWriter(out);){
                writer.writeMesh((Mesh)src);
            }
        } else {
            super.write(src, out);
        }
    }

    @Override
    public void write(Stream<? extends PlaneConvexSubset> boundaries, GeometryOutput out) {
        try (ObjWriter writer = this.createWriter(out);){
            ObjWriter.MeshBuffer meshBuffer = writer.meshBuffer(this.meshBufferBatchSize);
            Iterator it = boundaries.iterator();
            while (it.hasNext()) {
                meshBuffer.add((PlaneConvexSubset)it.next());
            }
            meshBuffer.flush();
        }
    }

    @Override
    public void writeFacets(Stream<? extends FacetDefinition> facets, GeometryOutput out) {
        try (ObjWriter writer = this.createWriter(out);){
            ObjWriter.MeshBuffer meshBuffer = writer.meshBuffer(this.meshBufferBatchSize);
            Iterator it = facets.iterator();
            while (it.hasNext()) {
                meshBuffer.add((FacetDefinition)it.next());
            }
            meshBuffer.flush();
        }
    }

    private ObjWriter createWriter(GeometryOutput out) {
        ObjWriter writer = new ObjWriter(GeometryIOUtils.createBufferedWriter((GeometryOutput)out, (Charset)this.defaultCharset));
        writer.setLineSeparator(this.lineSeparator);
        writer.setDoubleFormat(this.doubleFormat);
        return writer;
    }
}

