/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.internal;

import org.apache.commons.geometry.euclidean.internal.Vectors;

public final class Matrices {
    private Matrices() {
    }

    public static double determinant(double a00, double a01, double a10, double a11) {
        return a00 * a11 - a01 * a10;
    }

    public static double determinant(double a00, double a01, double a02, double a10, double a11, double a12, double a20, double a21, double a22) {
        return a00 * a11 * a22 + a01 * a12 * a20 + a02 * a10 * a21 - (a00 * a12 * a21 + a01 * a10 * a22 + a02 * a11 * a20);
    }

    public static double checkDeterminantForInverse(double det) {
        if (!Vectors.isRealNonZero(det)) {
            throw Matrices.nonInvertibleTransform("matrix determinant is " + det);
        }
        return det;
    }

    public static double checkElementForInverse(double element) {
        if (!Double.isFinite(element)) {
            throw Matrices.nonInvertibleTransform("invalid matrix element: " + element);
        }
        return element;
    }

    private static IllegalStateException nonInvertibleTransform(String msg) {
        return new IllegalStateException("Matrix is not invertible; " + msg);
    }
}

