/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.web;

import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.TestAbstractConfiguration;
import org.apache.commons.configuration.web.ServletFilterConfiguration;
import org.junit.Test;

public class TestServletFilterConfiguration
extends TestAbstractConfiguration {
    protected AbstractConfiguration getConfiguration() {
        MockFilterConfig config = new MockFilterConfig();
        config.setInitParameter("key1", "value1");
        config.setInitParameter("key2", "value2");
        config.setInitParameter("list", "value1, value2");
        config.setInitParameter("listesc", "value1\\,value2");
        return new ServletFilterConfiguration((FilterConfig)config);
    }

    protected AbstractConfiguration getEmptyConfiguration() {
        return new ServletFilterConfiguration((FilterConfig)new MockFilterConfig());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddPropertyDirect() {
        super.testAddPropertyDirect();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testClearProperty() {
        super.testClearProperty();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MockFilterConfig
    implements FilterConfig {
        private Properties parameters = new Properties();

        private MockFilterConfig() {
        }

        public String getFilterName() {
            return null;
        }

        public ServletContext getServletContext() {
            return null;
        }

        public String getInitParameter(String key) {
            return this.parameters.getProperty(key);
        }

        public Enumeration<?> getInitParameterNames() {
            return this.parameters.keys();
        }

        public void setInitParameter(String key, String value) {
            this.parameters.setProperty(key, value);
        }
    }
}

