/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.sql.tests.javax.sql.rowset.serial;

import java.sql.Array;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.rowset.serial.SerialArray;
import javax.sql.rowset.serial.SerialException;
import junit.framework.TestCase;
import org.apache.harmony.sql.tests.javax.sql.rowset.serial.SerialArrayTest;

/*
 * Exception performing whole class analysis ignored.
 */
public class SerialArrayTest
extends TestCase {
    private MockArray mock = new MockArray(this);
    private SerialArray sa;
    Object[] testElements = new Object[4];
    Map<String, Class<?>> map = new HashMap();
    Map<String, Class<?>> badmap = new HashMap();

    protected void setUp() throws Exception {
        Class<?> clazz;
        Class<?> clazz2;
        super.setUp();
        this.testElements = new Object[4];
        this.testElements[0] = "test1";
        this.testElements[1] = "test2";
        this.testElements[2] = new SQLException();
        this.testElements[3] = new HashMap();
        this.sa = new SerialArray((Array)this.mock);
        this.map = new HashMap();
        try {
            clazz2 = Class.forName("org.apache.harmony.sql.tests.javax.sql.rowset.serial.SerialArrayTest$MockStringSQLData");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.map.put("String", clazz2);
        this.map.put("Object", null);
        this.badmap = new HashMap();
        try {
            clazz = Class.forName("java.util.HashMap");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.badmap.put("Something", clazz);
    }

    public void testConstructor_ObjectArray() throws SQLException {
        SerialArrayTest.assertNotNull((Object)new SerialArray((Array)new SQLArray()));
        this.sa = new SerialArray((Array)this.mock);
        try {
            this.sa = new SerialArray((Array)new MockNullArray(this));
            SerialArrayTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.testElements = new Object[5];
        this.testElements[0] = "test1";
        this.testElements[1] = "test2";
        this.testElements[2] = new SQLException();
        this.testElements[3] = new HashMap();
        try {
            this.sa = new SerialArray((Array)this.mock);
            SerialArrayTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.testElements[4] = new Object();
        try {
            this.sa = new SerialArray((Array)this.mock);
            SerialArrayTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void testConstructor_IntArray() throws SQLException {
        this.mock.basetype = 4;
        this.sa = new SerialArray((Array)this.mock);
        try {
            this.sa = new SerialArray((Array)new MockNullArray(this));
            SerialArrayTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.testElements = new Object[5];
        this.testElements[0] = "test1";
        this.testElements[1] = "test2";
        this.testElements[2] = new SQLException();
        this.testElements[3] = new HashMap();
        this.sa = new SerialArray((Array)this.mock);
        this.testElements[4] = new Object();
        this.sa = new SerialArray((Array)this.mock);
    }

    public void testConstructor_map() throws SQLException {
        try {
            this.sa = new SerialArray((Array)this.mock, null);
            SerialArrayTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.sa = new SerialArray((Array)new MockNullArray(this), null);
            SerialArrayTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.sa = new SerialArray((Array)this.mock, this.map);
        this.sa = new SerialArray((Array)this.mock, this.badmap);
    }

    public void testGetArray() throws SerialException {
        int i = 0;
        while (i < this.testElements.length) {
            SerialArrayTest.assertEquals((Object)this.testElements[i], (Object)((Object[])this.sa.getArray())[i]);
            ++i;
        }
    }

    public void testGetArrayMap() throws SerialException {
        int i = 0;
        while (i < this.testElements.length) {
            SerialArrayTest.assertSame((Object)this.testElements[i], (Object)((Object[])this.sa.getArray(null))[i]);
            ++i;
        }
        i = 0;
        while (i < this.testElements.length) {
            SerialArrayTest.assertSame((Object)this.testElements[i], (Object)((Object[])this.sa.getArray(this.map))[i]);
            ++i;
        }
        i = 0;
        while (i < this.testElements.length) {
            SerialArrayTest.assertSame((Object)this.testElements[i], (Object)((Object[])this.sa.getArray(this.badmap))[i]);
            ++i;
        }
    }

    public void testGetArrayLongInt() throws SerialException {
        int i = 0;
        while (i < this.testElements.length) {
            SerialArrayTest.assertEquals((Object)this.testElements[i], (Object)((Object[])this.sa.getArray(i, 1))[0]);
            ++i;
        }
    }

    public void testGetArrayLongIntMap() throws SerialException {
        int i = 0;
        while (i < this.testElements.length) {
            SerialArrayTest.assertSame((Object)this.testElements[i], (Object)((Object[])this.sa.getArray(i, 1, null))[0]);
            ++i;
        }
        i = 0;
        while (i < this.testElements.length) {
            SerialArrayTest.assertSame((Object)this.testElements[i], (Object)((Object[])this.sa.getArray(i, 1, this.map))[0]);
            ++i;
        }
        i = 0;
        while (i < this.testElements.length) {
            SerialArrayTest.assertSame((Object)this.testElements[i], (Object)((Object[])this.sa.getArray(i, 1, this.badmap))[0]);
            ++i;
        }
        this.mock.returnNull = true;
        i = 0;
        while (i < this.testElements.length) {
            SerialArrayTest.assertSame((Object)this.testElements[i], (Object)((Object[])this.sa.getArray(i, 1, this.map))[0]);
            ++i;
        }
    }

    public void testGetArrayMapOfStringClassOfQ() throws SerialException {
        int i = 0;
        while (i < this.testElements.length) {
            SerialArrayTest.assertSame((Object)this.testElements[i], (Object)((Object[])this.sa.getArray(this.badmap))[i]);
            ++i;
        }
        i = 0;
        while (i < this.testElements.length) {
            SerialArrayTest.assertSame((Object)this.testElements[i], (Object)((Object[])this.sa.getArray(this.map))[i]);
            ++i;
        }
        this.mock.returnNull = true;
        i = 0;
        while (i < this.testElements.length) {
            SerialArrayTest.assertSame((Object)this.testElements[i], (Object)((Object[])this.sa.getArray(this.map))[i]);
            ++i;
        }
    }

    public void testGetBaseType() throws SerialException {
        SerialArrayTest.assertEquals((int)2000, (int)this.sa.getBaseType());
    }

    public void testGetBaseTypeName() throws SQLException {
        SerialArrayTest.assertEquals((String)"BaseName", (String)this.sa.getBaseTypeName());
    }

    public void testGetResultSet() throws SQLException {
        try {
            this.sa.getResultSet();
            SerialArrayTest.fail((String)"should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testGetResultSetLongInt() throws SQLException {
        try {
            this.sa.getResultSet(0L, 1);
            SerialArrayTest.fail((String)"should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testGetResultSetLongIntMapOfStringClassOfQ() throws SQLException {
        try {
            this.sa.getResultSet(0L, 1, null);
            SerialArrayTest.fail((String)"should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testGetResultSetMapOfStringClassOfQ() throws SerialException {
        try {
            this.sa.getResultSet(null);
            SerialArrayTest.fail((String)"should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

