/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.collections4.iterators.ExtendedIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ExtendedIteratorTest {
    private List<Integer> collectionA;

    @BeforeEach
    public void setUp() {
        this.collectionA = new ArrayList<Integer>();
        this.collectionA.add(1);
        this.collectionA.add(2);
        this.collectionA.add(3);
        this.collectionA.add(4);
        this.collectionA.add(5);
        this.collectionA.add(6);
    }

    @Test
    public void testAddTo() {
        ArrayList<Integer> expected = new ArrayList<Integer>(this.collectionA);
        expected.addAll(this.collectionA);
        List actual = (List)ExtendedIterator.create(this.collectionA.iterator()).addTo(new ArrayList<Integer>(this.collectionA));
        Assertions.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testAndThen() {
        Iterator<Integer> iter1 = Arrays.asList(1, 2, 3).iterator();
        Iterator<Integer> iter2 = Arrays.asList(4, 5, 6).iterator();
        ExtendedIterator underTest = ExtendedIterator.create(iter1).andThen(iter2);
        ArrayList actual = new ArrayList();
        underTest.forEachRemaining(actual::add);
        Assertions.assertEquals(this.collectionA, actual);
    }

    @Test
    public void testCreate() {
        ExtendedIterator iter = ExtendedIterator.create(this.collectionA.iterator());
        ArrayList actual = new ArrayList();
        iter.forEachRemaining(actual::add);
        Assertions.assertEquals(this.collectionA, actual);
    }

    @Test
    public void testCreateNoRemove() {
        ExtendedIterator iter = ExtendedIterator.createNoRemove(this.collectionA.iterator());
        Assertions.assertThrows(UnsupportedOperationException.class, ((Iterator)iter)::remove);
    }

    @Test
    public void testCreateWithStream() {
        ExtendedIterator iter = ExtendedIterator.create(this.collectionA.stream());
        Assertions.assertThrows(UnsupportedOperationException.class, ((Iterator)iter)::remove);
        ArrayList actual = new ArrayList();
        iter.forEachRemaining(actual::add);
        Assertions.assertEquals(this.collectionA, actual);
    }

    @Test
    public void testEmptyIterator() {
        Assertions.assertFalse((boolean)ExtendedIterator.emptyIterator().hasNext());
    }

    @Test
    public void testFilter() {
        List<Integer> expected = Arrays.asList(2, 4, 6);
        Predicate<Integer> predicate = i -> i % 2 == 0;
        ExtendedIterator underTest = ExtendedIterator.create(this.collectionA.iterator()).filter(predicate);
        ArrayList actual = new ArrayList();
        underTest.forEachRemaining(actual::add);
        Assertions.assertEquals(expected, actual);
    }

    @Test
    public void testFlatten() {
        Iterator<Iterator> iteratorIterator = Arrays.asList(Arrays.asList(1, 2, 3).iterator(), Arrays.asList(4, 5, 6).iterator()).iterator();
        ExtendedIterator iter = ExtendedIterator.flatten(iteratorIterator);
        ArrayList actual = new ArrayList();
        iter.forEachRemaining(actual::add);
        Assertions.assertEquals(this.collectionA, actual);
    }

    @Test
    public void testMap() {
        List<Double> expected = Arrays.asList(0.5, 1.0, 1.5, 2.0, 2.5, 3.0);
        Function<Integer, Double> function = i -> (double)i.intValue() / 2.0;
        ExtendedIterator underTest = ExtendedIterator.create(this.collectionA.iterator()).map(function);
        ArrayList actual = new ArrayList();
        underTest.forEachRemaining(actual::add);
        Assertions.assertEquals(expected, actual);
    }

    @Test
    public void testRemove() {
        ExtendedIterator iter = ExtendedIterator.create(this.collectionA.iterator());
        Integer i = (Integer)iter.next();
        iter.remove();
        Assertions.assertFalse((boolean)this.collectionA.contains(i));
        ArrayList actual = new ArrayList();
        iter.forEachRemaining(actual::add);
        Assertions.assertEquals(this.collectionA, actual);
    }

    @Test
    public void testRemoveNext() {
        ExtendedIterator iter = ExtendedIterator.create(this.collectionA.iterator());
        Integer i = (Integer)iter.removeNext();
        Assertions.assertFalse((boolean)this.collectionA.contains(i));
        ArrayList actual = new ArrayList();
        iter.forEachRemaining(actual::add);
        Assertions.assertEquals(this.collectionA, actual);
    }
}

