/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.celeborn.plugin.flink.buffer.BufferHeader;
import org.apache.celeborn.plugin.flink.utils.Utils;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;

public class BufferUtils {
    public static final int HEADER_LENGTH_PREFIX = 16;
    public static final int HEADER_LENGTH = 22;

    public static void setCompressedDataWithHeader(Buffer buffer, Buffer compressedBuffer) {
        Utils.checkArgument(buffer != null, "Must be not null.");
        Utils.checkArgument(buffer.getReaderIndex() == 0, "Illegal reader index.");
        boolean isCompressed = compressedBuffer != null && compressedBuffer.isCompressed();
        int dataLength = isCompressed ? compressedBuffer.readableBytes() : buffer.readableBytes() - 22;
        ByteBuf byteBuf = buffer.asByteBuf();
        BufferUtils.setBufferHeader(byteBuf, buffer.getDataType(), isCompressed, dataLength);
        if (isCompressed) {
            byteBuf.writeBytes(compressedBuffer.asByteBuf());
        }
        buffer.setSize(dataLength + 22);
    }

    public static void setBufferHeader(ByteBuf byteBuf, Buffer.DataType dataType, boolean isCompressed, int dataLength) {
        byteBuf.writerIndex(0);
        byteBuf.writeInt(0);
        byteBuf.writeInt(0);
        byteBuf.writeInt(0);
        byteBuf.writeInt(0);
        byteBuf.writeByte(dataType.ordinal());
        byteBuf.writeBoolean(isCompressed);
        byteBuf.writeInt(dataLength);
    }

    public static BufferHeader getBufferHeader(Buffer buffer, int position) {
        return BufferUtils.getBufferHeader(buffer, position, false);
    }

    public static BufferHeader getBufferHeader(Buffer buffer, int position, boolean isFirst) {
        ByteBuf byteBuf = buffer.asByteBuf();
        byteBuf.readerIndex(position);
        if (!isFirst) {
            return new BufferHeader(Buffer.DataType.values()[byteBuf.readByte()], byteBuf.readBoolean(), byteBuf.readInt());
        }
        return new BufferHeader(byteBuf.readInt(), byteBuf.readInt(), byteBuf.readInt(), byteBuf.readInt(), Buffer.DataType.values()[byteBuf.readByte()], byteBuf.readBoolean(), byteBuf.readInt());
    }

    public static void reserveNumRequiredBuffers(BufferPool bufferPool, int numRequiredBuffers) throws IOException {
        long startTime = System.nanoTime();
        ArrayList<MemorySegment> buffers = new ArrayList<MemorySegment>(numRequiredBuffers);
        try {
            while (buffers.size() < numRequiredBuffers) {
                MemorySegment segment = bufferPool.requestMemorySegment();
                if (segment != null) {
                    buffers.add(segment);
                    continue;
                }
                Thread.sleep(10L);
                if (System.nanoTime() - startTime <= TimeUnit.MINUTES.toNanos(3L)) continue;
                throw new IOException("Could not allocate the required number of buffers in 3 minutes.");
            }
        }
        catch (Throwable throwable) {
            try {
                throw new IOException(throwable);
            }
            catch (Throwable throwable2) {
                buffers.forEach(arg_0 -> ((BufferPool)bufferPool).recycle(arg_0));
                throw throwable2;
            }
        }
        buffers.forEach(arg_0 -> ((BufferPool)bufferPool).recycle(arg_0));
    }
}

