/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.shaded.org.roaringbitmap.insights;

import java.util.Collection;
import org.apache.celeborn.shaded.org.roaringbitmap.ContainerPointer;
import org.apache.celeborn.shaded.org.roaringbitmap.RoaringBitmap;
import org.apache.celeborn.shaded.org.roaringbitmap.insights.BitmapStatistics;

public class BitmapAnalyser {
    public static BitmapStatistics analyse(RoaringBitmap r) {
        int acCount = 0;
        int acCardinalitySum = 0;
        int bcCount = 0;
        int rcCount = 0;
        ContainerPointer cp = r.getContainerPointer();
        while (cp.getContainer() != null) {
            if (cp.isBitmapContainer()) {
                ++bcCount;
            } else if (cp.isRunContainer()) {
                ++rcCount;
            } else {
                ++acCount;
                acCardinalitySum += cp.getCardinality();
            }
            cp.advance();
        }
        BitmapStatistics.ArrayContainersStats acStats = new BitmapStatistics.ArrayContainersStats(acCount, acCardinalitySum);
        return new BitmapStatistics(acStats, bcCount, rcCount);
    }

    public static BitmapStatistics analyse(Collection<? extends RoaringBitmap> bitmaps) {
        return bitmaps.stream().reduce(BitmapStatistics.empty, (acc2, r) -> acc2.merge(BitmapAnalyser.analyse(r)), BitmapStatistics::merge);
    }
}

